/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat;

import java.text.NumberFormat;
import org.broadinstitute.genee.math.stat.function.UnivariateFloatFunction;

public class Line
implements UnivariateFloatFunction {
    final float m;
    final float b;
    final String string;

    public Line(float m, float b) {
        this.m = m;
        this.b = b;
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        this.string = "y = " + nf.format(m) + "*x " + " + " + nf.format(b);
    }

    @Override
    public float evaluate(float x) {
        return this.m * x + this.b;
    }

    public float getB() {
        return this.b;
    }

    public float getM() {
        return this.m;
    }

    public String toString() {
        return this.string;
    }
}

