/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat.function;

import org.broadinstitute.genee.math.stat.function.FloatListFunction;
import org.broadinstitute.genee.matrix.ArrayFloatList;
import org.broadinstitute.genee.matrix.FloatList;

public class Max
implements FloatListFunction {
    @Override
    public float evaluate(FloatList list) {
        return Max.max(list);
    }

    public static float max(FloatList list) {
        float max = -3.4028235E38f;
        boolean nonNanFound = false;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            float d = list.getValue(i);
            if (Float.isNaN(d)) continue;
            nonNanFound = true;
            max = d > max ? d : max;
        }
        return nonNanFound ? max : Float.NaN;
    }

    public static float evaluate(float[] values) {
        return Max.max(new ArrayFloatList(values));
    }

    public String toString() {
        return "Max";
    }
}

