/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat.function;

import org.broadinstitute.genee.math.stat.function.FloatListFunction;
import org.broadinstitute.genee.matrix.FloatList;

public class Mean
implements FloatListFunction {
    @Override
    public float evaluate(FloatList list) {
        return Mean.mean(list);
    }

    public static float mean(FloatList list) {
        float sum = 0.0f;
        int count = 0;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            float d = list.getValue(i);
            if (Float.isNaN(d)) continue;
            sum += d;
            ++count;
        }
        return count == 0 ? Float.NaN : sum / (float)count;
    }

    public String toString() {
        return "Mean";
    }
}

