/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat.function.bivariate;

import org.broadinstitute.genee.math.stat.function.bivariate.BivariateFloatListFunction;
import org.broadinstitute.genee.matrix.FloatList;

public class CosineSimilarity
implements BivariateFloatListFunction {
    @Override
    public float evaluate(FloatList xList, FloatList yList) {
        if (xList.size() != yList.size()) {
            throw new IllegalArgumentException("Size of lists must be equal.");
        }
        float mag_x = 0.0f;
        float mag_y = 0.0f;
        float sum = 0.0f;
        int size = xList.size();
        for (int ind = 0; ind < size; ++ind) {
            float x = xList.getValue(ind);
            float y = yList.getValue(ind);
            if (Float.isNaN(x) || Float.isNaN(y)) continue;
            mag_x += x * x;
            mag_y += y * y;
            sum += x * y;
        }
        return (float)((double)sum / Math.sqrt(mag_x * mag_y));
    }

    public String toString() {
        return "Cosine Similarity";
    }
}

