/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat.function.bivariate;

import org.broadinstitute.genee.math.stat.function.bivariate.BivariateFloatListFunction;
import org.broadinstitute.genee.matrix.FloatList;

public class JaccardDistance
implements BivariateFloatListFunction {
    @Override
    public float evaluate(FloatList listOne, FloatList listTwo) {
        float orCount = 0.0f;
        float andCount = 0.0f;
        int size = listOne.size();
        for (int i = 0; i < size; ++i) {
            boolean y;
            boolean x = listOne.getValue(i) > 0.0f;
            boolean bl = y = listTwo.getValue(i) > 0.0f;
            if (x && y) {
                andCount += 1.0f;
                continue;
            }
            if (!x && !y) continue;
            orCount += 1.0f;
        }
        return (orCount - andCount) / orCount;
    }

    public String toString() {
        return "Jaccard distance";
    }
}

