/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat.function.bivariate;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Pair;
import org.broadinstitute.genee.math.stat.function.bivariate.BivariateFloatListFunction;
import org.broadinstitute.genee.matrix.FloatList;

public class KendallsTauCorrelation
implements BivariateFloatListFunction {
    @Override
    public float evaluate(FloatList xArray, FloatList yArray) {
        if (xArray.size() != yArray.size()) {
            throw new DimensionMismatchException(xArray.size(), yArray.size());
        }
        int n = xArray.size();
        long numPairs = KendallsTauCorrelation.sum(n - 1);
        Pair[] pairs = new Pair[n];
        for (int i = 0; i < n; ++i) {
            pairs[i] = new Pair((Object)Float.valueOf(xArray.getValue(i)), (Object)Float.valueOf(yArray.getValue(i)));
        }
        Arrays.sort(pairs, new Comparator<Pair<Float, Float>>(){

            @Override
            public int compare(Pair<Float, Float> pair1, Pair<Float, Float> pair2) {
                int compareFirst = ((Float)pair1.getKey()).compareTo((Float)pair2.getKey());
                return compareFirst != 0 ? compareFirst : ((Float)pair1.getValue()).compareTo((Float)pair2.getValue());
            }
        });
        long tiedXPairs = 0L;
        long tiedXYPairs = 0L;
        long consecutiveXTies = 1L;
        long consecutiveXYTies = 1L;
        Pair prev = pairs[0];
        for (int i = 1; i < n; ++i) {
            Pair curr = pairs[i];
            if (((Float)curr.getKey()).equals(prev.getKey())) {
                ++consecutiveXTies;
                if (((Float)curr.getValue()).equals(prev.getValue())) {
                    ++consecutiveXYTies;
                } else {
                    tiedXYPairs += KendallsTauCorrelation.sum(consecutiveXYTies - 1L);
                    consecutiveXYTies = 1L;
                }
            } else {
                tiedXPairs += KendallsTauCorrelation.sum(consecutiveXTies - 1L);
                consecutiveXTies = 1L;
                tiedXYPairs += KendallsTauCorrelation.sum(consecutiveXYTies - 1L);
                consecutiveXYTies = 1L;
            }
            prev = curr;
        }
        tiedXPairs += KendallsTauCorrelation.sum(consecutiveXTies - 1L);
        tiedXYPairs += KendallsTauCorrelation.sum(consecutiveXYTies - 1L);
        int swaps = 0;
        Pair[] pairsDestination = new Pair[n];
        for (int segmentSize = 1; segmentSize < n; segmentSize <<= 1) {
            for (int offset = 0; offset < n; offset += 2 * segmentSize) {
                int iEnd;
                int i = offset;
                int j = iEnd = FastMath.min((int)(i + segmentSize), (int)n);
                int jEnd = FastMath.min((int)(j + segmentSize), (int)n);
                int copyLocation = offset;
                while (i < iEnd || j < jEnd) {
                    if (i < iEnd) {
                        if (j < jEnd) {
                            if (((Float)pairs[i].getValue()).compareTo((Float)pairs[j].getValue()) <= 0) {
                                pairsDestination[copyLocation] = pairs[i];
                                ++i;
                            } else {
                                pairsDestination[copyLocation] = pairs[j];
                                ++j;
                                swaps += iEnd - i;
                            }
                        } else {
                            pairsDestination[copyLocation] = pairs[i];
                            ++i;
                        }
                    } else {
                        pairsDestination[copyLocation] = pairs[j];
                        ++j;
                    }
                    ++copyLocation;
                }
            }
            Pair[] pairsTemp = pairs;
            pairs = pairsDestination;
            pairsDestination = pairsTemp;
        }
        long tiedYPairs = 0L;
        long consecutiveYTies = 1L;
        prev = pairs[0];
        for (int i = 1; i < n; ++i) {
            Pair curr = pairs[i];
            if (((Float)curr.getValue()).equals(prev.getValue())) {
                ++consecutiveYTies;
            } else {
                tiedYPairs += KendallsTauCorrelation.sum(consecutiveYTies - 1L);
                consecutiveYTies = 1L;
            }
            prev = curr;
        }
        long concordantMinusDiscordant = numPairs - tiedXPairs - (tiedYPairs += KendallsTauCorrelation.sum(consecutiveYTies - 1L)) + tiedXYPairs - (long)(2 * swaps);
        float nonTiedPairsMultiplied = (float)(numPairs - tiedXPairs) * (float)(numPairs - tiedYPairs);
        return (float)((double)concordantMinusDiscordant / FastMath.sqrt((double)nonTiedPairsMultiplied));
    }

    private static long sum(long n) {
        return n * (n + 1L) / 2L;
    }

    public String toString() {
        return "Kendall's tau";
    }
}

