/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat.function.bivariate;

import org.broadinstitute.genee.math.stat.function.Mean;
import org.broadinstitute.genee.math.stat.function.StandardDeviation;
import org.broadinstitute.genee.math.stat.function.bivariate.BivariateFloatListFunction;
import org.broadinstitute.genee.matrix.FloatList;

public class L1000S2N
implements BivariateFloatListFunction {
    protected Mean mean = new Mean();
    protected float percent = 0.025f;
    protected boolean qnorm;
    protected StandardDeviation standardDeviation = new StandardDeviation();

    public L1000S2N(boolean qnorm) {
        this.qnorm = qnorm;
    }

    @Override
    public float evaluate(FloatList list1, FloatList list2) {
        if (list1.size() == 1 || list2.size() == 1) {
            float class1Mean = this.mean.evaluate(list1);
            float class2Mean = this.mean.evaluate(list2);
            if (this.qnorm && class1Mean < 6.0f && class2Mean < 6.0f) {
                return 0.0f;
            }
            return class1Mean - class2Mean;
        }
        float class1Mean = this.mean.evaluate(list1);
        float class2Mean = this.mean.evaluate(list2);
        float class1Std = this.standardDeviation(list1, class1Mean);
        float class2Std = this.standardDeviation(list2, class2Mean);
        return (class1Mean - class2Mean) / (class1Std + class2Std);
    }

    private float standardDeviation(FloatList list, float mean) {
        float std = this.standardDeviation.evaluate(list, mean);
        if (list.size() < 10) {
            std = Math.max(this.percent, Math.max(std, this.percent * Math.abs(mean)));
        } else if (std == 0.0f) {
            std = this.percent;
        }
        return std;
    }
}

