/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat.function.bivariate;

import gnu.trove.list.array.TDoubleArrayList;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.apache.commons.math3.stat.ranking.NaNStrategy;
import org.apache.commons.math3.stat.ranking.NaturalRanking;
import org.broadinstitute.genee.math.stat.function.bivariate.BivariateFloatListFunction;
import org.broadinstitute.genee.matrix.FloatList;

public class SpearmanCorrelation
implements BivariateFloatListFunction {
    private PearsonsCorrelation corr = new PearsonsCorrelation();

    @Override
    public float evaluate(FloatList data1, FloatList data2) {
        if (data1.size() != data2.size()) {
            throw new IllegalArgumentException("Size of lists must be equal.");
        }
        int n = data1.size();
        TDoubleArrayList a1 = new TDoubleArrayList();
        TDoubleArrayList a2 = new TDoubleArrayList();
        for (int i = 0; i < n; ++i) {
            float f1 = data1.getValue(i);
            float f2 = data2.getValue(i);
            if (Float.isNaN(f1) || Float.isNaN(f2)) continue;
            a1.add((double)f1);
            a2.add((double)f2);
        }
        if (a1.size() == 0) {
            return Float.NaN;
        }
        return (float)this.corr.correlation(new NaturalRanking(NaNStrategy.FIXED).rank(a1.toArray()), new NaturalRanking(NaNStrategy.FIXED).rank(a2.toArray()));
    }

    public String toString() {
        return "Spearman rank correlation";
    }
}

