/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat.function.bivariate;

import org.broadinstitute.genee.math.stat.function.StandardDeviation;
import org.broadinstitute.genee.math.stat.function.bivariate.AbstractTwoClassStatistic;
import org.broadinstitute.genee.matrix.FloatList;

public class TTest
extends AbstractTwoClassStatistic {
    @Override
    public float evaluate(FloatList list, FloatList list2) {
        float class1Mean = this.useMedian ? this.percentile.evaluate(list) : this.mean.evaluate(list);
        float class2Mean = this.useMedian ? this.percentile.evaluate(list2) : this.mean.evaluate(list2);
        float class1Std = this.standardDeviation.evaluate(list, class1Mean);
        float class2Std = this.standardDeviation.evaluate(list2, class2Mean);
        if (class1Std == 0.0f && class2Std == 0.0f) {
            return 0.0f;
        }
        if (this.minStandardDeviation) {
            class1Std = StandardDeviation.thresholdStandardDeviation(class1Mean, class1Std, this.minStandardDeviationPercent);
            class2Std = StandardDeviation.thresholdStandardDeviation(class2Mean, class2Std, this.minStandardDeviationPercent);
        }
        float Sxi = (float)((double)(class1Mean - class2Mean) / Math.sqrt(class1Std * class1Std / (float)list.size() + class2Std * class2Std / (float)list2.size()));
        return Sxi;
    }

    public String toString() {
        return "T-Test" + (this.useMedian ? " (median)" : "");
    }
}

