/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat.function.multivariate;

import org.broadinstitute.genee.math.FloatListStatUtils;
import org.broadinstitute.genee.math.stat.function.multivariate.MultivariateFloatListFunction;
import org.broadinstitute.genee.matrix.FloatList;

public class BivariateMedian1MinusMedian2
implements MultivariateFloatListFunction {
    @Override
    public float evaluate(FloatList ... lists) {
        float median1 = FloatListStatUtils.percentile(lists[0], 50);
        float median2 = FloatListStatUtils.percentile(lists[1], 50);
        return median1 - median2;
    }

    public String toString() {
        return "Median(set 1) - Median(set 2)";
    }

    @Override
    public int getParameterCount() {
        return 2;
    }

    @Override
    public String getParameterName(int index) {
        return index == 0 ? "Median(set 1)" : "Median(set 2)";
    }

    @Override
    public String getOperationName(int index) {
        return "-";
    }
}

