/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import org.broadinstitute.genee.matrix.Vector;

public class CombinedVector
implements Vector {
    private Vector vector1;
    private Vector vector2;

    public CombinedVector(Vector vector1, Vector vector2) {
        this.vector1 = vector1;
        this.vector2 = vector2;
    }

    @Override
    public Class<?> getColumnClass() {
        return this.vector1.getColumnClass();
    }

    @Override
    public Comparator<Object> getComparator() {
        return this.vector1.getComparator();
    }

    @Override
    public String getName() {
        return this.vector1.getName();
    }

    @Override
    public Object getProperty(Object key) {
        Object value = this.vector1.getProperty(key);
        return value != null ? value : this.vector2.getProperty(key);
    }

    @Override
    public Collection<Object> getPropertyKeys() {
        HashSet<Object> keys = new HashSet<Object>(this.vector1.getPropertyKeys());
        keys.addAll(this.vector2.getPropertyKeys());
        return keys;
    }

    @Override
    public Object getValue(int index) {
        return index < this.vector1.size() ? this.vector1.getValue(index) : this.vector2.getValue(index - this.vector1.size());
    }

    @Override
    public void setColumnClass(Class<?> columnClass) {
        this.vector1.setColumnClass(columnClass);
        this.vector2.setColumnClass(columnClass);
    }

    @Override
    public void setComparator(Comparator<Object> comparator) {
        this.vector1.setComparator(comparator);
        this.vector2.setComparator(comparator);
    }

    @Override
    public void setProperty(Object key, Object value) {
        this.vector1.setProperty(key, value);
        this.vector2.setProperty(key, value);
    }

    @Override
    public void removeProperty(Object key) {
        this.vector1.removeProperty(key);
        this.vector2.removeProperty(key);
    }

    @Override
    public void setValue(int index, Object value) {
        if (index < this.vector1.size()) {
            this.vector1.setValue(index, value);
        } else {
            this.vector2.setValue(index - this.vector1.size(), value);
        }
    }

    @Override
    public int size() {
        return this.vector1.size() + this.vector2.size();
    }

    public String toString() {
        return this.vector1.toString();
    }
}

