/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import com.google.common.base.Predicate;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Color;
import java.io.File;
import java.io.PrintWriter;
import java.net.URL;
import java.text.DateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.broadinstitute.genee.category.VectorColorModel;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataModelColumnView;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;
import org.broadinstitute.genee.stats.Sorting;

public class MetadataUtil {
    public static final String CHART_COLOR_ENABLED_KEY = "Chart Color Enabled";
    public static final String CHART_COLOR_KEY = "Chart Color";
    public static final String CHART_STYLE_KEY = "Chart Style";
    public static final String COLOR_VISIBLE_KEY = "Color Visible";
    public static final String CONTINUOUS_KEY = "Continuous Key";
    public static final String SHOW_IN_DATASET_KEY = "In Dataset";
    public static final int STYLE_BARS = 64;
    public static final int STYLE_LINES = 2;
    public static final int STYLE_POINTS = 4;
    public static final int STYLE_RANGE_HORIZONTAL = 8;
    public static final String TEXT_COLOR_VISIBLE_KEY = "Text Color Visible";
    public static final String TEXT_VISIBLE_KEY = "Text Visible";
    public static final String TOOLTIP_VISIBLE_KEY = "Tooltip Visible";
    private static final Set<String> DEFAULT_METADATA_COLOR = new HashSet<String>(Arrays.asList("cell_id", "pert_idose", "pert_dose", "pert_itime", "pert_time", "signature"));
    private static final Set<String> DEFAULT_METADATA_HIDE_ALL = new HashSet<String>(Arrays.asList("array id", "gene id"));
    private static final Set<String> DEFAULT_METADATA_TEXT = new HashSet<String>(Arrays.asList("id", "Id", "Name", "ID", "pert_desc", "pert_dose", "pert_dose_unit", "pert_time", "pert_time_unit", "baseline_expr_log2", "pr_id", "id", "pr_gene_symbol", "pr_is_lm", "is_lm", "pert_id", "pert_iname", "pert_desc", "Description", "gene_space", "pert_type"));

    private MetadataUtil() {
    }

    public static Vector addColumnVector(MetadataModel model, String name, Class<?> c) {
        return MetadataUtil.addColumnVector(model, name, c, false);
    }

    public static Vector addColumnVector(MetadataModel model, String name, Class<?> c, boolean ensureUnique) {
        name = ensureUnique ? MetadataUtil.createUniqueName(model, name) : name;
        Vector v = model.add(name, c);
        boolean hide = DEFAULT_METADATA_HIDE_ALL.contains(name);
        v.setProperty(TOOLTIP_VISIBLE_KEY, !hide);
        v.setProperty(COLOR_VISIBLE_KEY, !hide);
        if (Number.class.isAssignableFrom(c)) {
            v.setProperty(CONTINUOUS_KEY, true);
        }
        return v;
    }

    public static Vector addRowVector(MetadataModel model, String name, Class<?> c) {
        return MetadataUtil.addRowVector(model, name, c, false);
    }

    public static Vector addRowVector(MetadataModel model, String name, Class<?> c, boolean ensureUnique) {
        name = ensureUnique ? MetadataUtil.createUniqueName(model, name) : name;
        Vector v = model.add(name, c);
        boolean hide = DEFAULT_METADATA_HIDE_ALL.contains(name);
        v.setProperty(TOOLTIP_VISIBLE_KEY, !hide);
        v.setProperty(TEXT_VISIBLE_KEY, !hide);
        if (Number.class.isAssignableFrom(c)) {
            v.setProperty(CONTINUOUS_KEY, true);
        }
        return v;
    }

    public static void addVectors(MetadataModel srcModel, MetadataModel destModel, String[] fields) {
        for (String field : fields) {
            Vector src = srcModel.get(field);
            Vector copy = destModel.add(field, src.getColumnClass());
            copy.setComparator(src.getComparator());
            VectorUtil.copyProperties(src, copy);
        }
    }

    public static List<Vector> asList(final MetadataModel model) {
        return new AbstractList<Vector>(){

            @Override
            public Vector get(int index) {
                return model.get(index);
            }

            @Override
            public int size() {
                return model.getMetadataCount();
            }
        };
    }

    public static void copy(MetadataModel src, MetadataModel dest) {
        int j;
        if (src.getItemCount() != dest.getItemCount()) {
            throw new IllegalArgumentException("Item count not equal in source and destination. " + src.getItemCount() + " != " + dest.getItemCount());
        }
        int itemCount = src.getItemCount();
        int metadataColumns = src.getMetadataCount();
        for (j = 0; j < metadataColumns; ++j) {
            Vector srcColumn = src.get(j);
            Vector destColumn = dest.get(src.getColumnName(j));
            if (destColumn == null) {
                destColumn = dest.add(src.getColumnName(j), src.get(j).getColumnClass());
            }
            MetadataUtil.copyProperties(srcColumn, destColumn);
        }
        for (j = 0; j < metadataColumns; ++j) {
            int destColumnIndex = dest.getColumnIndex(src.getColumnName(j));
            int srcColumnIndex = src.getColumnIndex(src.getColumnName(j));
            for (int i = 0; i < itemCount; ++i) {
                dest.setValue(i, destColumnIndex, src.getValue(i, srcColumnIndex));
            }
        }
    }

    public static void copyProperties(Vector srcColumn, Vector destColumn) {
        Collection<Object> keys = srcColumn.getPropertyKeys();
        for (Object key : keys) {
            destColumn.setProperty(key, srcColumn.getProperty(key));
        }
        destColumn.setComparator(srcColumn.getComparator());
    }

    public static String createUniqueName(MetadataModel metadata, String name) {
        int counter = 1;
        String uniqueName = name;
        while (metadata.getColumnIndex(uniqueName) != -1) {
            uniqueName = name + "-" + counter;
            ++counter;
        }
        return uniqueName;
    }

    public static MetadataModel filter(MetadataModel metadata, Object key) {
        ArrayList<Sorting.FloatIntPair> indicesAndSort = new ArrayList<Sorting.FloatIntPair>();
        String orderKey = key + "_order";
        int ncols = metadata.getMetadataCount();
        for (int j = 0; j < ncols; ++j) {
            Number order;
            Vector v = metadata.get(j);
            Object val = v.getProperty(key);
            if (val == null) continue;
            if (val instanceof Boolean) {
                if (!((Boolean)val).booleanValue()) continue;
                order = (Number)v.getProperty(orderKey);
                indicesAndSort.add(new Sorting.FloatIntPair(order != null ? order.floatValue() : (float)j, j));
                continue;
            }
            order = (Number)v.getProperty(orderKey);
            indicesAndSort.add(new Sorting.FloatIntPair(order != null ? order.floatValue() : (float)j, j));
        }
        Collections.sort(indicesAndSort);
        int[] indices = new int[indicesAndSort.size()];
        int size = indices.length;
        for (int i = 0; i < size; ++i) {
            indices[i] = ((Sorting.FloatIntPair)indicesAndSort.get(i)).getIndex();
        }
        MetadataModelColumnView view = new MetadataModelColumnView(metadata, indices);
        return view;
    }

    public static int[] find(Vector[] vectors, Predicate[] predicates) {
        TIntArrayList indices = new TIntArrayList();
        int size = vectors[0].size();
        for (int i = 0; i < size; ++i) {
            boolean matches = true;
            int length = vectors.length;
            for (int j = 0; j < length; ++j) {
                if (predicates[j].apply(vectors[j].getValue(i))) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            indices.add(i);
        }
        return indices.toArray();
    }

    public static boolean getBoolean(Vector column, Object key) {
        Object val = column.getProperty(key);
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        return val != null;
    }

    public static Vector getByIName(MetadataModel model, String name) {
        int n = model.getMetadataCount();
        for (int i = 0; i < n; ++i) {
            Vector v = model.get(i);
            if (!name.equalsIgnoreCase(v.getName())) continue;
            return v;
        }
        return null;
    }

    public static MetadataModel getCategoryColumns(MetadataModel metadata) {
        return MetadataUtil.filter(metadata, COLOR_VISIBLE_KEY);
    }

    public static MetadataModel getChartColumns(MetadataModel metadata) {
        return MetadataUtil.filter(metadata, CHART_STYLE_KEY);
    }

    public static List<String> getColumnNames(MetadataModel metadata, Class<?> c) {
        ArrayList<String> list = new ArrayList<String>();
        int cols = metadata.getMetadataCount();
        for (int j = 0; j < cols; ++j) {
            if (!c.isAssignableFrom(metadata.get(j).getColumnClass())) continue;
            list.add(metadata.getColumnName(j));
        }
        Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
        return list;
    }

    public static MetadataModel getColumns(MetadataModel metadata, Class<?> c) {
        TIntArrayList indices = new TIntArrayList();
        int ncols = metadata.getMetadataCount();
        for (int j = 0; j < ncols; ++j) {
            if (!c.isAssignableFrom(metadata.get(j).getColumnClass())) continue;
            indices.add(j);
        }
        return new MetadataModelColumnView(metadata, indices.toArray());
    }

    public static int[] getIndices(MetadataModel model, List<String> names, boolean removeNotFoundNames) {
        TIntArrayList indices = new TIntArrayList();
        for (String name : names) {
            int index = model.getColumnIndex(name);
            if (index != -1) {
                indices.add(index);
                continue;
            }
            if (removeNotFoundNames) continue;
            throw new IllegalArgumentException(name + " not found.");
        }
        return indices.toArray();
    }

    public static String getMetadataName(MetadataModel metadata, Class<?> c) {
        int size = metadata.getMetadataCount();
        for (int i = 0; i < size; ++i) {
            if (!c.isAssignableFrom(metadata.get(i).getColumnClass())) continue;
            return metadata.getColumnName(i);
        }
        return null;
    }

    public static List<Integer> getMetadataStartsWith(MetadataModel metadata, String text) {
        text = text.toLowerCase();
        ArrayList<Integer> list = new ArrayList<Integer>();
        int ncols = metadata.getMetadataCount();
        for (int i = 0; i < ncols; ++i) {
            String name = metadata.getColumnName(i);
            String lc = name.toLowerCase();
            if (!lc.startsWith(text)) continue;
            list.add(i);
        }
        return list;
    }

    public static List<String> getNames(MetadataModel metadata) {
        ArrayList<String> names = new ArrayList<String>();
        int size = metadata.getMetadataCount();
        for (int i = 0; i < size; ++i) {
            names.add(metadata.getColumnName(i));
        }
        Collections.sort(names, String.CASE_INSENSITIVE_ORDER);
        return names;
    }

    public static MetadataModel getTextColumns(MetadataModel metadata) {
        TIntArrayList indices = new TIntArrayList();
        int ncols = metadata.getMetadataCount();
        for (int j = 0; j < ncols; ++j) {
            if (!MetadataUtil.isTextVisible(metadata.get(j))) continue;
            indices.add(j);
        }
        return new MetadataModelColumnView(metadata, indices.toArray());
    }

    public static Vector[] getVectors(MetadataModel metadata, String[] names) {
        Vector[] vectors = new Vector[names.length];
        int ncols = names.length;
        for (int j = 0; j < ncols; ++j) {
            vectors[j] = metadata.get(names[j]);
        }
        return vectors;
    }

    public static boolean isColorVisible(Vector column) {
        return MetadataUtil.getBoolean(column, COLOR_VISIBLE_KEY);
    }

    public static boolean isTextColorVisible(Vector column) {
        return MetadataUtil.getBoolean(column, TEXT_COLOR_VISIBLE_KEY);
    }

    public static boolean isTextVisible(Vector column) {
        return MetadataUtil.getBoolean(column, TEXT_VISIBLE_KEY);
    }

    public static boolean isToolTipVisible(Vector column) {
        return MetadataUtil.getBoolean(column, TOOLTIP_VISIBLE_KEY);
    }

    public static void maybeConvertMetadataClass(Dataset dataset, boolean convertStringsToNumbers) {
        int j;
        int metadataColumns = dataset.getRowMetadata().getMetadataCount();
        for (j = 0; j < metadataColumns; ++j) {
            MetadataUtil.maybeConvertMetadataClass(dataset.getRowMetadata(), null, convertStringsToNumbers, j, true);
        }
        metadataColumns = dataset.getColumnMetadata().getMetadataCount();
        for (j = 0; j < metadataColumns; ++j) {
            MetadataUtil.maybeConvertMetadataClass(dataset.getColumnMetadata(), null, convertStringsToNumbers, j, false);
        }
    }

    public static boolean maybeConvertMetadataClass(MetadataModel metadata, VectorColorModel colorModel, boolean convertStringsToNumbers, int columnIndex, boolean isRows) {
        Vector vector = metadata.get(columnIndex);
        if (convertStringsToNumbers && MetadataUtil.maybeConvertStringToNumber(vector, colorModel, false)) {
            if (!isRows) {
                vector.setProperty(COLOR_VISIBLE_KEY, true);
                if (VectorUtil.getValues(vector, 3) >= 3) {
                    vector.setProperty(CONTINUOUS_KEY, true);
                }
            }
            return true;
        }
        if (MetadataUtil.maybeConvertStringToURL(vector, colorModel)) {
            return true;
        }
        return MetadataUtil.maybeConvertStringToDate(vector, colorModel);
    }

    public static boolean maybeConvertStringToNumber(Vector vector, VectorColorModel colorModel, boolean updateColors) {
        Double[] newValues = new Double[vector.size()];
        try {
            boolean nonNaN = false;
            int nrows = newValues.length;
            for (int i = 0; i < nrows; ++i) {
                String s = (String)vector.getValue(i);
                if (s == null || s.equals("")) continue;
                double f = ParserHelper.parseDoubleNaN(s);
                if (!Double.isNaN(f)) {
                    nonNaN = true;
                }
                newValues[i] = f;
            }
            if (!nonNaN) {
                return false;
            }
        }
        catch (Throwable x) {
            return false;
        }
        vector.setColumnClass(Number.class);
        int nrows = newValues.length;
        for (int i = 0; i < nrows; ++i) {
            if (updateColors) {
                MetadataUtil.updateColor(vector, vector.getValue(i), newValues[i], colorModel);
            }
            vector.setValue(i, newValues[i]);
        }
        return true;
    }

    public static void setColumnMetadataVisibility(MetadataModel model) {
        MetadataUtil.setMetadataVisibility(model, false);
    }

    public static void setRowMetadataVisibility(MetadataModel model) {
        MetadataUtil.setMetadataVisibility(model, true);
    }

    public static void toSampleInfoFile(MetadataModel model, File f) {
        try (PrintWriter pw = null;){
            pw = new PrintWriter(f);
            int ncols = model.getMetadataCount();
            for (int j = 0; j < ncols; ++j) {
                pw.print(model.get(j).getName());
                if (j <= 0) continue;
                pw.print("\t");
            }
            pw.println();
            int nitems = model.getItemCount();
            for (int i = 0; i < nitems; ++i) {
                int ncols2 = model.getMetadataCount();
                for (int j = 0; j < ncols2; ++j) {
                    if (j > 0) {
                        pw.print("\t");
                    }
                    pw.print(model.get(j).getValue(i));
                }
                pw.println();
            }
        }
    }

    public static MetadataModel without(MetadataModel model, String ... names) {
        TIntArrayList indices = new TIntArrayList();
        HashSet<String> set = new HashSet<String>(Arrays.asList(names));
        int size = model.getMetadataCount();
        for (int i = 0; i < size; ++i) {
            if (set.contains(model.getColumnName(i))) continue;
            indices.add(i);
        }
        return new MetadataModelColumnView(model, indices.toArray());
    }

    static void copyProperties(MetadataModel src, MetadataModel dest) {
        int count = src.getMetadataCount();
        for (int i = 0; i < count; ++i) {
            int destIndex = dest.getColumnIndex(src.getColumnName(i));
            if (destIndex == -1) continue;
            MetadataUtil.copyProperties(src.get(i), dest.get(destIndex));
        }
    }

    private static boolean maybeConvertStringToDate(Vector vector, VectorColorModel colorModel) {
        Date[] array = new Date[vector.size()];
        boolean nonNull = false;
        DateFormat format = DateFormat.getInstance();
        try {
            int i;
            int nrows = array.length;
            for (i = 0; i < nrows; ++i) {
                String s = (String)vector.getValue(i);
                if (s == null || s.equals("")) continue;
                nonNull = true;
                array[i] = format.parse(s);
            }
            if (!nonNull) {
                return false;
            }
            vector.setColumnClass(Date.class);
            nrows = array.length;
            for (i = 0; i < nrows; ++i) {
                MetadataUtil.updateColor(vector, vector.getValue(i), array[i], colorModel);
                vector.setValue(i, array[i]);
            }
            return true;
        }
        catch (Throwable x) {
            return false;
        }
    }

    private static boolean maybeConvertStringToURL(Vector vector, VectorColorModel colorModel) {
        URL[] array = new URL[vector.size()];
        boolean nonNull = false;
        try {
            int i;
            int nrows = array.length;
            for (i = 0; i < nrows; ++i) {
                String s = (String)vector.getValue(i);
                if (s == null || s.equals("")) continue;
                nonNull = true;
                array[i] = new URL(s);
            }
            if (!nonNull) {
                return false;
            }
            vector.setColumnClass(URL.class);
            nrows = array.length;
            for (i = 0; i < nrows; ++i) {
                MetadataUtil.updateColor(vector, vector.getValue(i), array[i], colorModel);
                vector.setValue(i, array[i]);
            }
            return true;
        }
        catch (Throwable x) {
            return false;
        }
    }

    private static void setMetadataVisibility(MetadataModel metadata, boolean rows) {
        String name;
        int metadataIndex;
        boolean defaultsFound = false;
        if (metadata.getMetadataCount() > 1) {
            for (metadataIndex = 0; metadataIndex < metadata.getMetadataCount() && !defaultsFound; ++metadataIndex) {
                name = metadata.get(metadataIndex).getName();
                if (DEFAULT_METADATA_TEXT.contains(name)) {
                    defaultsFound = true;
                    continue;
                }
                if (!DEFAULT_METADATA_COLOR.contains(name)) continue;
                defaultsFound = true;
            }
        }
        if (defaultsFound && metadata.getMetadataCount() > 2) {
            for (metadataIndex = 0; metadataIndex < metadata.getMetadataCount(); ++metadataIndex) {
                name = metadata.get(metadataIndex).getName();
                Vector v = metadata.get(metadataIndex);
                boolean moreThanOne = VectorUtil.containsMoreThanOneValue(v);
                boolean hide = false;
                if (moreThanOne) {
                    if (DEFAULT_METADATA_TEXT.contains(name)) {
                        v.setProperty(TEXT_VISIBLE_KEY, true);
                        v.removeProperty(COLOR_VISIBLE_KEY);
                    } else if (DEFAULT_METADATA_COLOR.contains(name)) {
                        v.removeProperty(TEXT_VISIBLE_KEY);
                        v.setProperty(COLOR_VISIBLE_KEY, true);
                        v.setProperty(CONTINUOUS_KEY, Number.class.isAssignableFrom(v.getColumnClass()));
                    } else {
                        hide = true;
                    }
                } else {
                    hide = true;
                }
                if (!hide) continue;
                v.removeProperty(COLOR_VISIBLE_KEY);
                v.removeProperty(TEXT_VISIBLE_KEY);
                v.removeProperty(TOOLTIP_VISIBLE_KEY);
            }
        } else if (!rows && metadata.getMetadataCount() > 0) {
            metadata.get(0).setProperty(TEXT_VISIBLE_KEY, true);
            metadata.get(0).removeProperty(COLOR_VISIBLE_KEY);
            metadata.get(0).setProperty(TOOLTIP_VISIBLE_KEY, true);
        }
    }

    private static void updateColor(Vector vector, Object oldValue, Object newValue, VectorColorModel colorModel) {
        if (colorModel != null && oldValue != null && colorModel.containsDiscreteColor(vector, oldValue)) {
            Color color = (Color)colorModel.getMappedValue(vector, oldValue);
            colorModel.setMappedValue(vector, newValue, color);
        }
    }
}

