/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import java.util.Collection;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetSupplier;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataModelItemView;

public class SlicedDatasetView
implements Dataset,
DatasetSupplier {
    protected int[] columnIndices;
    protected Dataset dataset;
    protected int[] rowIndices;
    private MetadataModel columnMetadata;
    private MetadataModel rowMetadata;

    public SlicedDatasetView(Dataset dataset, int[] rowIndices, int[] columnIndices) {
        this.dataset = dataset;
        this.setIndices(rowIndices, columnIndices);
    }

    @Override
    public int getColumnCount() {
        return this.columnIndices == null ? this.dataset.getColumnCount() : this.columnIndices.length;
    }

    public int[] getColumnIndices() {
        return this.columnIndices;
    }

    @Override
    public MetadataModel getColumnMetadata() {
        return this.columnMetadata;
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public String getName() {
        return this.dataset.getName();
    }

    @Override
    public Object getObjectValue(int row, int column, int seriesIndex) {
        return this.dataset.getObjectValue(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(column), seriesIndex);
    }

    @Override
    public Object getProperty(Object key) {
        return this.dataset.getProperty(key);
    }

    @Override
    public Collection<Object> getPropertyKeys() {
        return this.dataset.getPropertyKeys();
    }

    @Override
    public int getRowCount() {
        return this.rowIndices == null ? this.dataset.getRowCount() : this.rowIndices.length;
    }

    public int[] getRowIndices() {
        return this.rowIndices;
    }

    @Override
    public MetadataModel getRowMetadata() {
        return this.rowMetadata;
    }

    @Override
    public Class<?> getSeriesClass(int index) {
        return this.dataset.getSeriesClass(index);
    }

    @Override
    public int getSeriesCount() {
        return this.dataset.getSeriesCount();
    }

    @Override
    public String getSeriesName(int index) {
        return this.dataset.getSeriesName(index);
    }

    @Override
    public float getValue(int rowIndex, int columnIndex) {
        return this.dataset.getValue(this.convertRowIndexToModel(rowIndex), this.convertColumnIndexToModel(columnIndex));
    }

    @Override
    public float getValue(int row, int column, int seriesIndex) {
        return this.dataset.getValue(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(column), seriesIndex);
    }

    public void setColumnIndices(int[] columnIndices) {
        this.columnIndices = columnIndices;
        this.columnMetadata = columnIndices == null ? this.dataset.getColumnMetadata() : new MetadataModelItemView(this.dataset.getColumnMetadata(), columnIndices);
    }

    public void setIndices(int[] rowIndices, int[] columnIndices) {
        this.setRowIndices(rowIndices);
        this.setColumnIndices(columnIndices);
    }

    @Override
    public void setName(String name) {
        this.dataset.setName(name);
    }

    @Override
    public void setProperty(Object key, Object value) {
        this.dataset.setProperty(key, value);
    }

    public void setRowIndices(int[] rowIndices) {
        this.rowIndices = rowIndices;
        this.rowMetadata = rowIndices == null ? this.dataset.getRowMetadata() : new MetadataModelItemView(this.dataset.getRowMetadata(), rowIndices);
    }

    @Override
    public void setValue(int rowIndex, int columnIndex, float value) {
        this.dataset.setValue(this.convertRowIndexToModel(rowIndex), this.convertColumnIndexToModel(columnIndex), value);
    }

    private final int convertColumnIndexToModel(int column) {
        return this.columnIndices == null ? column : this.columnIndices[column];
    }

    private final int convertRowIndexToModel(int row) {
        return this.rowIndices == null ? row : this.rowIndices[row];
    }
}

