/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix.rankedlist;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.VectorUtil;
import org.broadinstitute.genee.matrix.rankedlist.RankedList;

public class DefaultRankedList
implements RankedList {
    private MetadataModel metadata;
    private String name;
    private float[] scores;
    private int positiveToZeroIndex;
    private int negativeToZeroIndex;
    private Map<Object, Object> properties = new HashMap<Object, Object>();
    private Map<Object, Integer> idToIndex;

    public DefaultRankedList(String name, float[] scores, MetadataModel metadata) {
        this.name = name;
        this.scores = scores;
        this.metadata = metadata;
        this.positiveToZeroIndex = VectorUtil.getPositiveToZeroIndex(this);
        this.negativeToZeroIndex = VectorUtil.getNegativeToZeroIndex(this);
        this.idToIndex = VectorUtil.createValueToIndexMap(metadata.get(0));
    }

    @Override
    public Object getId(int index) {
        return this.metadata.getValue(index, 0);
    }

    @Override
    public int getIndex(Object id) {
        Integer index = this.idToIndex.get(id);
        return index == null ? -1 : index;
    }

    @Override
    public MetadataModel getMetadata() {
        return this.metadata;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getNegativeToZeroIndex() {
        return this.negativeToZeroIndex;
    }

    @Override
    public int getPositiveToZeroIndex() {
        return this.positiveToZeroIndex;
    }

    @Override
    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    @Override
    public void removeProperty(Object key) {
        this.properties.remove(key);
    }

    @Override
    public Collection<Object> getPropertyKeys() {
        return this.properties.keySet();
    }

    @Override
    public float getScore(int index) {
        return this.scores[index];
    }

    @Override
    public void setProperty(Object key, Object value) {
        this.properties.put(key, value);
    }

    @Override
    public int size() {
        return this.metadata.getItemCount();
    }

    public String toString() {
        return this.name;
    }
}

