/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix.rankedlist;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataModelItemView;
import org.broadinstitute.genee.matrix.VectorUtil;
import org.broadinstitute.genee.matrix.rankedlist.RankedList;

public class SlicedRankedList
implements RankedList {
    private int[] indices;
    private int negativeToZeroIndex;
    private int positiveToZeroIndex;
    private RankedList rankedList;
    private MetadataModel metadata;
    private Map<Object, Integer> valueToIndex;

    public SlicedRankedList(RankedList rankedList, Collection<Object> ids) {
        this(rankedList, SlicedRankedList.getSortedIndices(rankedList, ids));
        this.metadata = new MetadataModelItemView(rankedList.getMetadata(), this.indices);
    }

    private SlicedRankedList(RankedList rankedList, int[] indices) {
        this.rankedList = rankedList;
        this.indices = indices;
        this.positiveToZeroIndex = VectorUtil.getPositiveToZeroIndex(this);
        this.negativeToZeroIndex = VectorUtil.getNegativeToZeroIndex(this);
        this.valueToIndex = new HashMap<Object, Integer>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.valueToIndex.put(this.getId(i), i);
        }
    }

    @Override
    public MetadataModel getMetadata() {
        return this.metadata;
    }

    @Override
    public String getName() {
        return this.rankedList.getName();
    }

    @Override
    public int getNegativeToZeroIndex() {
        return this.negativeToZeroIndex;
    }

    @Override
    public int getPositiveToZeroIndex() {
        return this.positiveToZeroIndex;
    }

    @Override
    public Object getProperty(Object key) {
        return this.rankedList.getProperty(key);
    }

    @Override
    public void removeProperty(Object key) {
        this.rankedList.removeProperty(key);
    }

    @Override
    public Collection<Object> getPropertyKeys() {
        return this.rankedList.getPropertyKeys();
    }

    @Override
    public float getScore(int index) {
        return this.rankedList.getScore(this.indices[index]);
    }

    @Override
    public void setProperty(Object key, Object value) {
        this.rankedList.setProperty(key, value);
    }

    @Override
    public int size() {
        return this.indices.length;
    }

    private static int[] getSortedIndices(RankedList rankedList, Collection<Object> ids) {
        Object[] indices = new IndexScorePair[ids.size()];
        int arrayIdx = 0;
        for (Object id : ids) {
            int index = rankedList.getIndex(id);
            indices[arrayIdx++] = new IndexScorePair(rankedList.getScore(index), index);
        }
        Arrays.sort(indices);
        int[] result = new int[indices.length];
        int i = 0;
        int n = result.length;
        int j = result.length - 1;
        while (i < n) {
            result[i] = ((IndexScorePair)indices[j]).index;
            ++i;
            --j;
        }
        return result;
    }

    @Override
    public Object getId(int index) {
        return this.rankedList.getId(this.indices[index]);
    }

    @Override
    public int getIndex(Object id) {
        Integer index = this.valueToIndex.get(id);
        return index != null ? index : -1;
    }

    private static class IndexScorePair
    implements Comparable<IndexScorePair> {
        private float score;
        private int index;

        public IndexScorePair(float score, int index) {
            this.score = score;
            this.index = index;
        }

        @Override
        public int compareTo(IndexScorePair o) {
            return Float.compare(this.score, o.score);
        }
    }
}

