/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.movie;

import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.chart.DefaultXYInterpolatedChartDataset;
import org.broadinstitute.genee.chart.XYChartDataset;
import org.broadinstitute.genee.chart.XYInterpolatedChartDataset;
import org.broadinstitute.genee.chart.XYInterpolatedChartDatasetSupplier;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.XYChartDatasetCollection;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.movie.MovieDrawer;
import org.broadinstitute.genee.movie.MovieFrame;
import org.broadinstitute.genee.movie.MovieGenerator;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;

public class MovieController {
    private Animator animator;
    private int frameIndex = -1;
    private MovieFrame[] movieFrames;
    private TimingTarget internalTimingTarget;
    private XYInterpolatedChartDataset[] interpolatedChartDatasets;
    private MovieDrawer movieDrawer;
    private MovieGenerator movieGenerator;
    private Project project;
    private Dataset fullDataset;
    private List<TimingTarget> timingTargets = new ArrayList<TimingTarget>();
    private int transitionTime = 1000;
    private boolean doInterpolation = true;
    private XYChartDatasetCollection chartDatasetCollection;

    public MovieController(MovieDrawer movieDrawer) {
        this.setMovieDrawer(movieDrawer);
    }

    public void addTimingTarget(TimingTarget t) {
        this.timingTargets.add(t);
    }

    public int getFrameIndex() {
        return this.frameIndex;
    }

    public int getNumberOfFrames() {
        return this.movieFrames.length;
    }

    public void goToFrame(int frameIndex) {
        this.stop();
        this.setFrame(frameIndex);
    }

    public boolean isRunning() {
        return this.animator != null ? this.animator.isRunning() : false;
    }

    public void setFrameIndex(int frameIndex) {
        this.frameIndex = frameIndex;
    }

    public int setMovieGenerator(MovieGenerator movieGenerator) {
        this.movieGenerator = movieGenerator;
        this.project = Application.getProject();
        this.fullDataset = this.project.getOriginalDataset();
        this.movieFrames = movieGenerator.generate(this.project);
        this.frameIndex = -1;
        return this.movieFrames.length;
    }

    public void start() {
        this.stop();
        if (this.frameIndex == this.movieFrames.length - 1) {
            this.frameIndex = -1;
        }
        this.animator = new Animator(this.transitionTime, Math.max(1, this.movieFrames.length - this.frameIndex - 1), Animator.RepeatBehavior.LOOP, this.internalTimingTarget);
        for (TimingTarget t : this.timingTargets) {
            this.animator.addTarget(t);
        }
        this.animator.start();
    }

    public void stop() {
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.stop();
        }
    }

    public void reset() {
        this.stop();
        this.setMovieGenerator(this.movieGenerator);
        this.setMovieDrawer(this.movieDrawer);
    }

    private void setFrame(int frameIndex) {
        if (frameIndex >= this.getNumberOfFrames()) {
            frameIndex = this.getNumberOfFrames() - 1;
        } else if (frameIndex < 0) {
            frameIndex = 0;
        }
        this.frameIndex = frameIndex;
        int[] modelRowIndices = this.movieFrames[frameIndex].getRowModelIndices();
        int[] modelColumnIndices = this.movieFrames[frameIndex].getColumnModelIndices();
        Dataset currentDataset = DatasetUtil.sliceView(this.fullDataset, modelRowIndices, modelColumnIndices);
        this.chartDatasetCollection = this.movieDrawer.createChartDatasets(currentDataset);
        this.chartDatasetCollection.setText(this.movieFrames[frameIndex].getName());
        if (this.doInterpolation) {
            int i;
            if (this.interpolatedChartDatasets == null || this.interpolatedChartDatasets.length != this.chartDatasetCollection.size()) {
                this.interpolatedChartDatasets = new DefaultXYInterpolatedChartDataset[this.chartDatasetCollection.size()];
                for (i = 0; i < this.interpolatedChartDatasets.length; ++i) {
                    this.interpolatedChartDatasets[i] = ((XYInterpolatedChartDatasetSupplier)((Object)this.chartDatasetCollection.getChartDataset(i))).createXYInterpolatedChartDataset(null);
                }
            }
            for (i = 0; i < this.interpolatedChartDatasets.length; ++i) {
                XYChartDataset previousDest = this.interpolatedChartDatasets[i].getDestination();
                this.interpolatedChartDatasets[i].setSource(previousDest != null ? previousDest : this.chartDatasetCollection.getChartDataset(i));
                this.interpolatedChartDatasets[i].setDestination(this.chartDatasetCollection.getChartDataset(i));
                this.chartDatasetCollection.setChartDataset(i, this.interpolatedChartDatasets[i]);
            }
            this.movieDrawer.setFrameData(this.chartDatasetCollection);
        } else {
            this.movieDrawer.setFrameData(this.chartDatasetCollection);
        }
        if (this.movieGenerator.isByRow()) {
            this.project.setSelectedModelRowIndices(modelRowIndices);
        } else {
            this.project.setSelectedModelColumnIndices(modelColumnIndices);
        }
        this.movieDrawer.paintFrame();
    }

    private void setMovieDrawer(MovieDrawer _movieDrawer) {
        this.movieDrawer = _movieDrawer;
        this.interpolatedChartDatasets = null;
        this.internalTimingTarget = new TimingTarget(){

            @Override
            public void begin() {
                MovieController.this.movieDrawer.setMovieRunning(true);
                this.repeat();
            }

            @Override
            public void end() {
                if (MovieController.this.doInterpolation) {
                    for (int i = 0; i < MovieController.this.interpolatedChartDatasets.length; ++i) {
                        XYChartDataset dest = MovieController.this.interpolatedChartDatasets[i].getDestination();
                        MovieController.this.chartDatasetCollection.setChartDataset(i, MovieController.this.interpolatedChartDatasets[i]);
                    }
                    MovieController.this.movieDrawer.setFrameData(MovieController.this.chartDatasetCollection);
                }
                MovieController.this.movieDrawer.setMovieRunning(false);
                MovieController.this.movieDrawer.paintFrame();
            }

            @Override
            public void repeat() {
                MovieController.this.setFrame(MovieController.this.frameIndex + 1);
            }

            @Override
            public void timingEvent(float fraction) {
                if (MovieController.this.doInterpolation) {
                    for (XYInterpolatedChartDataset d : MovieController.this.interpolatedChartDatasets) {
                        d.setFraction(fraction);
                    }
                }
                MovieController.this.movieDrawer.paintFrame();
            }
        };
    }

    public MovieFrame[] getMovieFrames() {
        return this.movieFrames;
    }

    public MovieDrawer getMovieDrawer() {
        return this.movieDrawer;
    }

    public Dataset getDataset() {
        return this.fullDataset;
    }

    public void setDoInterpolation(boolean doInterpolation) {
        this.doInterpolation = doInterpolation;
    }

    public int getTransitionTime() {
        return this.transitionTime;
    }

    public void setTransitionTime(int transitionTime) {
        this.transitionTime = transitionTime;
        if (this.animator != null) {
            this.animator.setDuration(transitionTime);
        }
    }
}

