/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.stats;

import gnu.trove.list.array.TFloatArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.matrix.FloatList;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.stats.ObjectIntPair;

public class Sorting {
    private Sorting() {
    }

    public static int[] index(Collection<?> values, final Comparator c, boolean ascending) {
        int length = values.size();
        Indexable[] tmp = new ObjectIntPair[length];
        int i = 0;
        for (Object val : values) {
            tmp[i] = new ObjectIntPair(val, i);
            ++i;
        }
        Arrays.sort(tmp, new Comparator<ObjectIntPair>(){

            @Override
            public int compare(ObjectIntPair o1, ObjectIntPair o2) {
                return c.compare(o1.getValue(), o2.getValue());
            }
        });
        return Sorting.indexSortedArray(tmp, ascending);
    }

    public static int[] index(float[] values, boolean ascending) {
        int length = values.length;
        Object[] tmp = new FloatIntPair[length];
        for (int i = 0; i < length; ++i) {
            tmp[i] = new FloatIntPair(values[i], i);
        }
        Arrays.sort(tmp);
        return Sorting.indexSortedArray((Indexable[])tmp, ascending);
    }

    public static int[] index(FloatList values, boolean ascending) {
        int length = values.size();
        Object[] tmp = new FloatIntPair[length];
        for (int i = 0; i < length; ++i) {
            tmp[i] = new FloatIntPair(values.getValue(i), i);
        }
        Arrays.sort(tmp);
        return Sorting.indexSortedArray((Indexable[])tmp, ascending);
    }

    public static int[] index(Indexable[] values, boolean ascending) {
        Arrays.sort(values);
        return Sorting.indexSortedArray(values, ascending);
    }

    public static int[] index(int[] values, boolean ascending) {
        int length = values.length;
        Object[] tmp = new IntIntPair[length];
        for (int i = 0; i < length; ++i) {
            tmp[i] = new IntIntPair(values[i], i);
        }
        Arrays.sort(tmp);
        return Sorting.indexSortedArray((Indexable[])tmp, ascending);
    }

    public static int[] index(Object[] values, final Comparator c, boolean ascending) {
        int length = values.length;
        Indexable[] tmp = new ObjectIntPair[length];
        for (int i = 0; i < length; ++i) {
            tmp[i] = new ObjectIntPair(values[i], i);
        }
        Arrays.sort(tmp, new Comparator<ObjectIntPair>(){

            @Override
            public int compare(ObjectIntPair o1, ObjectIntPair o2) {
                return c.compare(o1.getValue(), o2.getValue());
            }
        });
        return Sorting.indexSortedArray(tmp, ascending);
    }

    public static int[] index(short[] values, boolean ascending) {
        int length = values.length;
        Object[] tmp = new ShortIntPair[length];
        for (int i = 0; i < length; ++i) {
            tmp[i] = new ShortIntPair(values[i], i);
        }
        Arrays.sort(tmp);
        return Sorting.indexSortedArray((Indexable[])tmp, ascending);
    }

    public static int[] index(TFloatArrayList values, boolean ascending) {
        int length = values.size();
        Object[] tmp = new FloatIntPair[length];
        for (int i = 0; i < length; ++i) {
            tmp[i] = new FloatIntPair(values.getQuick(i), i);
        }
        Arrays.sort(tmp);
        return Sorting.indexSortedArray((Indexable[])tmp, ascending);
    }

    public static int[] index(Vector values, boolean ascending) {
        int length = values.size();
        Object[] tmp = new FloatIntPair[length];
        for (int i = 0; i < length; ++i) {
            Number n = (Number)values.getValue(i);
            tmp[i] = new FloatIntPair(n == null ? Float.NaN : n.floatValue(), i);
        }
        Arrays.sort(tmp);
        return Sorting.indexSortedArray((Indexable[])tmp, ascending);
    }

    public static int[] rank(int[] index) {
        int[] rank = new int[index.length];
        int n = index.length;
        for (int j = 0; j < n; ++j) {
            rank[index[j]] = j + 1;
        }
        return rank;
    }

    public static float[] rank(int[] index, float[] data) {
        int m;
        float[] rank = new float[index.length];
        int n = index.length;
        for (int j = 0; j < n; ++j) {
            rank[index[j]] = j + 1;
        }
        for (int i = 0; i < n; i += m) {
            int j;
            float value = data[index[i]];
            for (j = i + 1; j < n && data[index[j]] == value; ++j) {
            }
            m = j - i;
            value = rank[index[i]] + (float)(m - 1) / 2.0f;
            for (j = i; j < i + m; ++j) {
                rank[index[j]] = value;
            }
        }
        return rank;
    }

    private static int[] indexSortedArray(Indexable[] array, boolean ascending) {
        int length = array.length;
        int[] index = new int[length];
        for (int i = 0; i < length; ++i) {
            index[i] = array[i].getIndex();
        }
        if (!ascending) {
            IOUtil.reverse(index);
        }
        return index;
    }

    public static class ShortIntPair
    implements Comparable<ShortIntPair>,
    Indexable {
        private int index;
        private short value;

        public ShortIntPair(short value, int index) {
            this.value = value;
            this.index = index;
        }

        @Override
        public int compareTo(ShortIntPair o) {
            short thisVal = this.value;
            short anotherVal = o.value;
            return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        public short getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.index);
        }
    }

    public static class IntIntPair
    implements Comparable<IntIntPair>,
    Indexable {
        private int index;
        private int value;

        public IntIntPair(int value, int index) {
            this.value = value;
            this.index = index;
        }

        @Override
        public int compareTo(IntIntPair o) {
            int thisVal = this.value;
            int anotherVal = o.value;
            return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return this.value + ", " + this.index;
        }
    }

    public static interface Indexable {
        public int getIndex();
    }

    public static class FloatIntPair
    implements Comparable<FloatIntPair>,
    Indexable {
        private int index;
        private float value;

        public FloatIntPair(float value, int index) {
            this.value = value;
            this.index = index;
        }

        @Override
        public int compareTo(FloatIntPair o) {
            return Float.compare(this.value, o.value);
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        public float getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.index);
        }
    }
}

