/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.table;

import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import org.broadinstitute.genee.compound.MoleculeUtil;

public class CellSpan
implements Comparable<CellSpan> {
    private int start;
    private int end;

    public CellSpan(int start, int end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public int compareTo(CellSpan o) {
        if (o.start >= this.start && o.end <= this.end) {
            return 0;
        }
        return new Integer(this.start).compareTo(o.start);
    }

    public boolean contains(int index) {
        return index >= this.start && index <= this.end;
    }

    public int getEnd() {
        return this.end;
    }

    public int getStart() {
        return this.start;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.start);
        builder.append("-");
        builder.append(this.end);
        return builder.toString();
    }

    public static List<CellSpan> getCellSpan(JTable table, int column) {
        ArrayList<CellSpan> spans = new ArrayList<CellSpan>();
        int i = 0;
        int rows = table.getRowCount();
        while (i < rows) {
            Object value = table.getValueAt(i, column);
            int end = CellSpan.getSpanEnd(table, value, i, column);
            CellSpan span = new CellSpan(i, end);
            spans.add(span);
            i = end + 1;
        }
        return spans;
    }

    private static int getSpanEnd(JTable table, Object value, int row, int column) {
        int rows = table.getRowCount();
        for (int i = row + 1; i < rows; ++i) {
            Object other = table.getValueAt(i, column);
            if (CellSpan.toStringEquals(value, other)) continue;
            return i - 1;
        }
        return table.getRowCount() - 1;
    }

    private static boolean toStringEquals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return a == null;
        }
        return MoleculeUtil.toSmile((Molecule)a).equals(MoleculeUtil.toSmile((Molecule)b));
    }
}

