/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.table;

import com.jidesoft.grid.TableUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.broadinstitute.genee.category.MetadataPopup;
import org.broadinstitute.genee.chart.MatrixElement;
import org.broadinstitute.genee.gui.BrowserLauncher;
import org.broadinstitute.genee.gui.TableToolTip;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.ZoomInAction;
import org.broadinstitute.genee.gui.ZoomOutAction;
import org.broadinstitute.genee.heatmap.AlignedNumberCellRenderer;
import org.broadinstitute.genee.heatmap.CurveElementList;
import org.broadinstitute.genee.heatmap.CurveTableCellRenderer;
import org.broadinstitute.genee.heatmap.DefaultSizesAndPositions;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.SizesAndPositions;
import org.broadinstitute.genee.heatmap.ZoomActions;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.table.HeatMapRowTableModel;
import org.broadinstitute.genee.table.ProjectSortableHeaderRenderer;
import org.broadinstitute.genee.table.RowPositionTableUI;
import org.broadinstitute.genee.table.TableUtil;

public class HeatMapRowTable
extends JTable
implements TableToolTip {
    private HeatMapPanel heatMapPanel;
    private MatrixElement mouseMovedElement;
    private Project project;
    private SizesAndPositions viewRowSizesAndPositions;

    public HeatMapRowTable(final HeatMapPanel heatMapPanel) {
        super(new HeatMapRowTableModel());
        this.setFont(new Font(UIUtil.getFontName(), 0, UIUtil.DEFAULT_FONT_SIZE));
        TableUtil.setRenderers(this, true);
        this.setDefaultRenderer(HeatMapRowTableModel.VectorDataWrapper.class, new AlignedNumberCellRenderer());
        this.setDefaultRenderer(CurveElementList.class, new CurveTableCellRenderer(heatMapPanel, true));
        this.heatMapPanel = heatMapPanel;
        this.setIntercellSpacing(new Dimension());
        this.getTableHeader().setDefaultRenderer(new ProjectSortableHeaderRenderer(this.getTableHeader()));
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            private void showPopup(MouseEvent e) {
                int columnIndex;
                if (e.isPopupTrigger() && (columnIndex = HeatMapRowTable.this.convertColumnIndexToModel(HeatMapRowTable.this.columnAtPoint(e.getPoint()))) >= 0) {
                    JPopupMenu menu = new JPopupMenu();
                    HeatMapRowTableModel rowTableModel = (HeatMapRowTableModel)HeatMapRowTable.this.getModel();
                    new MetadataPopup(heatMapPanel, HeatMapRowTable.this.project, rowTableModel.getMetadata(), rowTableModel.getMetadata().get(columnIndex), menu, true, MetadataPopup.MOVE_MODE.NONE, "Text Visible");
                    menu.show(HeatMapRowTable.this, e.getX(), e.getY());
                }
            }
        });
        this.setMinimumSize(new Dimension(0, 0));
        this.setColumnSelectionAllowed(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        this.setAutoResizeMode(0);
        this.setGridColor(UIUtil.LIGHT_BLUE);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                Object value;
                int rowIndex;
                int columnIndex = HeatMapRowTable.this.convertColumnIndexToModel(HeatMapRowTable.this.columnAtPoint(event.getPoint()));
                if (HeatMapRowTable.this.heatMapPanel.isProfileSparkLinesVisible() && columnIndex == 2) {
                    HeatMapRowTable.this.heatMapPanel.getHeatMapEditorKit().getRowProfileAction().actionPerformed(new ActionEvent(event.getComponent(), 1001, "profile", event.getWhen(), event.getModifiers()));
                } else if (URL.class.isAssignableFrom(HeatMapRowTable.this.getColumnClass(columnIndex)) && (rowIndex = HeatMapRowTable.this.rowAtPoint(event.getPoint())) >= 0 && rowIndex < HeatMapRowTable.this.getRowCount() && (value = HeatMapRowTable.this.getValueAt(rowIndex, columnIndex)) != null) {
                    BrowserLauncher.openURL(value.toString());
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        TableUtil.addHandCursorMouseMotionListener(this, URL.class);
    }

    @Override
    public void addColumn(TableColumn c) {
        super.addColumn(c);
        TableUtil.sizeColumn(this, c);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        UIUtil.registerToolTip(this);
    }

    @Override
    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        Rectangle r = new Rectangle();
        boolean valid = true;
        if (row < 0) {
            r.height = 0;
            r.y = 0;
            valid = false;
        } else if (row >= this.getRowCount()) {
            r.y = this.getHeight();
            valid = false;
        } else {
            r.height = (int)Math.ceil(this.viewRowSizesAndPositions.getSize());
            r.y = Math.round(this.viewRowSizesAndPositions.getPosition(row));
        }
        if (column < 0) {
            if (!this.getComponentOrientation().isLeftToRight()) {
                r.x = this.getWidth();
            }
            valid = false;
        } else if (column >= this.getColumnCount()) {
            if (this.getComponentOrientation().isLeftToRight()) {
                r.x = this.getWidth();
            }
            valid = false;
        } else {
            int i;
            TableColumnModel cm = this.getColumnModel();
            if (this.getComponentOrientation().isLeftToRight()) {
                for (i = 0; i < column; ++i) {
                    r.x += cm.getColumn(i).getWidth();
                }
            } else {
                for (i = cm.getColumnCount() - 1; i > column; --i) {
                    r.x += cm.getColumn(i).getWidth();
                }
            }
            r.width = cm.getColumn(column).getWidth();
        }
        if (valid && !includeSpacing) {
            int rm = this.getRowMargin();
            int cm = this.getColumnModel().getColumnMargin();
            r.setBounds(r.x + cm / 2, r.y + rm / 2, r.width - cm, r.height - rm);
        }
        return r;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.height = HeatMapPanel.getSize(this.viewRowSizesAndPositions);
        return size;
    }

    public Project getProject() {
        return this.project;
    }

    public HeatMapRowTableModel getHeatMapRowTableModel() {
        return (HeatMapRowTableModel)this.getModel();
    }

    @Override
    public List<Map.Entry> getTableToolTipText(MouseEvent e) {
        Dataset dataset = this.project.getSortedFilteredDataset();
        int modelColumnIndex = this.convertColumnIndexToModel(this.columnAtPoint(e.getPoint()));
        HeatMapRowTableModel model = this.getHeatMapRowTableModel();
        HeatMapRowTableModel.HeatMapRowTableColumn c = model.getType(modelColumnIndex);
        String metadataName = c.getType() == 1 ? model.getColumnName(modelColumnIndex) : null;
        int[] indices = DefaultSizesAndPositions.getIndices(this.viewRowSizesAndPositions, e.getPoint().y);
        ArrayList<Map.Entry> entries = new ArrayList<Map.Entry>();
        for (int index : indices) {
            entries.addAll(DatasetUtil.getToolTipText(dataset, index, -1, metadataName, null));
        }
        return entries;
    }

    public SizesAndPositions getViewSizesAndPositions() {
        return this.viewRowSizesAndPositions;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        Component c = super.prepareRenderer(renderer, row, column);
        float fontSize = Math.min(this.viewRowSizesAndPositions.getSize() - 1.0f, 16.0f);
        int fontStyle = 0;
        if (this.mouseMovedElement != null && this.mouseMovedElement.getRow() != -1 && this.project.convertModelRowIndexToView(this.mouseMovedElement.getRow()) == row) {
            fontStyle = 1;
        }
        c.setFont(this.getFont().deriveFont(fontStyle, fontSize));
        HeatMapRowTableModel model = this.getHeatMapRowTableModel();
        int modelColumn = this.convertColumnIndexToModel(column);
        HeatMapRowTableModel.HeatMapRowTableColumn type = model.getType(column);
        Vector vector = type.getType() == 1 ? model.getAsVector(modelColumn) : null;
        Color color = null;
        if (vector != null && MetadataUtil.getBoolean(vector, "Text Color Visible")) {
            color = (Color)this.project.getRowColorModel().getMappedValue(vector, model.getValueAt(row, modelColumn));
        }
        if (color == null) {
            color = Color.BLACK;
        }
        JComponent jc = (JComponent)c;
        jc.setForeground(color);
        jc.setBorder(null);
        jc.setBackground(Color.WHITE);
        if (this.heatMapPanel.getQuickRowSearch().isHighlighted(row)) {
            jc.setBorder(BorderFactory.createLineBorder(UIUtil.HIGHLIGHT_COLOR, 1));
        }
        if (this.project.getRowSelectionModel().isViewIndexSelected(row)) {
            jc.setBackground(UIUtil.SELECTION_COLOR);
        }
        return c;
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        if (e.isPopupTrigger() && this.heatMapPanel.getRowPopupMenu() != null) {
            this.heatMapPanel.getRowPopupMenu().show(e.getComponent(), e.getX(), e.getY());
        } else {
            super.processMouseEvent(e);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        UIUtil.unregisterToolTip(this);
    }

    @Override
    public int rowAtPoint(Point point) {
        int result = this.viewRowSizesAndPositions.getIndex(point.y, false);
        if (result < 0) {
            return point.y <= 0 ? 0 : this.getRowCount() - 1;
        }
        if (result >= this.getRowCount()) {
            return -1;
        }
        return result;
    }

    public void setMouseMovedElement(MatrixElement mouseMovedElement) {
        this.mouseMovedElement = mouseMovedElement;
    }

    public void setProject(Project project) {
        this.project = project;
        this.getHeatMapRowTableModel().setProject(project);
        this.setSelectionModel(project.getRowSelectionModel().getViewSelectionModel());
        ((ProjectSortableHeaderRenderer)this.getTableHeader().getDefaultRenderer()).setProject(project);
    }

    public void setViewRowSizesAndPositions(SizesAndPositions viewRowSizesAndPositions) {
        this.viewRowSizesAndPositions = viewRowSizesAndPositions;
        this.setUI(new RowPositionTableUI(viewRowSizesAndPositions));
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.project == null) {
            super.tableChanged(e);
            return;
        }
        String tablePref = TableUtils.getTablePreferenceByName((JTable)this);
        int[] selectedModelIndices = this.project.getRowSelectionModel().getSelectedModelIndices();
        int columnMin = this.columnModel.getSelectionModel().getMinSelectionIndex();
        int columnMax = this.columnModel.getSelectionModel().getMaxSelectionIndex();
        columnMin = Math.max(columnMin, 0);
        columnMax = Math.max(columnMax, 0);
        super.tableChanged(e);
        this.selectionModel.setValueIsAdjusting(true);
        this.selectionModel.clearSelection();
        this.columnModel.getSelectionModel().addSelectionInterval(columnMin, columnMax);
        for (int modelIndex : selectedModelIndices) {
            int viewIndex = this.project.convertModelRowIndexToView(modelIndex);
            if (viewIndex == -1) continue;
            this.selectionModel.addSelectionInterval(viewIndex, viewIndex);
        }
        this.selectionModel.setValueIsAdjusting(false);
        TableUtils.setTablePreferenceByName((JTable)this, (String)tablePref);
    }

    @Override
    protected void configureEnclosingScrollPane() {
    }

    @Override
    public boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (ks.equals(ZoomActions.ZOOM_IN_ROWS_KEY_STROKE) || ks.equals(ZoomActions.ZOOM_IN_COLUMNS_KEY_STROKE) || ks.equals(ZoomActions.ZOOM_OUT_ROWS_KEY_STROKE) || ks.equals(ZoomActions.ZOOM_OUT_COLUMNS_KEY_STROKE) || ks.equals(ZoomInAction.ZOOM_IN_KEY_STROKE) || ks.equals(ZoomOutAction.ZOOM_OUT_KEY_STROKE)) {
            return false;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }
}

