/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.table;

import chemaxon.struc.Molecule;
import javax.swing.table.AbstractTableModel;
import org.broadinstitute.genee.heatmap.CurveElementList;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectEvent;
import org.broadinstitute.genee.heatmap.ProjectListener;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;

public class HeatMapRowTableModel
extends AbstractTableModel {
    private static final HeatMapRowTableColumn UNDEFINED_COLUMN = new HeatMapRowTableColumn(-1, -1);
    private boolean curveSummaryVisible;
    private Dataset dataset;
    private MetadataModel metadata;
    private HeatMapRowTableColumn[] modelIndexToType = new HeatMapRowTableColumn[0];
    private boolean profileVisible;
    private Project project;
    private ProjectListener projectListener;
    private boolean rowNumberVisible = false;
    private VectorDataWrapper vectorDataWrapper = new VectorDataWrapper();

    public HeatMapRowTableModel() {
        this.projectListener = new ProjectListener(){

            @Override
            public void projectChanged(ProjectEvent e) {
                if (e.isRowChanged()) {
                    HeatMapRowTableModel.this.setDataset(HeatMapRowTableModel.this.project.getSortedFilteredDataset());
                }
            }
        };
    }

    @Override
    public void fireTableStructureChanged() {
        MetadataModel metadataModel = this.metadata = this.dataset == null ? null : MetadataUtil.filter(this.dataset.getRowMetadata(), "Text Visible");
        if (this.metadata != null) {
            int nfields = this.metadata.getMetadataCount();
            for (int j = 0; j < nfields; ++j) {
                Vector v = this.metadata.get(j);
                if (!IOUtil.isNumber(v.getColumnClass()) || v.getProperty("maxIntegerDigits") != null) continue;
                int maxDigitsBeforeDecimal = -1;
                int size = v.size();
                for (int i = 0; i < size; ++i) {
                    Number value = (Number)v.getValue(i);
                    if (value == null) continue;
                    String s = Formatter.format(value);
                    int index = s.indexOf(46);
                    maxDigitsBeforeDecimal = Math.max(maxDigitsBeforeDecimal, index);
                }
                v.setProperty("maxIntegerDigits", maxDigitsBeforeDecimal);
            }
        }
        this.buildMap();
        super.fireTableStructureChanged();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        HeatMapRowTableColumn column = this.getType(columnIndex);
        if (column.type == 2) {
            return Integer.class;
        }
        if (column.type == 1) {
            return VectorDataWrapper.class;
        }
        if (column.type == 3) {
            return Dataset.class;
        }
        if (column.type == 0) {
            return CurveElementList.class;
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        if (this.metadata == null) {
            return 0;
        }
        int count = this.metadata.getMetadataCount();
        if (this.profileVisible) {
            ++count;
        }
        if (this.rowNumberVisible) {
            ++count;
        }
        if (this.curveSummaryVisible) {
            ++count;
        }
        return count;
    }

    @Override
    public String getColumnName(int columnIndex) {
        HeatMapRowTableColumn column = this.getType(columnIndex);
        if (column.type == 2) {
            return "#";
        }
        if (column.type == 1) {
            return this.metadata.getColumnName(column.metadataIndex);
        }
        if (column.type == 3) {
            return "Sparkline";
        }
        if (column.type == 0) {
            return "Row Chart Summary";
        }
        return "";
    }

    public MetadataModel getMetadata() {
        return this.metadata;
    }

    public Project getProject() {
        return this.project;
    }

    @Override
    public int getRowCount() {
        return this.dataset != null ? this.dataset.getRowCount() : 0;
    }

    public HeatMapRowTableColumn getType(int columnIndex) {
        return columnIndex < 0 || columnIndex >= this.modelIndexToType.length ? UNDEFINED_COLUMN : this.modelIndexToType[columnIndex];
    }

    public Object getValueAt(Dataset dataset, MetadataModel datasetMetadata, int rowIndex, HeatMapRowTableColumn column) {
        if (column.type == 1) {
            Object object;
            Vector v = datasetMetadata.get(column.metadataIndex);
            this.vectorDataWrapper.object = object = v.getValue(rowIndex);
            this.vectorDataWrapper.vector = v;
            return this.vectorDataWrapper;
        }
        if (column.type == 2) {
            return rowIndex + 1;
        }
        return dataset;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        HeatMapRowTableColumn column = this.getType(columnIndex);
        return this.getValueAt(this.dataset, this.metadata, rowIndex, column);
    }

    public int getVectorIndex(int columnIndex) {
        HeatMapRowTableColumn column = this.getType(columnIndex);
        return column.metadataIndex;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.getColumnClass(columnIndex).isAssignableFrom(Molecule.class) && this.getValueAt(rowIndex, columnIndex) != null;
    }

    public boolean isRowNumberVisible() {
        return this.rowNumberVisible;
    }

    public boolean isVector(int columnIndex) {
        HeatMapRowTableColumn column = this.getType(columnIndex);
        return column.type == 1;
    }

    public void setProfileVisible(boolean profileVisible) {
        this.profileVisible = profileVisible;
        this.fireTableStructureChanged();
    }

    public void setProject(Project project) {
        if (this.project != null) {
            this.project.removeProjectListener(this.projectListener);
        }
        this.project = project;
        project.addProjectListener(this.projectListener);
        this.setDataset(project.getSortedFilteredDataset());
    }

    public void setRowNumberVisible(boolean rowNumberVisible) {
        this.rowNumberVisible = rowNumberVisible;
        this.fireTableStructureChanged();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    Vector getAsVector(int columnIndex) {
        HeatMapRowTableColumn column = this.getType(columnIndex);
        if (column.type == 1) {
            return this.metadata.get(column.metadataIndex);
        }
        return null;
    }

    private void buildMap() {
        this.modelIndexToType = new HeatMapRowTableColumn[this.getColumnCount()];
        if (this.modelIndexToType.length == 0) {
            return;
        }
        int columnIndex = 0;
        if (this.rowNumberVisible) {
            this.modelIndexToType[columnIndex++] = new HeatMapRowTableColumn(2, -1);
        }
        if (this.metadata != null) {
            int count = this.metadata.getMetadataCount();
            for (int i = 0; i < count; ++i) {
                this.modelIndexToType[columnIndex++] = new HeatMapRowTableColumn(1, i);
            }
        }
        boolean bl = this.dataset == null ? false : (this.curveSummaryVisible = DatasetUtil.getSeriesIndex(this.dataset, CurveElementList.class) != -1);
        if (this.curveSummaryVisible) {
            this.modelIndexToType[columnIndex++] = new HeatMapRowTableColumn(0, -1);
        }
        if (this.profileVisible) {
            this.modelIndexToType[columnIndex++] = new HeatMapRowTableColumn(3, -1);
        }
    }

    private void setDataset(Dataset dataset) {
        this.dataset = dataset;
        this.fireTableStructureChanged();
    }

    static class HeatMapRowTableColumn {
        static final int CHART_COLUMN = 0;
        static final int META_DATA_COLUMN = 1;
        static final int NUMBER_COLUMN = 2;
        static final int PROFILE_COLUMN = 3;
        private final int metadataIndex;
        private final int type;

        public HeatMapRowTableColumn(int type, int metadataIndex) {
            this.type = type;
            this.metadataIndex = metadataIndex;
        }

        public int getMetadataIndex() {
            return this.metadataIndex;
        }

        public int getType() {
            return this.type;
        }

        public String toString() {
            switch (this.type) {
                case 2: {
                    return "#";
                }
                case 1: {
                    return "Metadata";
                }
                case 3: {
                    return "Profile";
                }
                case 0: {
                    return "Chart";
                }
            }
            return "";
        }
    }

    public static class VectorDataWrapper {
        public Object object;
        public Vector vector;

        public String toString() {
            return this.object.toString();
        }
    }
}

