/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.table;

import java.util.Collections;
import java.util.List;
import javax.swing.table.JTableHeader;
import org.broadinstitute.genee.heatmap.AbstractProjectSortKey;
import org.broadinstitute.genee.heatmap.HeatMapEditorKit;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectSortKey;
import org.broadinstitute.genee.heatmap.SortKeys;
import org.broadinstitute.genee.heatmap.SortOrder;
import org.broadinstitute.genee.math.stat.function.FloatListFunction;
import org.broadinstitute.genee.table.AbstractSortableHeaderRenderer;
import org.broadinstitute.genee.table.SortKey;

public class ProjectSortableHeaderRenderer
extends AbstractSortableHeaderRenderer {
    private Project project;

    public ProjectSortableHeaderRenderer(JTableHeader tableHeader) {
        super(tableHeader, true);
    }

    public void setProject(Project project) {
        this.project = project;
    }

    @Override
    protected void clearSorting() {
        this.project.setRowSortOrder(null);
    }

    @Override
    protected SortKey createSortKey(String columnName) {
        FloatListFunction function;
        AbstractProjectSortKey sortKey = columnName.equals("id") ? new SortKeys.VectorSortKey("id", SortOrder.UNSORTED, true) : (this.project.getOriginalDataset().getRowMetadata().getColumnIndex(columnName) != -1 ? new SortKeys.VectorSortKey(columnName, SortOrder.UNSORTED, true) : ((function = HeatMapEditorKit.getFunction(columnName)) != null ? new SortKeys.FunctionRow(function, SortOrder.UNSORTED) : null));
        return sortKey;
    }

    @Override
    protected List<? extends SortKey> getSortKeys() {
        return this.project != null ? this.project.getRowSortKeys() : Collections.EMPTY_LIST;
    }

    @Override
    protected void setGroupBy(SortKey[] sortKeys) {
        ProjectSortKey[] tmp = new ProjectSortKey[sortKeys.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = (ProjectSortKey)sortKeys[i];
        }
        this.project.setRowGroupBy(tmp);
    }

    @Override
    protected void setOrder(List<? extends SortKey> newSortKeys) {
        this.project.setRowSortOrder(newSortKeys);
    }
}

