/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.table;

import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.heatmap.AbstractSortDialog;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectSortKey;
import org.broadinstitute.genee.heatmap.SortKeys;
import org.broadinstitute.genee.heatmap.SortOrder;
import org.broadinstitute.genee.matrix.MetadataModel;

public class SortRowsDialog
extends AbstractSortDialog {
    public SortRowsDialog(HeatMapPanel heatmapPanel) {
        super(heatmapPanel, true);
    }

    @Override
    protected List<ProjectSortKey> createComboBoxItems() {
        int j;
        Project project = Application.getProject();
        ArrayList<ProjectSortKey> sortColumns = new ArrayList<ProjectSortKey>();
        sortColumns.add(AbstractSortDialog.EmptySortKey.INSTANCE);
        MetadataModel rowMetadata = project.getOriginalDataset().getRowMetadata();
        int size = rowMetadata.getMetadataCount();
        for (int j2 = 0; j2 < size; ++j2) {
            sortColumns.add(new SortKeys.VectorSortKey(rowMetadata.getColumnName(j2), SortOrder.UNSORTED, true));
        }
        MetadataModel columnMetadata = project.getOriginalDataset().getColumnMetadata();
        int size2 = columnMetadata.getMetadataCount();
        for (j = 0; j < size2; ++j) {
            if (!Number.class.isAssignableFrom(columnMetadata.get(j).getColumnClass())) continue;
            sortColumns.add(new SortKeys.CorrelationSortKey(columnMetadata.getColumnName(j), SortOrder.UNSORTED));
        }
        int columns = project.getOriginalDataset().getColumnCount();
        for (j = 0; j < columns; ++j) {
            sortColumns.add(new SortKeys.SortByValues(project, j, SortOrder.UNSORTED, true));
        }
        return sortColumns;
    }

    @Override
    protected void setGroupBy(ProjectSortKey[] sortKeys) {
        Application.getProject().setRowGroupBy(sortKeys);
    }

    @Override
    protected void setSortOrder(List<ProjectSortKey> sortKeys) {
        Application.getProject().setRowSortOrder(sortKeys);
    }
}

