/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectSortKey;
import org.broadinstitute.genee.heatmap.SortKeys;
import org.broadinstitute.genee.heatmap.SortOrder;
import org.broadinstitute.genee.matrix.Identifier;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.stats.Sorting;
import org.broadinstitute.genee.table.AbstractSortableHeaderRenderer;
import org.broadinstitute.genee.table.IconAdapter;
import org.broadinstitute.genee.table.SortKey;

public class SortingHelper {
    private SortingHelper() {
    }

    public static Identifier createIdentifier(ProjectSortKey[] sortKeys, int nkeys, int index) {
        Object[] array = new Object[nkeys];
        for (int n = 0; n < nkeys; ++n) {
            array[n] = sortKeys[n].getValue(index);
        }
        return new Identifier<Object>(array);
    }

    public static Comparable<?>[][] createComparableArray(Project project, List<? extends ProjectSortKey> sortKeys, boolean byRows) {
        int size = byRows ? project.getOriginalDataset().getRowCount() : project.getOriginalDataset().getColumnCount();
        int sortLevels = sortKeys.size();
        Comparable[][] items = new Comparable[size][sortLevels];
        for (int level = 0; level < sortLevels; ++level) {
            ProjectSortKey sortKey = sortKeys.get(level);
            sortKey.init(project);
            for (int i = 0; i < size; ++i) {
                items[i][level] = sortKey.getValue(i);
            }
        }
        return items;
    }

    public static ItemComparator createComparableArrayComparator(List<? extends SortKey> sortKeys) {
        boolean[] ascending = new boolean[sortKeys.size()];
        Comparator[] comparators = new Comparator[sortKeys.size()];
        for (int i = 0; i < ascending.length; ++i) {
            SortKey sortKey = sortKeys.get(i);
            if (sortKey instanceof SortKeys.VectorSortKey) {
                SortKeys.VectorSortKey metadataSortKey = (SortKeys.VectorSortKey)sortKey;
                Vector col = metadataSortKey.getVector();
                if (col.getComparator() != null) {
                    comparators[i] = col.getComparator();
                } else if (String.class.isAssignableFrom(col.getColumnClass())) {
                    comparators[i] = String.CASE_INSENSITIVE_ORDER;
                }
            }
            ascending[i] = !sortKey.getSortOrder().equals((Object)SortOrder.DESCENDING);
        }
        return new ItemComparator(ascending, comparators);
    }

    public static Icon getIcon(List<? extends ProjectSortKey> sortKeys, ProjectSortKey sortKey) {
        if (sortKeys == null || sortKeys.size() == 0) {
            return null;
        }
        if (sortKey.getSortOrder().equals((Object)SortOrder.UNSORTED)) {
            return null;
        }
        int sortIndex = sortKeys.indexOf(sortKey);
        if (sortIndex == -1) {
            return null;
        }
        if (sortKey.getSortOrder().equals((Object)SortOrder.ASCENDING)) {
            return sortIndex == 0 ? AbstractSortableHeaderRenderer.ASC_ICON : new IconAdapter(AbstractSortableHeaderRenderer.ASC_ICON2, sortIndex);
        }
        if (sortKey.getSortOrder().equals((Object)SortOrder.DESCENDING)) {
            return sortIndex == 0 ? AbstractSortableHeaderRenderer.DESC_ICON : new IconAdapter(AbstractSortableHeaderRenderer.DESC_ICON2, sortIndex);
        }
        return null;
    }

    public static int[] getSortOrder(Project project, List<? extends ProjectSortKey> sortKeys, boolean byRows) {
        if (sortKeys == null || sortKeys.size() == 0) {
            return null;
        }
        Comparable<?>[][] items = SortingHelper.createComparableArray(project, sortKeys, byRows);
        return Sorting.index(items, (Comparator)SortingHelper.createComparableArrayComparator(sortKeys), true);
    }

    public static void setSortOrder(Project project, ProjectSortKey sortKey, boolean additionalSort, boolean byRows, ProjectSortKey[] groupBy) {
        List<? extends ProjectSortKey> sortKeys;
        List<? extends ProjectSortKey> list = sortKeys = byRows ? project.getRowSortKeys() : project.getColumnSortKeys();
        if (sortKey.getSortOrder() == SortOrder.UNSORTED && !additionalSort) {
            if (byRows) {
                project.setRowSortOrder(null);
            } else {
                project.setColumnSortOrder(null);
            }
            return;
        }
        if (additionalSort && sortKeys.size() == 0) {
            additionalSort = false;
        }
        List<ProjectSortKey> newSortKeys = null;
        if (!additionalSort) {
            newSortKeys = Arrays.asList(sortKey);
        } else {
            int sortKeyIndex;
            int n = sortKeyIndex = sortKeys != null ? sortKeys.indexOf(sortKey) : -1;
            if (sortKeyIndex == -1) {
                newSortKeys = new ArrayList<ProjectSortKey>(sortKeys);
                newSortKeys.add(sortKey);
            } else {
                newSortKeys = new ArrayList<ProjectSortKey>(sortKeys);
                newSortKeys.set(sortKeyIndex, sortKey);
            }
        }
        if (byRows) {
            project.setRowSortOrder(newSortKeys);
            project.setRowGroupBy(groupBy);
        } else {
            project.setColumnSortOrder(newSortKeys);
            project.setColumnGroupBy(groupBy);
        }
    }

    public static SortOrder toggleSortOrder(ProjectSortKey sortKey) {
        SortOrder sortOrder = null;
        sortOrder = sortKey.getSortOrder() == SortOrder.UNSORTED ? SortOrder.ASCENDING : (sortKey.getSortOrder() == SortOrder.ASCENDING ? SortOrder.DESCENDING : SortOrder.UNSORTED);
        return sortOrder;
    }

    private static class ItemComparator
    implements Comparator<Comparable<?>[]> {
        private boolean[] ascending;
        private Comparator<Object>[] comparators;

        public ItemComparator(boolean[] ascending, Comparator<Object>[] comparators) {
            this.ascending = ascending;
            this.comparators = comparators;
        }

        @Override
        public int compare(Comparable<?>[] o1, Comparable<?>[] o2) {
            int length = o1.length;
            for (int i = 0; i < length; ++i) {
                int result;
                Comparator<Object> c = this.comparators[i];
                int n = result = this.ascending[i] ? ItemComparator._compare(o1[i], o2[i], c) : ItemComparator._compare(o2[i], o1[i], c);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }

        private static int _compare(Comparable c1, Comparable c2, Comparator comparator) {
            int result = 0;
            if (c1 == null && c2 == null) {
                return 0;
            }
            if (c1 == null) {
                return -1;
            }
            if (c2 == null) {
                return 1;
            }
            result = comparator != null ? comparator.compare(c1, c2) : c1.compareTo(c2);
            return result;
        }
    }
}

