/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.table;

import javax.swing.table.TableModel;
import org.broadinstitute.genee.heatmap.AbstractSortKey;
import org.broadinstitute.genee.heatmap.SortOrder;

public class TableColumnSortKey
extends AbstractSortKey {
    private int columnIndex;
    private TableModel tableModel;
    private String columnName;

    public TableColumnSortKey(String columnName, TableModel tableModel) {
        super(SortOrder.ASCENDING);
        this.columnName = columnName;
        this.tableModel = tableModel;
        this.setColumnIndex();
    }

    public void setColumnIndex() {
        int cols = this.tableModel.getColumnCount();
        for (int i = 0; i < cols; ++i) {
            if (!this.columnName.equals(this.tableModel.getColumnName(i))) continue;
            this.columnIndex = i;
            break;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof TableColumnSortKey) {
            TableColumnSortKey t = (TableColumnSortKey)obj;
            return this.columnName.equals(t.columnName) && this.tableModel.equals(t.tableModel);
        }
        return false;
    }

    @Override
    public Comparable<?> getValue(int index) {
        return (Comparable)this.tableModel.getValueAt(index, this.columnIndex);
    }

    public int hashCode() {
        return this.columnName.hashCode();
    }

    public String toString() {
        return this.columnName;
    }
}

