/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import org.flowcyt.cfcs.CFCSData;
import org.flowcyt.cfcs.CFCSDataSizing;
import org.flowcyt.cfcs.CFCSDatatype;
import org.flowcyt.cfcs.CFCSError;
import org.flowcyt.cfcs.CFCSErrorCodes;
import org.flowcyt.cfcs.CFCSKeyword;
import org.flowcyt.cfcs.CFCSKeywords;
import org.flowcyt.cfcs.CFCSParameters;

public abstract class CFCSAbstractData
implements CFCSData,
CFCSErrorCodes {
    protected static final int BITSPERBYTE = 8;
    protected int type = 0;
    protected final CFCSDatatype datatype;
    protected final CFCSKeywords keywords;
    protected final CFCSParameters parameters;
    protected CFCSDataSizing sizing;
    protected byte[][][] cinched;
    protected static final int[] JAVA_BYTESWAP_ARRAY = new int[]{4, 3, 2, 1};

    CFCSAbstractData(int type, CFCSDatatype datatype, CFCSKeywords keywords) {
        this.type = type;
        this.datatype = datatype;
        this.keywords = keywords;
        this.parameters = new CFCSParameters(keywords);
        if (keywords.getSystemKeyword("$BYTEORD") == null) {
            keywords.setByteSwapArray(JAVA_BYTESWAP_ARRAY);
        }
    }

    @Override
    public final int getType() {
        return this.type;
    }

    protected byte[] packBytes(byte[] bytes) {
        throw new CFCSError(-33);
    }

    protected byte[] unpackBytes(byte[] bytes) {
        throw new CFCSError(-33);
    }

    protected abstract byte[][][] cinchBytes(byte[] var1);

    @Override
    public abstract byte[] getBytes();

    @Override
    public void setBytes(byte[] bytes) {
        if (this.sizing.isPackedData()) {
            bytes = this.unpackBytes(bytes);
        }
        this.cinched = this.cinchBytes(bytes);
        if (this.keywords.getDatatype() != 1) {
            this.swapCinchedBytes();
        }
    }

    protected final void swapCinchedBytes() {
        int[] swap = this.keywords.getByteSwapArray();
        for (int outer = 0; outer < this.cinched.length; ++outer) {
            for (int inner = 0; inner < this.cinched[outer].length; ++inner) {
                byte[] cinch = this.cinched[outer][inner];
                int nBytes = cinch.length;
                if (nBytes == 1) continue;
                if (nBytes > 2 && nBytes % 4 != 0) {
                    throw new CFCSError(-33, "swapCinchedBytes(" + nBytes + ")");
                }
                byte[] temporary = new byte[nBytes];
                int sBytes = nBytes % swap.length;
                if (sBytes == 0) {
                    sBytes = swap.length;
                }
                for (int swaps = 0; swaps < nBytes; swaps += sBytes) {
                    for (int i = 0; i < sBytes; ++i) {
                        temporary[i + swaps] = cinch[swaps + (swap[swap.length - 1 - i] - 1) % sBytes];
                    }
                }
                for (int i = 0; i < nBytes; ++i) {
                    cinch[i] = temporary[i];
                }
            }
        }
    }

    public final int getCount() {
        CFCSKeyword keyword = null;
        try {
            keyword = this.keywords.getKeyword("$TOT");
        }
        catch (CFCSError error) {
            return 0;
        }
        return keyword.getKeywordIntegerValue();
    }

    protected final void setCount(int count) {
        this.keywords.addSystemKeyword(new CFCSKeyword("$TOT", count));
    }

    protected final void addCount(int count) {
        CFCSKeyword keyword = null;
        try {
            keyword = this.keywords.getKeyword("$TOT");
        }
        catch (CFCSError exception) {
            keyword = new CFCSKeyword("$TOT", 0);
        }
        keyword.setKeywordIntegerValue(count + keyword.getKeywordIntegerValue());
        this.keywords.addSystemKeyword(keyword);
    }

    protected static final boolean isDelimiter(char c) {
        return Character.isWhitespace(c) || c == ',';
    }
}

