/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import org.flowcyt.cfcs.CFCSError;
import org.flowcyt.cfcs.CFCSErrorCodes;

public abstract class CFCSAbstractParameter
implements Cloneable,
CFCSErrorCodes {
    protected String shortName = null;
    protected String fullName = null;
    protected String filter = null;
    protected String detector = null;
    protected int range = Integer.MIN_VALUE;
    protected double percent = Double.NaN;
    protected double voltage = Double.NaN;
    protected double decades = Double.NaN;
    protected double offset = Double.NaN;

    static final boolean isSet(String value) {
        return value != null;
    }

    static final boolean isSet(double value) {
        return !Double.isNaN(value);
    }

    static final boolean isSet(int value) {
        return value != Integer.MIN_VALUE;
    }

    static final boolean isNotSet(String value) {
        return value == null;
    }

    static final boolean isNotSet(double value) {
        return Double.isNaN(value);
    }

    static final boolean isNotSet(int value) {
        return value == Integer.MIN_VALUE;
    }

    final boolean isEmpty(String value) {
        return CFCSAbstractParameter.isNotSet(value) || value.length() == 0;
    }

    final CFCSAbstractParameter copy() {
        CFCSAbstractParameter duplicate = null;
        try {
            duplicate = (CFCSAbstractParameter)this.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new CFCSError(-10, (Throwable)exception);
        }
        return duplicate;
    }

    public final String getFullName() {
        if (CFCSAbstractParameter.isNotSet(this.fullName)) {
            throw new CFCSError(7, "FullName");
        }
        return this.fullName;
    }

    public final void setFullName(String fullName) {
        if (this.isEmpty(fullName)) {
            throw new CFCSError(-20, "(empty string)");
        }
        this.fullName = fullName;
    }

    public final String getShortName() {
        if (CFCSAbstractParameter.isNotSet(this.shortName)) {
            throw new CFCSError(7, "ShortName");
        }
        return this.shortName;
    }

    public final void setShortName(String shortName) {
        if (this.isEmpty(shortName)) {
            throw new CFCSError(-20, "(empty string)");
        }
        this.shortName = shortName;
    }

    public final int getRange() {
        if (CFCSAbstractParameter.isNotSet(this.range)) {
            throw new CFCSError(7, "Range");
        }
        return this.range;
    }

    public final void setRange(int range) {
        if (range < 2) {
            throw new CFCSError(-20, range);
        }
        this.range = range;
    }

    public final String getFilter() {
        if (CFCSAbstractParameter.isNotSet(this.filter)) {
            throw new CFCSError(7, "Filter");
        }
        return this.filter;
    }

    public final void setFilter(String filter) {
        if (this.isEmpty(filter)) {
            throw new CFCSError(-20, "(empty string)");
        }
        this.filter = filter;
    }

    public final double getEmittedPercent() {
        if (CFCSAbstractParameter.isNotSet(this.percent)) {
            throw new CFCSError(7, "EmittedPercent");
        }
        return this.percent;
    }

    public final void setEmittedPercent(double percent) {
        if (percent < 0.0) {
            throw new CFCSError(-20, percent);
        }
        this.percent = percent;
    }

    public final double getVoltage() {
        if (CFCSAbstractParameter.isNotSet(this.voltage)) {
            throw new CFCSError(7, "Voltage");
        }
        return this.voltage;
    }

    public final void setVoltage(double voltage) {
        if (voltage < 0.0) {
            throw new CFCSError(-20, voltage);
        }
        this.voltage = voltage;
    }

    public final String getDetectorType() {
        if (CFCSAbstractParameter.isNotSet(this.detector)) {
            throw new CFCSError(7, "DetectorType");
        }
        return this.detector;
    }

    public final void setDetectorType(String detector) {
        if (this.isEmpty(detector)) {
            throw new CFCSError(-20, "(empty string)");
        }
        this.detector = detector;
    }

    public final double getLogDecades() {
        if (CFCSAbstractParameter.isNotSet(this.decades)) {
            return 0.0;
        }
        if (CFCSAbstractParameter.isNotSet(this.decades)) {
            throw new CFCSError(7, "LogDecades");
        }
        return this.decades;
    }

    public void setLogDecades(double decades) {
        if (decades < 0.0) {
            throw new CFCSError(-20, decades);
        }
        if (decades == 0.0 && CFCSAbstractParameter.isSet(this.offset) && this.offset != 0.0) {
            throw new CFCSError(-21, "Offset");
        }
        this.decades = decades;
    }

    public final double getOffset() {
        if (CFCSAbstractParameter.isNotSet(this.offset)) {
            throw new CFCSError(7, "Offset");
        }
        return this.offset;
    }

    public final void setOffset(double offset) {
        if (offset < 0.0) {
            throw new CFCSError(-20, offset);
        }
        this.offset = offset;
    }

    public final String getLogDecadesAndOffset() {
        StringBuffer buffer = new StringBuffer();
        double exact = this.getLogDecades();
        long integral = new Double(exact).longValue();
        if ((double)integral == exact) {
            buffer.append(integral);
        } else {
            buffer.append(exact);
        }
        buffer.append(',');
        exact = this.getOffset();
        integral = new Double(exact).longValue();
        if ((double)integral == exact) {
            buffer.append(integral);
        } else {
            buffer.append(exact);
        }
        return buffer.toString();
    }

    public final void setLogDecadesAndOffset(String string) {
        if (this.isEmpty(string)) {
            throw new CFCSError(-20, "(empty string)");
        }
        int classesma = string.indexOf(44);
        if (classesma > 0) {
            try {
                this.setLogDecades(new Double(string.substring(0, classesma)));
                this.setOffset(new Double(string.substring(classesma + 1)));
            }
            catch (NumberFormatException exception) {
                throw new CFCSError(-20, (Throwable)exception);
            }
        } else {
            throw new CFCSError(-20, string);
        }
    }
}

