/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.flowcyt.cfcs.CFCSAbstractParameter;
import org.flowcyt.cfcs.CFCSError;
import org.flowcyt.cfcs.CFCSErrorCodes;
import org.flowcyt.cfcs.CFCSKeyword;
import org.flowcyt.cfcs.CFCSKeywords;

public abstract class CFCSAbstractParameters
implements CFCSErrorCodes {
    protected static final String REQUIRED = "Y";
    protected static final int PARAMETER_CODE = 0;
    protected static final int PARAMETER_PROPERTY = 1;
    protected static final int PARAMETER_REQUIRED = 2;
    protected final CFCSKeywords keywords;
    protected final Map parameter_descriptors = new HashMap();
    protected static final String[] keyword_properties = new String[]{"KeywordValue", "KeywordIntegerValue", "KeywordDoubleValue"};
    protected static final Map keyword_descriptors = new HashMap();

    CFCSAbstractParameters(CFCSKeywords keywords, Class target) {
        this.keywords = keywords;
        this.initializeParameterDescriptors(target);
    }

    protected final void initializeParameterDescriptors(Class target) {
        String[][] parameter_properties;
        for (String[] parameter_property : parameter_properties = this.getProperties()) {
            PropertyDescriptor descriptor;
            String property = parameter_property[1];
            try {
                descriptor = new PropertyDescriptor(property, target);
            }
            catch (IntrospectionException exception) {
                throw new CFCSError(-10, (Throwable)exception);
            }
            this.parameter_descriptors.put(property, descriptor);
        }
    }

    protected abstract String getPrefix();

    protected abstract String[][] getProperties();

    protected abstract String getCountKeyword();

    protected final boolean isRequired(String property) {
        String[][] parameter_properties;
        for (String[] parameter_property : parameter_properties = this.getProperties()) {
            if (!property.equalsIgnoreCase(parameter_property[1])) continue;
            return CFCSAbstractParameters.isRequired(parameter_property);
        }
        throw new CFCSError(-8, property);
    }

    protected static boolean isRequired(String[] property) {
        return property[2].equalsIgnoreCase(REQUIRED);
    }

    public final int getCount() {
        CFCSKeyword keyword;
        try {
            keyword = this.keywords.getKeyword(this.getCountKeyword());
        }
        catch (CFCSError error) {
            return 0;
        }
        return keyword.getKeywordIntegerValue();
    }

    public final void setCount(int count) {
        CFCSKeyword keyword;
        String name = this.getCountKeyword();
        try {
            keyword = this.keywords.getKeyword(name);
        }
        catch (CFCSError exception) {
            keyword = new CFCSKeyword(name, count);
        }
        keyword.setKeywordIntegerValue(count);
        this.keywords.addSystemKeyword(keyword);
    }

    protected final void getParameter(int index, CFCSAbstractParameter parameter) {
        String[][] parameter_properties;
        if (++index < 1 || index > this.getCount()) {
            throw new CFCSError(-8, index);
        }
        for (String[] parameter_property : parameter_properties = this.getProperties()) {
            CFCSKeyword keyword = this.keywords.getSystemKeyword(this.getPrefix() + index + parameter_property[0]);
            if (keyword == null) continue;
            String property = parameter_property[1];
            PropertyDescriptor parameter_desc = (PropertyDescriptor)this.parameter_descriptors.get(property);
            PropertyDescriptor keyword_desc = (PropertyDescriptor)keyword_descriptors.get(parameter_desc.getPropertyType());
            try {
                Object[] arguments = new Object[]{keyword_desc.getReadMethod().invoke((Object)keyword, new Object[0])};
                parameter_desc.getWriteMethod().invoke((Object)parameter, arguments);
            }
            catch (InvocationTargetException exception) {
                Throwable target = exception.getTargetException();
                if (target instanceof CFCSError) {
                    if (((CFCSError)target).errorNumber == -30) {
                        if (!CFCSAbstractParameters.isRequired(parameter_property)) continue;
                        throw new CFCSError(-24, property);
                    }
                    throw (CFCSError)target;
                }
                throw new CFCSError(-10, (Throwable)exception);
            }
            catch (Exception exception) {
                throw new CFCSError(-10, (Throwable)exception);
            }
        }
    }

    public final void addParameter(CFCSAbstractParameter parameter) {
        String[][] parameter_properties;
        CFCSKeyword parameters;
        try {
            parameters = this.keywords.getKeyword(this.getCountKeyword());
        }
        catch (CFCSError error) {
            parameters = new CFCSKeyword(this.getCountKeyword(), 0);
        }
        int index = parameters.getKeywordIntegerValue() + 1;
        for (String[] parameter_property : parameter_properties = this.getProperties()) {
            String property = parameter_property[1];
            CFCSKeyword keyword = new CFCSKeyword();
            keyword.setKeywordName(this.getPrefix() + index + parameter_property[0]);
            keyword.setKeywordSource(1);
            PropertyDescriptor parameter_desc = (PropertyDescriptor)this.parameter_descriptors.get(property);
            PropertyDescriptor keyword_desc = (PropertyDescriptor)keyword_descriptors.get(parameter_desc.getPropertyType());
            try {
                Object[] arguments = new Object[]{parameter_desc.getReadMethod().invoke((Object)parameter, new Object[0])};
                keyword_desc.getWriteMethod().invoke((Object)keyword, arguments);
                this.keywords.addSystemKeyword(keyword);
            }
            catch (InvocationTargetException exception) {
                Throwable target = exception.getTargetException();
                if (target instanceof CFCSError) {
                    if (((CFCSError)target).errorNumber == 7) {
                        if (!CFCSAbstractParameters.isRequired(parameter_property)) continue;
                        throw new CFCSError(-24, property);
                    }
                    throw (CFCSError)target;
                }
                throw new CFCSError(-10, (Throwable)exception);
            }
            catch (Exception exception) {
                throw new CFCSError(-10, (Throwable)exception);
            }
        }
        parameters.setKeywordIntegerValue(index);
        this.keywords.addSystemKeyword(parameters);
    }

    public final void replaceParameter(int index, CFCSAbstractParameter parameter) {
        if (index < 0 || index >= this.getCount()) {
            throw new CFCSError(-8, index);
        }
        String[][] parameter_properties = this.getProperties();
        for (int i = 0; i < parameter_properties.length; ++i) {
            String[] parameter_property = parameter_properties[i];
            String property = parameter_property[1];
            CFCSKeyword keyword = new CFCSKeyword();
            keyword.setKeywordName(this.getPrefix() + (index + 1) + parameter_property[0]);
            keyword.setKeywordSource(1);
            PropertyDescriptor parameter_desc = (PropertyDescriptor)this.parameter_descriptors.get(property);
            PropertyDescriptor keyword_desc = (PropertyDescriptor)keyword_descriptors.get(parameter_desc.getPropertyType());
            try {
                Object[] arguments = new Object[]{parameter_desc.getReadMethod().invoke((Object)parameter, new Object[0])};
                keyword_desc.getWriteMethod().invoke((Object)keyword, arguments);
                this.keywords.replaceSystemKeyword(keyword);
                continue;
            }
            catch (InvocationTargetException exception) {
                Throwable target = exception.getTargetException();
                if (target instanceof CFCSError) {
                    if (((CFCSError)target).errorNumber == 7) {
                        if (!CFCSAbstractParameters.isRequired(parameter_property)) continue;
                        throw new CFCSError(-24, property);
                    }
                    throw (CFCSError)target;
                }
                throw new CFCSError(-10, (Throwable)exception);
            }
            catch (Exception exception) {
                throw new CFCSError(-10, (Throwable)exception);
            }
        }
    }

    public void deleteParameter(int index) {
        if (index < 0 || index >= this.getCount()) {
            throw new CFCSError(-8, index);
        }
        throw new CFCSError(-33, "CFCSAbstractParameters.deleteParameter(int)");
    }

    static {
        for (String property : keyword_properties) {
            PropertyDescriptor descriptor;
            try {
                descriptor = new PropertyDescriptor(property, CFCSKeyword.class);
            }
            catch (IntrospectionException exception) {
                throw new CFCSError(-10, (Throwable)exception);
            }
            keyword_descriptors.put(descriptor.getPropertyType(), descriptor);
        }
    }
}

