/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.flowcyt.cfcs.CFCSAbstractData;
import org.flowcyt.cfcs.CFCSDataScaleError;
import org.flowcyt.cfcs.CFCSDataSizeError;
import org.flowcyt.cfcs.CFCSDataSizing;
import org.flowcyt.cfcs.CFCSDatatype;
import org.flowcyt.cfcs.CFCSError;
import org.flowcyt.cfcs.CFCSErrorCodes;
import org.flowcyt.cfcs.CFCSKeywords;

public final class CFCSCorrelatedData
extends CFCSAbstractData
implements CFCSErrorCodes {
    CFCSCorrelatedData(CFCSDatatype datatype, CFCSKeywords keywords) {
        super(2, datatype, keywords);
        this.sizing = new CFCSDataSizing(keywords);
        datatype.setSizingObject(this.sizing);
    }

    @Override
    protected final byte[][][] cinchBytes(byte[] bytes) {
        int nBytes = this.sizing.getByteSize();
        int innerRange = this.parameters.getParameter(0).getRange();
        int outerRange = this.parameters.getParameter(1).getRange();
        byte[][][] cinched = new byte[outerRange][innerRange][];
        int position = 0;
        for (int outer = 0; outer < outerRange; ++outer) {
            int inner = 0;
            while (inner < innerRange) {
                byte[] byArray = new byte[nBytes];
                cinched[outer][inner] = byArray;
                byte[] cinch = byArray;
                System.arraycopy(bytes, position, cinch, 0, nBytes);
                ++inner;
                position += nBytes;
            }
        }
        return cinched;
    }

    @Override
    public final byte[] getBytes() {
        int outer = this.parameters.getParameter(1).getRange();
        int inner = this.parameters.getParameter(0).getRange();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            DataOutputStream stream = new DataOutputStream(buffer);
            for (int bin = 0; bin < outer; ++bin) {
                try {
                    this.datatype.writeData(bin, inner, stream);
                    continue;
                }
                catch (IndexOutOfBoundsException exception) {
                    throw new CFCSError(-36, bin);
                }
            }
            stream.close();
        }
        catch (IOException exception) {
            throw new CFCSError(-14, (Throwable)exception);
        }
        byte[] bytes = buffer.toByteArray();
        return this.sizing.isPackedData() ? this.packBytes(bytes) : bytes;
    }

    @Override
    public final void setBytes(byte[] bytes) {
        super.setBytes(bytes);
        int range = this.parameters.getParameter(1).getRange();
        for (int bin = 0; bin < range; ++bin) {
            try {
                this.datatype.readData(bin, this.cinched[bin]);
                continue;
            }
            catch (IndexOutOfBoundsException exception) {
                throw new CFCSError(-36, bin);
            }
        }
    }

    public final void getArray(int[][] table) {
        for (int outer = 0; outer < table.length; ++outer) {
            try {
                this.datatype.getData(outer, table[outer]);
                continue;
            }
            catch (IndexOutOfBoundsException exception) {
                throw new CFCSError(-36, outer);
            }
            catch (CFCSDataScaleError exception) {
                throw new CFCSError(-33);
            }
            catch (CFCSDataSizeError exception) {
                throw new CFCSError(-33);
            }
        }
    }

    public final void setArray(int[][] table) {
        int events = 0;
        for (int outer = 0; outer < table.length; ++outer) {
            try {
                this.datatype.addData(table[outer]);
            }
            catch (CFCSDataScaleError exception) {
                throw new CFCSError(-33);
            }
            for (int inner = 0; inner < table[outer].length; ++inner) {
                events += table[outer][inner];
            }
        }
        this.setCount(events);
    }

    public final void getArray(int nBytes, byte[][][] table) {
        int innerRange = this.parameters.getParameter(0).getRange();
        int outerRange = this.parameters.getParameter(1).getRange();
        if (table.length < outerRange) {
            throw new CFCSError(-35, table.length);
        }
        for (int outer = 0; outer < outerRange; ++outer) {
            byte[][] bins = table[outer];
            if (bins.length < innerRange) {
                throw new CFCSError(-35, bins.length);
            }
            for (int inner = 0; inner < innerRange; ++inner) {
                int i;
                byte[] bytes = bins[inner];
                if (bytes.length < nBytes) {
                    throw new CFCSError(-35, bytes.length);
                }
                byte[] cinch = this.cinched[outer][inner];
                int length = cinch.length;
                int limit = nBytes - length;
                for (i = 0; i < limit; ++i) {
                    bytes[i] = 0;
                }
                for (i = 0; i < length; ++i) {
                    bytes[limit + i] = cinch[i];
                }
            }
        }
    }

    public static final void setArray(int nBytes, byte[][][] table) {
        throw new CFCSError(-33);
    }
}

