/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.flowcyt.cfcs.CFCSCorrelatedData;
import org.flowcyt.cfcs.CFCSData;
import org.flowcyt.cfcs.CFCSDatatype;
import org.flowcyt.cfcs.CFCSDatatypeASCII;
import org.flowcyt.cfcs.CFCSDatatypeBinary;
import org.flowcyt.cfcs.CFCSDatatypeDouble;
import org.flowcyt.cfcs.CFCSDatatypeFloat;
import org.flowcyt.cfcs.CFCSError;
import org.flowcyt.cfcs.CFCSErrorCodes;
import org.flowcyt.cfcs.CFCSGatingParameters;
import org.flowcyt.cfcs.CFCSKeyword;
import org.flowcyt.cfcs.CFCSKeywords;
import org.flowcyt.cfcs.CFCSListModeData;
import org.flowcyt.cfcs.CFCSOtherSegment;
import org.flowcyt.cfcs.CFCSParameters;
import org.flowcyt.cfcs.CFCSSystem;
import org.flowcyt.cfcs.CFCSUncorrelatedData;

public final class CFCSDataSet
implements CFCSErrorCodes {
    public static final int UNDEFINED = -1;
    public static final int HEADER = 0;
    public static final int TEXT = 1;
    public static final int DATA = 2;
    public static final int ANALYSIS = 3;
    public static final int OTHER_START = 4;
    private static final int VERSION_FIELD_SIZE = 10;
    private static final int OFFSET_FIELD_SIZE = 8;
    private static final int CHECKSUM_FIELD_SIZE = 8;
    private static final int BLOCK_SIZE = 256;
    private static final int HEADER_OFFSET_LIMIT = 99999999;
    private static final String DISABLED_CHECKSUM = "00000000";
    private static final int CHECKSUM_DISABLED = -1;
    private static final String VERSION_PREFIX = "FCS";
    private static final int SEGMENT = 0;
    private static final int BEGIN = 1;
    private static final int END = 2;
    private static final String DEFAULT_VERSION = "FCS3.0";
    private static final String HEADER_RESERVED = "    ";
    static final int DEFAULT_DATATYPE = 4;
    private CFCSData data;
    private String version = "FCS3.0";
    private final CFCSKeywords keywords = new CFCSKeywords();
    private final List segments = new ArrayList(4);
    private int crc16 = 0;
    private boolean bReadSegmentsFirstTime = true;
    private static final Comparator comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            long i1 = ((long[])o1)[1];
            long i2 = ((long[])o2)[1];
            return new Long(i1).compareTo(new Long(i2));
        }
    };

    CFCSDataSet() {
        for (int i = 0; i < 4; ++i) {
            this.segments.add(null);
        }
    }

    CFCSDataSet(CFCSSystem.SentientInputStream stream) {
        this();
        LinkedList<long[]> headers = new LinkedList<long[]>();
        try {
            long[] header;
            long end;
            long begin;
            int i;
            this.version = CFCSDataSet.readFileVersion(stream);
            if (this.getVersionIntegerValue() < 2) {
                throw new CFCSError(-4, this.version);
            }
            long first = Long.MAX_VALUE;
            for (i = 1; i < 4; ++i) {
                begin = CFCSDataSet.readOffset(stream);
                end = CFCSDataSet.readOffset(stream);
                header = new long[]{i, begin, end};
                headers.add(header);
                if (begin <= 0L || begin >= first) continue;
                first = begin;
            }
            i = 4;
            while (stream.getFilePointer() + 16L <= first) {
                begin = CFCSDataSet.readOffset(stream);
                end = CFCSDataSet.readOffset(stream);
                if (begin != 0L && end != 0L) {
                    header = new long[]{i, begin, end};
                    headers.add(header);
                    this.segments.add(null);
                    if (begin > 0L && begin < first) {
                        first = begin;
                    }
                }
                ++i;
            }
            this.readSegments(headers, stream);
            this.addKeywords(1);
            if (this.getVersionIntegerValue() >= 3) {
                headers.clear();
                this.segments.set(1, null);
                for (i = 1; i < 4; ++i) {
                    CFCSKeyword keyword = this.keywords.getKeyword("$BEGIN" + CFCSKeywords.SEGMENT_ROOTS[i]);
                    long begin2 = keyword.getKeywordLongValue();
                    keyword = this.keywords.getKeyword("$END" + CFCSKeywords.SEGMENT_ROOTS[i]);
                    long end2 = keyword.getKeywordLongValue();
                    long[] header2 = new long[]{i, begin2, end2};
                    headers.add(header2);
                }
                this.readSegments(headers, stream);
                if (this.segments.get(1) != null) {
                    this.addKeywords(1);
                }
                this.crc16 = stream.getCRC16();
                int checksum = CFCSDataSet.readFileChecksum(stream);
                if (checksum != -1 && checksum != this.crc16) {
                    throw new CFCSError(-12, "Malformed checksum, read in file: " + checksum + ", computed: " + this.crc16);
                }
            }
            if (this.segments.get(3) != null) {
                this.addKeywords(3);
            }
            this.data = this.selectMode(this.selectDatatype());
            byte[] bytes = (byte[])this.segments.get(2);
            this.data.setBytes(bytes);
        }
        catch (IOException exception) {
            throw new CFCSError(2, (Throwable)exception);
        }
    }

    CFCSDataSet(CFCSDataSet source) {
        this();
        try {
            int i;
            CFCSKeywords sourceKeywords = source.getKeywords();
            int count = sourceKeywords.getCount();
            for (i = 0; i < count; ++i) {
                CFCSKeyword keyword = sourceKeywords.getKeyword(i);
                String name = keyword.getKeywordName();
                if (CFCSKeywords.NONTRANSFERABLE_KEYWORDS.contains(name)) continue;
                this.keywords.addSystemKeyword(keyword);
            }
            count = source.getCount();
            for (i = 4; i < count; ++i) {
                CFCSOtherSegment segment = source.getOtherSegment(i);
                this.segments.add(segment.copy());
            }
        }
        catch (CFCSError exception) {
            throw new CFCSError(-28, exception);
        }
        this.data = this.selectMode(this.selectDatatype());
    }

    CFCSDataSet(int mode, int type) {
        this();
        if (this.keywords.getMode() != 0) {
            throw new CFCSError(-23, "$MODE");
        }
        this.keywords.setMode(mode);
        if (this.keywords.getDatatype() != 0) {
            throw new CFCSError(-23, "$DATATYPE");
        }
        this.keywords.setDatatype(type);
        new CFCSParameters(this.keywords).setCount(0);
        this.data = this.selectMode(this.selectDatatype());
    }

    final void writeDataSet(CFCSSystem.SentientOutputStream stream, long another) {
        CFCSKeyword nextdata;
        for (int i = 1; i < 4; ++i) {
            String suffix = CFCSKeywords.SEGMENT_ROOTS[i];
            String[] prefixes = new String[]{"$BEGIN", "$END"};
            for (int j = 0; j < prefixes.length; ++j) {
                CFCSKeyword keyword = null;
                String offset = prefixes[j] + suffix;
                try {
                    keyword = this.keywords.getKeyword(offset);
                    keyword.setKeywordLongValue(Long.MAX_VALUE);
                }
                catch (CFCSError exception) {
                    keyword = new CFCSKeyword(offset, Long.MAX_VALUE);
                }
                this.keywords.addSystemKeyword(keyword);
            }
        }
        try {
            nextdata = this.keywords.getKeyword("$NEXTDATA");
            nextdata.setKeywordLongValue(Long.MAX_VALUE);
        }
        catch (CFCSError exception) {
            nextdata = new CFCSKeyword("$NEXTDATA", Long.MAX_VALUE);
        }
        this.keywords.addSystemKeyword(nextdata);
        LinkedList<long[]> headers = new LinkedList<long[]>();
        int stext = -1;
        byte[] text = null;
        for (int segIdx = 0; segIdx < 4; ++segIdx) {
            byte[] bytes = null;
            switch (segIdx) {
                case 0: {
                    bytes = this.generateHeader(headers, stext);
                    break;
                }
                case 1: {
                    text = this.keywords.getBytes(1);
                    bytes = text;
                    break;
                }
                case 2: {
                    bytes = this.data.getBytes();
                    break;
                }
                case 3: {
                    bytes = this.keywords.getBytes(3);
                    break;
                }
            }
            this.segments.set(segIdx, bytes);
        }
        if (text.length + 256 > 99999999) {
            byte[] other_keywords = this.keywords.getTextBytes(false);
            if (other_keywords != null) {
                this.segments.set(1, this.keywords.getTextBytes(true));
                stext = 4;
                this.segments.add(4, other_keywords);
            } else {
                throw new CFCSError(-12);
            }
        }
        long next = 0L;
        long position = 0L;
        int size = this.segments.size();
        for (int i = 0; i < size; ++i) {
            long begin = 0L;
            long end = 0L;
            byte[] bytes = (byte[])this.segments.get(i);
            if (bytes != null) {
                begin = position;
                end = position + (long)bytes.length - 1L;
                long[] header = new long[]{i, begin, end};
                headers.add(header);
                next = end + 1L;
                position = CFCSDataSet.roundToBlock(next);
            }
            if ((i <= 0 || i >= 4) && i != stext) continue;
            int index = i;
            if (index == 1) {
                end = 0L;
                begin = 0L;
            } else if (index == stext) {
                index = 1;
            }
            CFCSKeyword keyword = this.keywords.getKeyword("$BEGIN" + CFCSKeywords.SEGMENT_ROOTS[index]);
            keyword.setKeywordLongValue(begin);
            this.keywords.replaceSystemKeyword(keyword);
            keyword = this.keywords.getKeyword("$END" + CFCSKeywords.SEGMENT_ROOTS[index]);
            keyword.setKeywordLongValue(end);
            this.keywords.replaceSystemKeyword(keyword);
        }
        if (another > -1L) {
            next = CFCSDataSet.roundToBlock(next + 8L);
            nextdata.setKeywordLongValue(another + next);
        } else {
            nextdata.setKeywordLongValue(0L);
        }
        this.keywords.replaceSystemKeyword(nextdata);
        this.segments.set(1, stext == -1 ? this.keywords.getBytes(1) : this.keywords.getTextBytes(true));
        long[] header = (long[])headers.get(1);
        header[2] = header[1] + (long)((byte[])this.segments.get(1)).length - 1L;
        this.segments.set(0, this.generateHeader(headers, stext));
        header = (long[])headers.get(0);
        header[2] = header[1] + (long)((byte[])this.segments.get(0)).length - 1L;
        try {
            this.writeSegments(headers, stream);
            CFCSDataSet.writeFileChecksum(stream, DISABLED_CHECKSUM);
            if (another > -1L) {
                stream.skip(next - stream.getFilePointer());
            }
        }
        catch (IOException exception) {
            throw new CFCSError(2, (Throwable)exception);
        }
    }

    private byte[] generateHeader(List headers, int stext) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(DEFAULT_VERSION).append(HEADER_RESERVED);
        int size = this.segments.size();
        for (int i = 1; i < size; ++i) {
            if (i == stext) continue;
            long[] header = new long[]{i, 0L, 0L};
            if (i < headers.size()) {
                header = (long[])headers.get(i);
            }
            if (header[1] > 99999999L || header[2] > 99999999L) {
                if (i >= 4) continue;
                header[2] = 0L;
                header[1] = 0L;
            }
            buffer.append(CFCSDataSet.formatNumber((int)header[1], 8, ' '));
            buffer.append(CFCSDataSet.formatNumber((int)header[2], 8, ' '));
        }
        return buffer.toString().getBytes();
    }

    private static String formatNumber(int offset, int size, char pad) {
        String string = Integer.toString(offset);
        if (string.length() > size) {
            throw new CFCSError(-12);
        }
        while (string.length() < size) {
            string = pad + string;
        }
        return string;
    }

    private static long roundToBlock(long offset) {
        return (offset / 256L + 1L) * 256L;
    }

    private CFCSData selectMode(CFCSDatatype datatype) {
        int mode = this.keywords.getMode();
        switch (mode) {
            case 1: {
                return new CFCSListModeData(datatype, this.keywords);
            }
            case 2: {
                return new CFCSCorrelatedData(datatype, this.keywords);
            }
            case 3: {
                return new CFCSUncorrelatedData(datatype, this.keywords);
            }
        }
        throw new CFCSError(-20, mode);
    }

    private CFCSDatatype selectDatatype() {
        int type = this.keywords.getDatatype();
        switch (type) {
            case 1: {
                return new CFCSDatatypeASCII();
            }
            case 2: {
                return new CFCSDatatypeFloat();
            }
            case 3: {
                return new CFCSDatatypeDouble();
            }
            case 4: {
                return CFCSDatatypeBinary.getDataSubtype(this.getParameters());
            }
        }
        throw new CFCSError(-20, type);
    }

    private static String readFileVersion(InputStream stream) throws IOException {
        byte[] buffer = new byte[10];
        stream.read(buffer, 0, buffer.length);
        return new String(buffer).trim();
    }

    private static int readOffset(InputStream stream) throws IOException {
        byte[] buffer = new byte[8];
        stream.read(buffer, 0, buffer.length);
        String string = new String(buffer).trim();
        int offset = 0;
        if (string.length() > 0) {
            try {
                offset = new Integer(string);
            }
            catch (NumberFormatException exception) {
                throw new CFCSError(-12, "Malformed header offset");
            }
        }
        return offset;
    }

    private void readSegments(List headers, CFCSSystem.SentientInputStream stream) throws IOException {
        Collections.sort(headers, comparator);
        if (this.bReadSegmentsFirstTime && headers.size() > 0) {
            long offset = stream.getFilePointer();
            for (int i = 0; i < headers.size(); ++i) {
                long[] header = (long[])headers.get(i);
                if (header[2] == 0L) continue;
                if (offset == header[1]) break;
                if (offset >= header[1]) continue;
                stream.skip(header[1] - offset);
                break;
            }
            stream.resetCRC();
        }
        for (int i = 0; i < headers.size(); ++i) {
            long size;
            long offset;
            long[] header = (long[])headers.get(i);
            if (header[2] == 0L || header[1] < (offset = stream.getFilePointer())) continue;
            if (offset < header[1]) {
                stream.skip(header[1] - offset);
            }
            if ((size = header[2] - header[1] + 1L) > Integer.MAX_VALUE) {
                throw new CFCSError(-33, "Segment larger than 2G");
            }
            this.segments.set((int)header[0], CFCSDataSet.readSegment(stream, (int)size));
            this.bReadSegmentsFirstTime = false;
        }
    }

    private void writeSegments(List headers, CFCSSystem.SentientOutputStream stream) throws IOException {
        Collections.sort(headers, comparator);
        for (int i = 0; i < headers.size(); ++i) {
            long offset;
            long[] header = (long[])headers.get(i);
            if (header[2] == 0L || header[1] < (offset = stream.getFilePointer())) continue;
            if (offset < header[1]) {
                stream.skip(header[1] - offset);
            }
            CFCSDataSet.writeSegment(stream, (byte[])this.segments.get((int)header[0]));
        }
    }

    private static byte[] readSegment(InputStream stream, int size) throws IOException {
        byte[] segment = new byte[size];
        stream.read(segment);
        return segment;
    }

    private static void writeSegment(OutputStream stream, byte[] segment) throws IOException {
        stream.write(segment);
    }

    private static int readFileChecksum(InputStream stream) throws IOException {
        byte[] buffer = new byte[8];
        stream.read(buffer, 0, buffer.length);
        String string = new String(buffer).trim();
        if (string.equals(DISABLED_CHECKSUM)) {
            return -1;
        }
        int checksum = 0;
        try {
            checksum = new Integer(string);
        }
        catch (NumberFormatException exception) {
            throw new CFCSError(-12, "Malformed checksum");
        }
        return checksum;
    }

    private static void writeFileChecksum(OutputStream stream, String checksum) throws IOException {
        stream.write(checksum.getBytes());
    }

    public final String getVersion() {
        return this.version;
    }

    public static final void setVersion(String version) {
        throw new CFCSError(-33, "CFCSDataSet.setVersion(String)");
    }

    public final double getVersionDoubleValue() {
        Double value = null;
        try {
            value = new Double(this.getVersion().substring(VERSION_PREFIX.length()));
        }
        catch (NumberFormatException exception) {
            throw new CFCSError(-19, (Throwable)exception);
        }
        return value;
    }

    public static final void setVersionDoubleValue(double version) {
        throw new CFCSError(-33, "CFCSDataSet.setVersion(double)");
    }

    public final int getVersionIntegerValue() {
        return new Double(this.getVersionDoubleValue()).intValue();
    }

    public static final void setVersionIntegerValue(int version) {
        throw new CFCSError(-33, "CFCSDataSet.setVersion(int)");
    }

    public final int getCount() {
        return this.segments.size();
    }

    public final CFCSData getData() {
        return this.data;
    }

    public final CFCSKeywords getKeywords() {
        return this.keywords;
    }

    public final CFCSParameters getParameters() {
        return new CFCSParameters(this.keywords);
    }

    public final CFCSGatingParameters getGatingParameters() {
        return new CFCSGatingParameters(this.keywords);
    }

    public final CFCSOtherSegment getOtherSegment(int segIdx) {
        if (segIdx < 4 || segIdx >= this.segments.size()) {
            throw new CFCSError(-15, segIdx);
        }
        CFCSOtherSegment segment = new CFCSOtherSegment();
        segment.setBytes((byte[])this.segments.get(segIdx));
        return segment;
    }

    public final void addOtherSegment(CFCSOtherSegment segment) {
        int count = segment.getCount();
        if (count < 1) {
            throw new CFCSError(-34, count);
        }
        byte[] buffer = new byte[count];
        segment.getBytes(buffer);
        this.segments.add(buffer);
    }

    public final void addKeywords(int segIdx) {
        if (segIdx < 1 || segIdx >= this.segments.size()) {
            throw new CFCSError(-15, segIdx);
        }
        this.keywords.setBytes((byte[])this.segments.get(segIdx), segIdx);
    }
}

