/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import java.io.DataOutputStream;
import java.io.IOException;
import org.flowcyt.cfcs.CFCSAbstractDatatype;
import org.flowcyt.cfcs.CFCSDataChannelError;
import org.flowcyt.cfcs.CFCSDataSizeError;
import org.flowcyt.cfcs.CFCSDatatype;
import org.flowcyt.cfcs.CFCSDatatypeByte;
import org.flowcyt.cfcs.CFCSDatatypeInteger;
import org.flowcyt.cfcs.CFCSDatatypeOversize;
import org.flowcyt.cfcs.CFCSDatatypeShort;
import org.flowcyt.cfcs.CFCSError;
import org.flowcyt.cfcs.CFCSParameter;
import org.flowcyt.cfcs.CFCSParameters;

public class CFCSDatatypeBinary
extends CFCSAbstractDatatype {
    private static final int[] SUBDATATYPES = new int[]{0, 1, 2, 0, 4};

    static CFCSDatatype getDataSubtype(CFCSParameters parameters) {
        int count = parameters.getCount();
        if (count == 0) {
            return new CFCSDatatypeBinary();
        }
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < count; ++i) {
            CFCSParameter parameter = parameters.getParameter(i);
            int bytes = (parameter.getFieldSize() + 7) / 8;
            if (bytes > max) {
                max = bytes;
            }
            if (bytes >= min) continue;
            min = bytes;
        }
        if (min == max && min < SUBDATATYPES.length) {
            switch (SUBDATATYPES[min]) {
                case 1: {
                    return new CFCSDatatypeByte();
                }
                case 2: {
                    return new CFCSDatatypeShort();
                }
                case 4: {
                    return new CFCSDatatypeInteger();
                }
            }
            throw new CFCSError(-10);
        }
        if (min < SUBDATATYPES.length && max < SUBDATATYPES.length) {
            return new CFCSDatatypeBinary();
        }
        return new CFCSDatatypeOversize();
    }

    @Override
    public void readData(int index, byte[][] cinch) {
        int[] row = new int[cinch.length];
        boolean maskable = this.sizing.isRangeMaskable();
        int[] masks = maskable ? this.sizing.getRangeMasks() : null;
        for (int cell = 0; cell < cinch.length; ++cell) {
            int bytes = cinch[cell].length;
            if (bytes > 4) {
                throw new CFCSError(-33);
            }
            int datum = cinch[cell][0] & 0xFF;
            for (int i = 1; i < bytes; ++i) {
                datum = datum << 8 | cinch[cell][i] & 0xFF;
            }
            if (maskable) {
                datum &= masks[cell];
            }
            row[cell] = datum;
        }
        if (index == this.data.size()) {
            this.data.add(row);
        } else {
            this.data.set(index, row);
        }
    }

    @Override
    public void writeData(int index, int count, DataOutputStream stream) {
        int[] sizes;
        int[] row = (int[])this.data.get(index);
        int bytes = 0;
        int variability = this.sizing.getSizeVariability();
        int[] nArray = sizes = variability != 0 ? this.sizing.getByteSizes() : null;
        if (variability == 2) {
            bytes = sizes[index];
        } else if (variability == 0) {
            bytes = this.sizing.getByteSize();
        }
        try {
            block7: for (int i = 0; i < count; ++i) {
                int datum = row[i];
                if (variability == 1) {
                    bytes = sizes[i];
                }
                switch (bytes) {
                    case 1: {
                        stream.write(datum);
                        continue block7;
                    }
                    case 2: {
                        stream.writeShort(datum);
                        continue block7;
                    }
                    case 4: {
                        stream.writeInt(datum);
                        continue block7;
                    }
                    default: {
                        throw new CFCSError(-33);
                    }
                }
            }
        }
        catch (IOException exception) {
            throw new CFCSError(-14, (Throwable)exception);
        }
    }

    @Override
    public void getData(int index, byte[] array) throws CFCSDataSizeError {
        int[] row = (int[])this.data.get(index);
        if (array.length < row.length) {
            throw new CFCSError(-35, array.length);
        }
        for (int i = 0; i < row.length; ++i) {
            int datum = row[i];
            if (datum > 127 || datum < -128) {
                throw new CFCSDataSizeError();
            }
            array[i] = (byte)datum;
        }
    }

    @Override
    public void getData(int index, short[] array) throws CFCSDataSizeError {
        int[] row = (int[])this.data.get(index);
        if (array.length < row.length) {
            throw new CFCSError(-35, array.length);
        }
        for (int i = 0; i < row.length; ++i) {
            int datum = row[i];
            if (datum > Short.MAX_VALUE || datum < Short.MIN_VALUE) {
                throw new CFCSDataSizeError();
            }
            array[i] = (short)datum;
        }
    }

    @Override
    public void getData(int index, int[] array) throws CFCSDataSizeError {
        int[] row = (int[])this.data.get(index);
        if (array.length < row.length) {
            throw new CFCSError(-35, array.length);
        }
        System.arraycopy(row, 0, array, 0, row.length);
    }

    @Override
    public final void getData(int index, float[] array) throws CFCSDataChannelError {
        throw new CFCSDataChannelError();
    }

    @Override
    public final void getData(int index, double[] array) throws CFCSDataChannelError {
        throw new CFCSDataChannelError();
    }

    @Override
    public void setData(int index, byte[] array) {
        int[] row = (int[])this.data.get(index);
        if (array.length < row.length) {
            throw new CFCSError(-34, array.length);
        }
        for (int i = 0; i < row.length; ++i) {
            row[i] = array[i] & 0xFF;
        }
    }

    @Override
    public void setData(int index, short[] array) {
        int[] row = (int[])this.data.get(index);
        if (array.length < row.length) {
            throw new CFCSError(-34, array.length);
        }
        for (int i = 0; i < row.length; ++i) {
            row[i] = array[i] & 0xFFFF;
        }
    }

    @Override
    public void setData(int index, int[] array) {
        int[] row = (int[])this.data.get(index);
        System.arraycopy(array, 0, row, 0, row.length);
        if (array.length < row.length) {
            throw new CFCSError(-34, array.length);
        }
    }

    @Override
    public final void setData(int index, float[] array) throws CFCSDataChannelError {
        throw new CFCSDataChannelError();
    }

    @Override
    public final void setData(int index, double[] array) throws CFCSDataChannelError {
        throw new CFCSDataChannelError();
    }

    @Override
    public void addData(byte[] array) {
        int[] row = new int[array.length];
        for (int i = 0; i < row.length; ++i) {
            row[i] = array[i] & 0xFF;
        }
        this.data.add(row);
    }

    @Override
    public void addData(short[] array) {
        int[] row = new int[array.length];
        for (int i = 0; i < row.length; ++i) {
            row[i] = array[i] & 0xFF;
        }
        this.data.add(row);
    }

    @Override
    public void addData(int[] array) {
        int[] row = new int[array.length];
        System.arraycopy(array, 0, row, 0, row.length);
        this.data.add(row);
    }

    @Override
    public final void addData(float[] array) throws CFCSDataChannelError {
        throw new CFCSDataChannelError();
    }

    @Override
    public final void addData(double[] array) throws CFCSDataChannelError {
        throw new CFCSDataChannelError();
    }
}

