/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import java.io.DataOutputStream;
import java.io.IOException;
import org.flowcyt.cfcs.CFCSAbstractDatatype;
import org.flowcyt.cfcs.CFCSDataScaleError;
import org.flowcyt.cfcs.CFCSError;

public class CFCSDatatypeDouble
extends CFCSAbstractDatatype {
    @Override
    public void readData(int index, byte[][] cinch) {
        double[] row = new double[cinch.length];
        for (int cell = 0; cell < cinch.length; ++cell) {
            long datum = cinch[cell][0] & 0xFF;
            for (int i = 1; i < cinch[cell].length; ++i) {
                datum = datum << 8 | (long)(cinch[cell][i] & 0xFF);
            }
            row[cell] = Double.longBitsToDouble(datum);
        }
        if (index == this.data.size()) {
            this.data.add(row);
        } else {
            this.data.set(index, row);
        }
    }

    @Override
    public void writeData(int index, int count, DataOutputStream stream) {
        double[] row = (double[])this.data.get(index);
        try {
            for (int i = 0; i < count; ++i) {
                stream.writeDouble(row[i]);
            }
        }
        catch (IOException exception) {
            throw new CFCSError(-14, (Throwable)exception);
        }
    }

    @Override
    public void getData(int index, float[] array) {
        double[] row = (double[])this.data.get(index);
        if (array.length < row.length) {
            throw new CFCSError(-35, array.length);
        }
        for (int i = 0; i < row.length; ++i) {
            array[i] = (float)row[i];
        }
    }

    @Override
    public void getData(int index, double[] array) {
        double[] row = (double[])this.data.get(index);
        if (array.length < row.length) {
            throw new CFCSError(-35, array.length);
        }
        System.arraycopy(row, 0, array, 0, row.length);
    }

    @Override
    public void setData(int index, float[] array) {
        double[] row = (double[])this.data.get(index);
        if (array.length < row.length) {
            throw new CFCSError(-34, array.length);
        }
        for (int i = 0; i < row.length; ++i) {
            row[i] = array[i];
        }
    }

    @Override
    public void setData(int index, double[] array) {
        double[] row = (double[])this.data.get(index);
        if (array.length < row.length) {
            throw new CFCSError(-34, array.length);
        }
        System.arraycopy(array, 0, row, 0, array.length);
    }

    @Override
    public void addData(float[] array) {
        double[] row = new double[array.length];
        for (int i = 0; i < row.length; ++i) {
            row[i] = array[i];
        }
        this.data.add(row);
    }

    @Override
    public void addData(double[] array) {
        double[] row = new double[array.length];
        System.arraycopy(array, 0, row, 0, array.length);
        this.data.add(row);
    }

    @Override
    public final void getData(int index, byte[] array) throws CFCSDataScaleError {
        throw new CFCSDataScaleError();
    }

    @Override
    public final void setData(int index, byte[] array) throws CFCSDataScaleError {
        throw new CFCSDataScaleError();
    }

    @Override
    public final void addData(byte[] array) throws CFCSDataScaleError {
        throw new CFCSDataScaleError();
    }

    @Override
    public final void getData(int index, short[] array) throws CFCSDataScaleError {
        throw new CFCSDataScaleError();
    }

    @Override
    public final void setData(int index, short[] array) throws CFCSDataScaleError {
        throw new CFCSDataScaleError();
    }

    @Override
    public final void addData(short[] array) throws CFCSDataScaleError {
        throw new CFCSDataScaleError();
    }

    @Override
    public final void getData(int index, int[] array) throws CFCSDataScaleError {
        throw new CFCSDataScaleError();
    }

    @Override
    public final void setData(int index, int[] array) throws CFCSDataScaleError {
        throw new CFCSDataScaleError();
    }

    @Override
    public final void addData(int[] array) throws CFCSDataScaleError {
        throw new CFCSDataScaleError();
    }
}

