/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import java.io.DataOutputStream;
import java.io.IOException;
import org.flowcyt.cfcs.CFCSDatatypeBinary;
import org.flowcyt.cfcs.CFCSError;

public final class CFCSDatatypeInteger
extends CFCSDatatypeBinary {
    @Override
    public final void readData(int index, byte[][] cinch) {
        int[] row = new int[cinch.length];
        boolean maskable = this.sizing.isRangeMaskable();
        int[] masks = maskable ? this.sizing.getRangeMasks() : null;
        for (int cell = 0; cell < cinch.length; ++cell) {
            int datum = cinch[cell][0] & 0xFF;
            for (int i = 1; i < cinch[cell].length; ++i) {
                datum = datum << 8 | cinch[cell][i] & 0xFF;
            }
            if (maskable) {
                datum &= masks[cell];
            }
            row[cell] = datum;
        }
        if (index == this.data.size()) {
            this.data.add(row);
        } else {
            this.data.set(index, row);
        }
    }

    @Override
    public final void writeData(int index, int count, DataOutputStream stream) {
        int[] row = (int[])this.data.get(index);
        try {
            for (int i = 0; i < count; ++i) {
                stream.writeInt(row[i]);
            }
        }
        catch (IOException exception) {
            throw new CFCSError(-14, (Throwable)exception);
        }
    }
}

