/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import java.io.DataOutputStream;
import java.io.IOException;
import org.flowcyt.cfcs.CFCSDataSizeError;
import org.flowcyt.cfcs.CFCSDatatypeBinary;
import org.flowcyt.cfcs.CFCSError;

public final class CFCSDatatypeShort
extends CFCSDatatypeBinary {
    @Override
    public final void readData(int index, byte[][] cinch) {
        short[] row = new short[cinch.length];
        boolean maskable = this.sizing.isRangeMaskable();
        int[] masks = maskable ? this.sizing.getRangeMasks() : null;
        for (int cell = 0; cell < cinch.length; ++cell) {
            int datum = (cinch[cell][0] & 0xFF) << 8 | cinch[cell][1] & 0xFF;
            if (maskable) {
                datum &= masks[cell];
            }
            row[cell] = (short)datum;
        }
        if (index == this.data.size()) {
            this.data.add(row);
        } else {
            this.data.set(index, row);
        }
    }

    @Override
    public final void writeData(int index, int count, DataOutputStream stream) {
        short[] row = (short[])this.data.get(index);
        try {
            for (int i = 0; i < count; ++i) {
                stream.writeShort(row[i]);
            }
        }
        catch (IOException exception) {
            throw new CFCSError(-14, (Throwable)exception);
        }
    }

    @Override
    public final void getData(int index, byte[] array) throws CFCSDataSizeError {
        short[] row = (short[])this.data.get(index);
        if (array.length < row.length) {
            throw new CFCSError(-35, array.length);
        }
        for (int i = 0; i < row.length; ++i) {
            short datum = row[i];
            if (datum > 127 || datum < -128) {
                throw new CFCSDataSizeError();
            }
            array[i] = (byte)datum;
        }
    }

    @Override
    public final void getData(int index, short[] array) {
        short[] row = (short[])this.data.get(index);
        if (array.length < row.length) {
            throw new CFCSError(-35, array.length);
        }
        System.arraycopy(row, 0, array, 0, row.length);
    }

    @Override
    public final void getData(int index, int[] array) {
        short[] row = (short[])this.data.get(index);
        if (array.length < row.length) {
            throw new CFCSError(-35, array.length);
        }
        for (int i = 0; i < row.length; ++i) {
            array[i] = row[i] & 0xFFFF;
        }
    }

    @Override
    public final void setData(int index, byte[] array) {
        short[] row = (short[])this.data.get(index);
        if (array.length < row.length) {
            throw new CFCSError(-34, array.length);
        }
        for (int i = 0; i < row.length; ++i) {
            row[i] = (short)(array[i] & 0xFF);
        }
    }

    @Override
    public final void setData(int index, short[] array) {
        short[] row = new short[array.length];
        System.arraycopy(array, 0, row, 0, array.length);
    }

    @Override
    public final void setData(int index, int[] array) {
        short[] row = new short[array.length];
        if (array.length < row.length) {
            throw new CFCSError(-34, array.length);
        }
        for (int i = 0; i < row.length; ++i) {
            row[i] = (short)array[i];
        }
    }

    @Override
    public final void addData(byte[] array) {
        short[] row = new short[array.length];
        for (int i = 0; i < row.length; ++i) {
            row[i] = (short)(array[i] & 0xFF);
        }
        this.data.add(row);
    }

    @Override
    public final void addData(short[] array) {
        short[] row = new short[array.length];
        System.arraycopy(array, 0, row, 0, array.length);
        this.data.add(row);
    }

    @Override
    public final void addData(int[] array) {
        short[] row = new short[array.length];
        for (int i = 0; i < row.length; ++i) {
            row[i] = (short)array[i];
        }
        this.data.add(row);
    }
}

