/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import java.util.HashMap;
import java.util.Map;
import org.flowcyt.cfcs.CFCSAbstractParameters;
import org.flowcyt.cfcs.CFCSError;
import org.flowcyt.cfcs.CFCSKeywords;
import org.flowcyt.cfcs.CFCSParameter;

public final class CFCSParameters
extends CFCSAbstractParameters {
    private final Map cache = new HashMap();
    private static final String DATA_PREFIX = "$P";
    private static final String[][] DATA_PROPERTIES = new String[][]{{"S", "FullName", "N"}, {"N", "ShortName", "N"}, {"B", "FieldSizeString", "Y"}, {"R", "Range", "Y"}, {"G", "Gain", "N"}, {"F", "Filter", "N"}, {"L", "ExcitationWavelength", "N"}, {"O", "LaserPower", "N"}, {"P", "EmittedPercent", "N"}, {"V", "Voltage", "N"}, {"T", "DetectorType", "N"}, {"E", "LogDecadesAndOffset", "Y"}};

    CFCSParameters(CFCSKeywords keywords) {
        super(keywords, CFCSParameter.class);
    }

    @Override
    protected final String getPrefix() {
        return DATA_PREFIX;
    }

    @Override
    protected final String[][] getProperties() {
        return DATA_PROPERTIES;
    }

    @Override
    protected final String getCountKeyword() {
        return "$PAR";
    }

    static boolean isParameter(String keyword) {
        if (!(keyword = keyword.toUpperCase()).startsWith(DATA_PREFIX)) {
            return false;
        }
        String suffix = null;
        for (int i = 0; i < DATA_PROPERTIES.length; ++i) {
            String code = DATA_PROPERTIES[i][0];
            if (!keyword.endsWith(code)) continue;
            suffix = code;
            break;
        }
        if (suffix == null) {
            return false;
        }
        String root = keyword.substring(DATA_PREFIX.length(), keyword.length() - suffix.length());
        try {
            Integer.parseInt(root);
        }
        catch (NumberFormatException exception) {
            return false;
        }
        return true;
    }

    public final CFCSParameter getParameter(int index) {
        Integer key = new Integer(index);
        if (this.cache.containsKey(key)) {
            return (CFCSParameter)((CFCSParameter)this.cache.get(key)).copy();
        }
        CFCSParameter parameter = new CFCSParameter();
        super.getParameter(index, parameter);
        this.cache.put(key, parameter.copy());
        return parameter;
    }

    public final void addParameter(CFCSParameter parameter) {
        if (this.keywords.getDatatype() != 1 && (double)parameter.getRange() > Math.pow(2.0, parameter.getFieldSize())) {
            throw new CFCSError(-23, "Range > pow(2, FieldSize)");
        }
        super.addParameter(parameter);
    }

    public final void replaceParameter(int index, CFCSParameter parameter) {
        super.replaceParameter(index, parameter);
        this.cache.remove(new Integer(index));
    }

    @Override
    public final void deleteParameter(int index) {
        super.deleteParameter(index);
        this.cache.remove(new Integer(index));
    }
}

