/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.flowcyt.cfcs.CFCSError;
import org.flowcyt.cfcs.CFCSListModeData;
import org.flowcyt.cfcs.CFCSSystem;

public class FCSapplet
extends JApplet
implements ActionListener {
    CFCSSystem system;
    JTextField URLfield;
    String writePath;
    JLabel title;
    JLabel URL;
    JLabel errors;
    JLabel keywordLabel;
    JLabel line;
    JLabel line2;
    JLabel countLabel;
    JLabel Count;
    JLabel versionLabel;
    JLabel Version;
    JLabel paramLabel;
    JPanel pane;
    JButton submit;
    JButton brows;
    JButton write;
    JFileChooser fc;
    JTextArea ta;
    JTextArea params;
    File file;
    JScrollPane jsp;
    JScrollPane psp;
    Border loweredetched = BorderFactory.createEtchedBorder(1);
    String path;

    @Override
    public void init() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    FCSapplet.this.createGUI();
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void createGUI() {
        this.setSize(550, 500);
        this.initclassesponents();
        this.setBackground(new Color(238, 238, 238));
        this.pane.setLayout(new GridBagLayout());
        this.pane.setBorder(this.loweredetched);
        this.setGridBag();
        this.getContentPane().add(this.pane);
        this.pane.setVisible(true);
        this.setVisible(true);
        this.validate();
    }

    public void initclassesponents() {
        this.ta = new JTextArea();
        this.ta.setBorder(this.loweredetched);
        this.jsp = new JScrollPane();
        this.jsp.setViewportView(this.ta);
        this.errors = new JLabel();
        this.write = new JButton("write file");
        this.write.addActionListener(this);
        this.params = new JTextArea();
        this.params.setBorder(this.loweredetched);
        this.psp = new JScrollPane();
        this.paramLabel = new JLabel("parameters: ");
        this.fc = new JFileChooser();
        this.pane = new JPanel();
        this.countLabel = new JLabel("count: ");
        this.Count = new JLabel();
        this.versionLabel = new JLabel("version: ");
        this.Version = new JLabel();
        this.submit = new JButton("Submit");
        this.submit.addActionListener(this);
        this.brows = new JButton("Brows");
        this.brows.addActionListener(this);
        this.URLfield = new JTextField();
        this.URLfield.setBorder(this.loweredetched);
        this.line = new JLabel();
        this.line.setBackground(Color.gray);
        this.line2 = new JLabel();
        this.line2.setBackground(Color.gray);
        this.title = new JLabel("FCS Reader");
        this.errors.setFont(new Font("TimesRoman", 2, 12));
        this.errors.setForeground(Color.red);
        this.countLabel.setFont(new Font("TimesRoman", 1, 12));
        this.Count.setFont(new Font("TimesRoman", 1, 12));
        this.versionLabel.setFont(new Font("TimesRoman", 1, 12));
        this.Version.setFont(new Font("TimesRoman", 1, 12));
        this.title.setFont(new Font("TimesRoman", 1, 20));
        this.params.setFont(new Font("TimesRoman", 1, 12));
        this.ta.setFont(new Font("TimesRoman", 1, 12));
        this.paramLabel.setFont(new Font("TimesRoman", 1, 12));
        this.URL = new JLabel("URL/File Path: ");
        this.URL.setFont(new Font("TimesRoman", 1, 12));
        this.keywordLabel = new JLabel("keywords: ");
        this.keywordLabel.setFont(new Font("TimesRoman", 1, 12));
        this.psp.setViewportView(this.params);
        this.title.setBackground(Color.LIGHT_GRAY);
    }

    public void setGridBag() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 10;
        c.weighty = 25.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 5;
        this.pane.add((Component)this.title, c);
        this.line.setMinimumSize(new Dimension(500, 2));
        this.line2.setMinimumSize(new Dimension(500, 2));
        this.line.setPreferredSize(new Dimension(500, 2));
        this.line2.setPreferredSize(new Dimension(500, 2));
        this.brows.setMinimumSize(new Dimension(100, 20));
        this.submit.setMinimumSize(new Dimension(100, 20));
        this.write.setMinimumSize(new Dimension(100, 20));
        this.brows.setPreferredSize(new Dimension(100, 20));
        this.submit.setPreferredSize(new Dimension(100, 20));
        this.write.setPreferredSize(new Dimension(100, 20));
        this.jsp.setPreferredSize(new Dimension(300, 100));
        this.jsp.setMinimumSize(new Dimension(300, 100));
        this.psp.setPreferredSize(new Dimension(300, 100));
        this.psp.setMinimumSize(new Dimension(300, 100));
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 1;
        this.pane.add((Component)this.line2, c);
        c.weighty = 15.0;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 2;
        this.pane.add((Component)this.URL, c);
        c.gridwidth = 4;
        c.gridx = 1;
        c.gridy = 2;
        this.pane.add((Component)this.URLfield, c);
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 3;
        this.pane.add((Component)this.brows, c);
        c.gridx = 2;
        c.gridy = 3;
        this.pane.add((Component)this.submit, c);
        c.gridx = 4;
        c.gridy = 3;
        this.pane.add((Component)this.write, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 5;
        this.pane.add((Component)this.line, c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 5;
        this.pane.add((Component)this.countLabel, c);
        c.gridwidth = 2;
        c.gridx = 1;
        c.gridy = 5;
        this.pane.add((Component)this.Count, c);
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 6;
        this.pane.add((Component)this.versionLabel, c);
        c.gridwidth = 2;
        c.gridx = 1;
        c.gridy = 6;
        this.pane.add((Component)this.Version, c);
        c.gridx = 0;
        c.gridy = 7;
        this.pane.add((Component)this.keywordLabel, c);
        c.gridx = 1;
        c.gridy = 7;
        c.gridwidth = 2;
        this.pane.add((Component)this.jsp, c);
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 8;
        this.pane.add((Component)this.paramLabel, c);
        c.gridwidth = 2;
        c.gridx = 1;
        c.gridy = 8;
        this.pane.add((Component)this.psp, c);
        c.gridwidth = 5;
        c.gridx = 0;
        c.gridy = 9;
        this.pane.add((Component)this.errors, c);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.brows) {
            this.fc.showOpenDialog(this);
            this.file = this.fc.getSelectedFile();
            if (this.file != null) {
                this.URLfield.setText(this.file.getAbsolutePath());
            }
        } else if (e.getSource() == this.submit) {
            this.getData();
            this.ta.select(0, 0);
            this.params.select(0, 0);
        } else if (e.getSource() == this.write) {
            this.fc.showSaveDialog(this);
            this.file = this.fc.getSelectedFile();
            if (this.file != null) {
                this.writePath = this.file.getAbsolutePath();
            }
            this.writeData();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void getData() {
        block40: {
            this.system = new CFCSSystem();
            if (!this.URLfield.getText().startsWith("http://") && this.URLfield.getText().startsWith("www")) {
                this.URLfield.setText("http://" + this.URLfield.getText());
                try {
                    this.system.open(this.URLfield.getText());
                }
                catch (CFCSError error) {
                    if (this.failIfError(error) == 0) ** GOTO lbl26
                    this.errors.setText("" + error);
                    return;
                }
            } else if (this.URLfield.getText().startsWith("http://")) {
                try {
                    this.system.open(this.URLfield.getText());
                }
                catch (CFCSError error) {
                    if (this.failIfError(error) == 0) ** GOTO lbl26
                    this.errors.setText("" + error);
                    return;
                }
            } else {
                try {
                    this.system.open(this.URLfield.getText());
                }
                catch (CFCSError error) {
                    if (this.failIfError(error) == 0) break block40;
                    this.errors.setText("" + error);
                    return;
                }
            }
        }
        this.errors.setText("");
        nDataSets = this.system.getCount();
        for (iSet = 0; iSet < nDataSets; ++iSet) {
            set = null;
            fcsKeywords = null;
            listModeData = null;
            try {
                set = this.system.getDataSet(iSet);
                listModeData = (CFCSListModeData)set.getData();
                fcsKeywords = set.getKeywords();
                this.Count.setText(Integer.toString(listModeData.getCount()));
                this.Version.setText(set.getVersion());
            }
            catch (CFCSError error) {
                if (this.failIfError(error) != 0) break;
            }
            count = fcsKeywords.getCount();
            for (idx = 0; idx < count; ++idx) {
                keyword = fcsKeywords.getKeyword(idx);
                keyName = keyword.getKeywordName();
                keyValue = keyword.getKeywordValue();
                this.ta.append(keyName + ": " + keyValue + "\n");
            }
            if (iSet < nDataSets - 1) {
                System.out.println();
            }
            fcsParameters = null;
            try {
                set = this.system.getDataSet(iSet);
                fcsParameters = set.getParameters();
            }
            catch (CFCSError error) {
                if (this.failIfError(error) != 0) break;
            }
            count = fcsParameters.getCount();
            paramarray = new int[count];
            paramValues = new int[count];
            nEvents = ((CFCSListModeData)set.getData()).getCount();
            for (i = 0; i < nEvents; ++i) {
                listModeData.getEvent(i, paramarray);
                for (j = 0; j < count; ++j) {
                    paramValues[j] = paramValues[j] + paramarray[j];
                }
            }
            for (idx = 0; idx < count; ++idx) {
                parameter = fcsParameters.getParameter(idx);
                fullName = null;
                shortName = null;
                try {
                    fullName = parameter.getFullName();
                }
                catch (CFCSError error) {
                    fullName = "";
                }
                try {
                    shortName = "(" + parameter.getShortName() + ")";
                }
                catch (CFCSError error) {
                    shortName = "";
                }
                this.params.append(fullName + " " + shortName + "\n");
                meanValue = (double)paramValues[idx] / (double)nEvents;
                this.params.append("           Mean: " + meanValue + "\n");
                this.params.append("           tField Size: " + parameter.getFieldSize() + "\n");
                this.params.append("           tRange: " + parameter.getRange() + "\n");
                try {
                    this.params.append("           tLog Decades: " + parameter.getLogDecades() + "\n");
                    this.params.append("           tOffset: " + parameter.getOffset() + "\n");
                }
                catch (CFCSError error) {
                    if (error.errorNumber < 0) break;
                }
                try {
                    this.params.append("           tFilter: " + parameter.getFilter() + "\n");
                }
                catch (CFCSError error) {
                    if (error.errorNumber < 0) break;
                }
                try {
                    this.params.append("           tDetector Type: " + parameter.getDetectorType() + "\n");
                }
                catch (CFCSError error) {
                    if (error.errorNumber < 0) break;
                }
                try {
                    this.params.append("           tGain: " + parameter.getGain() + "\n");
                }
                catch (CFCSError error) {
                    // empty catch block
                }
                try {
                    this.params.append("           tLaser Power: " + parameter.getLaserPower() + "\n");
                }
                catch (CFCSError error) {
                    if (error.errorNumber < 0) break;
                }
                try {
                    this.params.append("           tEmitted Percent: " + parameter.getEmittedPercent() + "\n");
                }
                catch (CFCSError error) {
                    if (error.errorNumber < 0) break;
                }
                try {
                    this.params.append("           tVoltage: " + parameter.getVoltage() + "\n");
                }
                catch (CFCSError error) {
                    if (error.errorNumber < 0) break;
                }
                try {
                    this.params.append("           tExcitation Wavelength: " + parameter.getExcitationWavelength() + "\n");
                }
                catch (CFCSError error) {
                    if (error.errorNumber < 0) break;
                }
                if (idx >= count) continue;
                System.out.println();
            }
            if (iSet >= nDataSets - 1) continue;
            System.out.println();
        }
    }

    public void writeData() {
        block3: {
            try {
                if (!this.URLfield.getText().equals(null) && !this.URLfield.getText().equals("")) {
                    this.system.createLocal(this.writePath);
                    this.system.closeLocal();
                }
            }
            catch (CFCSError error) {
                if (this.failIfError(error) == 0) break block3;
                this.errors.setText("" + error);
                return;
            }
        }
    }

    public int failIfError(CFCSError error) {
        int errorType = 0;
        while (error != null) {
            this.errors.setText("" + error);
            if (error.errorNumber < 0) {
                errorType = -1;
            } else if (error.errorNumber > 0 && errorType == 0) {
                errorType = 1;
            }
            error = error.nextError;
        }
        return errorType;
    }
}

