/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import org.flowcyt.cfcs.CFCSData;
import org.flowcyt.cfcs.CFCSDataSet;
import org.flowcyt.cfcs.CFCSError;
import org.flowcyt.cfcs.CFCSListModeData;
import org.flowcyt.cfcs.CFCSParameter;
import org.flowcyt.cfcs.CFCSParameters;
import org.flowcyt.cfcs.CFCSSystem;

public class PackToRange {
    private static final int INPUT = 0;
    private static final int OUTPUT = 1;

    static int failIfError(CFCSError error) {
        int errorType = 0;
        while (error != null) {
            System.err.println(error);
            if (error.errorNumber < 0) {
                errorType = -1;
            } else if (error.errorNumber > 0 && errorType == 0) {
                errorType = 1;
            }
            error = error.nextError;
        }
        return errorType;
    }

    public static int rangeBits(int range) {
        int bits = 1;
        int mask = 1;
        --range;
        while ((range | mask) != mask) {
            mask = (mask << 1) + 1;
            ++bits;
        }
        return bits;
    }

    public static void main(String[] argv) {
        CFCSSystem writeSystem;
        CFCSSystem readSystem;
        block11: {
            block10: {
                readSystem = new CFCSSystem();
                try {
                    readSystem.open(argv[0]);
                }
                catch (CFCSError error) {
                    if (PackToRange.failIfError(error) == 0) break block10;
                    System.exit(1);
                }
            }
            writeSystem = new CFCSSystem();
            try {
                writeSystem.create(argv[1]);
            }
            catch (CFCSError error) {
                if (PackToRange.failIfError(error) == 0) break block11;
                System.exit(1);
            }
        }
        int nDataSets = readSystem.getCount();
        block7: for (int set = 0; set < nDataSets; ++set) {
            CFCSDataSet readSet = readSystem.getDataSet(set);
            CFCSParameters readParam = readSet.getParameters();
            CFCSData readData = readSet.getData();
            int type = readData.getType();
            CFCSDataSet writeSet = writeSystem.createDataSet(readSet);
            CFCSParameters writeParam = writeSet.getParameters();
            CFCSData writeData = writeSet.getData();
            int count = writeParam.getCount();
            for (int i = 0; i < count; ++i) {
                CFCSParameter parameter = writeParam.getParameter(i);
                parameter.setFieldSize(PackToRange.rangeBits(parameter.getRange()));
                writeParam.replaceParameter(i, parameter);
            }
            switch (type) {
                case 1: {
                    int[] event = new int[readParam.getCount()];
                    int nEvents = ((CFCSListModeData)readData).getCount();
                    for (int i = 0; i < nEvents; ++i) {
                        ((CFCSListModeData)readData).getEvent(i, event);
                        ((CFCSListModeData)writeData).addEvent(event);
                    }
                    continue block7;
                }
                default: {
                    System.exit(1);
                }
            }
        }
        readSystem.close();
        writeSystem.close();
    }
}

