/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import org.flowcyt.cfcs.CFCSDataSet;
import org.flowcyt.cfcs.CFCSError;
import org.flowcyt.cfcs.CFCSKeyword;
import org.flowcyt.cfcs.CFCSKeywords;
import org.flowcyt.cfcs.CFCSSystem;

public class PrintKeywords {
    static int failIfError(CFCSError error) {
        int errorType = 0;
        while (error != null) {
            System.err.println(error);
            if (error.errorNumber < 0) {
                errorType = -1;
            } else if (error.errorNumber > 0 && errorType == 0) {
                errorType = 1;
            }
            error = error.nextError;
        }
        return errorType;
    }

    public static void main(String[] argv) {
        CFCSSystem system;
        block6: {
            system = new CFCSSystem();
            try {
                system.open("http://www.flowjo.classes/Sample1.fcs");
            }
            catch (CFCSError error) {
                if (PrintKeywords.failIfError(error) == 0) break block6;
                System.exit(1);
            }
        }
        int nDataSets = system.getCount();
        for (int iSet = 0; iSet < nDataSets; ++iSet) {
            CFCSDataSet set = null;
            CFCSKeywords fcsKeywords = null;
            try {
                set = system.getDataSet(iSet);
                fcsKeywords = set.getKeywords();
            }
            catch (CFCSError error) {
                if (PrintKeywords.failIfError(error) != 0) break;
            }
            String version = set.getVersion();
            System.out.println("Keywords for data set #" + (iSet + 1) + " (" + version + ")\n");
            int count = fcsKeywords.getCount();
            for (int idx = 0; idx < count; ++idx) {
                CFCSKeyword keyword = fcsKeywords.getKeyword(idx);
                String keyName = keyword.getKeywordName();
                String keyValue = keyword.getKeywordValue();
                System.out.println(keyName + ": " + keyValue);
            }
            if (iSet >= nDataSets - 1) continue;
            System.out.println();
        }
        system.close();
    }
}

