/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import org.flowcyt.cfcs.CFCSDataSet;
import org.flowcyt.cfcs.CFCSError;
import org.flowcyt.cfcs.CFCSKeyword;
import org.flowcyt.cfcs.CFCSKeywords;
import org.flowcyt.cfcs.CFCSSystem;

public class SetKeyword {
    private static final int INPUT = 0;
    private static final int OUTPUT = 1;
    private static final int NAME = 2;
    private static final int VALUE = 3;

    static int failIfError(CFCSError error) {
        int errorType = 0;
        while (error != null) {
            System.err.println(error);
            if (error.errorNumber < 0) {
                errorType = -1;
            } else if (error.errorNumber > 0 && errorType == 0) {
                errorType = 1;
            }
            error = error.nextError;
        }
        return errorType;
    }

    public static void main(String[] argv) {
        CFCSSystem system;
        block3: {
            system = new CFCSSystem();
            try {
                system.modify(argv[0], argv[1]);
            }
            catch (CFCSError error) {
                if (SetKeyword.failIfError(error) == 0) break block3;
                System.exit(1);
            }
        }
        CFCSKeyword keyword = new CFCSKeyword();
        keyword.setKeywordName(argv[2]);
        keyword.setKeywordValue(argv[3]);
        keyword.setKeywordSource(1);
        int nDataSets = system.getCount();
        for (int i = 0; i < nDataSets; ++i) {
            CFCSDataSet dataset = system.getDataSet(i);
            CFCSKeywords keywords = dataset.getKeywords();
            keywords.addKeyword(keyword);
        }
        system.close();
    }
}

