/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.cfcs;

import org.flowcyt.cfcs.CFCSData;
import org.flowcyt.cfcs.CFCSDataSet;
import org.flowcyt.cfcs.CFCSError;
import org.flowcyt.cfcs.CFCSListModeData;
import org.flowcyt.cfcs.CFCSParameter;
import org.flowcyt.cfcs.CFCSParameters;
import org.flowcyt.cfcs.CFCSSystem;

public class UnpackData {
    private static final int INPUT = 0;
    private static final int OUTPUT = 1;

    static int failIfError(CFCSError error) {
        int errorType = 0;
        while (error != null) {
            System.err.println(error);
            if (error.errorNumber < 0) {
                errorType = -1;
            } else if (error.errorNumber > 0 && errorType == 0) {
                errorType = 1;
            }
            error = error.nextError;
        }
        return errorType;
    }

    public static int rangeToBits(int range) {
        int bits = 1;
        int mask = 1;
        --range;
        while ((range | mask) != mask) {
            mask = (mask << 1) + 1;
            ++bits;
        }
        return 8 * ((bits + 7) / 8);
    }

    public static void main(String[] argv) {
        CFCSSystem writeSystem;
        CFCSSystem readSystem;
        block8: {
            block7: {
                readSystem = new CFCSSystem();
                try {
                    readSystem.open(argv[0]);
                }
                catch (CFCSError error) {
                    if (UnpackData.failIfError(error) == 0) break block7;
                    System.exit(1);
                }
            }
            writeSystem = new CFCSSystem();
            try {
                writeSystem.create(argv[1]);
            }
            catch (CFCSError error) {
                if (UnpackData.failIfError(error) == 0) break block8;
                System.exit(1);
            }
        }
        int nDataSets = readSystem.getCount();
        for (int set = 0; set < nDataSets; ++set) {
            CFCSDataSet readSet = readSystem.getDataSet(set);
            CFCSData readData = readSet.getData();
            if (readData.getType() != 1) continue;
            CFCSDataSet writeSet = writeSystem.createDataSet(readSet);
            CFCSParameters readParam = readSet.getParameters();
            CFCSParameters writeParam = writeSet.getParameters();
            int count = writeParam.getCount();
            for (int i = 0; i < count; ++i) {
                CFCSParameter parameter = writeParam.getParameter(i);
                parameter.setFieldSize(UnpackData.rangeToBits(parameter.getRange()));
                writeParam.replaceParameter(i, parameter);
            }
            CFCSData writeData = writeSet.getData();
            CFCSListModeData readList = (CFCSListModeData)readData;
            CFCSListModeData writeList = (CFCSListModeData)writeData;
            int[] event = new int[readParam.getCount()];
            int nEvents = readList.getCount();
            for (int i = 0; i < nEvents; ++i) {
                readList.getEvent(i, event);
                writeList.addEvent(event);
            }
        }
        readSystem.close();
        writeSystem.close();
    }
}

