/*
 * Decompiled with CFR 0.152.
 */
package org.flowcyt.facejava.fcsdata.impl;

import java.util.Collections;
import java.util.List;
import org.flowcyt.facejava.fcsdata.AbstractOrderedPopulation;
import org.flowcyt.facejava.fcsdata.DataRetriever;
import org.flowcyt.facejava.fcsdata.Event;
import org.flowcyt.facejava.fcsdata.Parameter;
import org.flowcyt.facejava.fcsdata.exception.CircularParameterDependencyException;
import org.flowcyt.facejava.fcsdata.exception.DuplicateParameterReferenceException;
import org.flowcyt.facejava.fcsdata.exception.InvalidParameterNumberException;
import org.flowcyt.facejava.fcsdata.impl.FcsParameter;
import org.flowcyt.facejava.fcsdata.impl.FcsParameterList;

public class FcsDataSet
extends AbstractOrderedPopulation {
    private String fcsVersion;
    private int datasetNumber;
    private FcsParameterList parameters;
    private DataRetriever retriever;

    public FcsDataSet(String fcsVersion, int datasetNumber, List<FcsParameter> parameters, List<Event> events) throws InvalidParameterNumberException, DuplicateParameterReferenceException {
        super(null, events);
        this.fcsVersion = fcsVersion;
        this.datasetNumber = datasetNumber;
        this.parameters = new FcsParameterList(parameters);
        try {
            this.retriever = new DataRetriever(Collections.singletonList(this.parameters));
        }
        catch (CircularParameterDependencyException e) {
            throw new AssertionError((Object)"FcsParameters should not be depending on any other parameters.");
        }
    }

    public String getFCSVersion() {
        return this.fcsVersion;
    }

    public int getDataSetNumber() {
        return this.datasetNumber;
    }

    @Override
    public DataRetriever getRetriever() {
        return this.retriever;
    }

    public FcsParameterList getParameters() {
        return this.parameters;
    }

    public int getParameterCount() {
        return this.parameters.size();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Data Set Number: ");
        builder.append(this.datasetNumber);
        builder.append("\nVersion: ");
        builder.append(this.getFCSVersion());
        builder.append("; # Events: ");
        builder.append(this.size());
        builder.append("; # Parameters: ");
        builder.append(this.parameters.size());
        builder.append("\n");
        for (Parameter param : this.getParameters()) {
            builder.append(param.toString());
            builder.append("\n");
        }
        return builder.toString();
    }
}

