/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.util.FloatMatrix;

public class AlgorithmData
implements Serializable {
    private static final long serialVersionUID = 5889525631233899519L;
    protected HashMap matrixes = new HashMap();
    protected HashMap intMatrices = new HashMap();
    protected HashMap intArrays = new HashMap();
    protected HashMap stringArrays = new HashMap();
    protected HashMap objectMatrices = new HashMap();
    protected AlgorithmParameters parameters = new AlgorithmParameters();
    protected HashMap clusters = new HashMap();
    protected HashMap resultMap = new HashMap();
    protected HashMap gseaParam = new HashMap();

    public void copy(AlgorithmData data) {
        this.matrixes = data.matrixes;
        this.intMatrices = data.intMatrices;
        this.intArrays = data.intArrays;
        this.stringArrays = data.stringArrays;
        this.objectMatrices = data.objectMatrices;
        this.parameters = data.parameters;
        this.clusters = data.clusters;
        this.resultMap = data.resultMap;
        this.gseaParam = data.gseaParam;
    }

    public void addMatrix(String name, FloatMatrix matrix) {
        this.matrixes.put(name, matrix);
    }

    public void addIntMatrix(String name, int[][] matrix) {
        this.intMatrices.put(name, matrix);
    }

    public void addCluster(String name, Cluster cluster) {
        this.clusters.put(name, cluster);
    }

    public Cluster getCluster(String name) {
        return (Cluster)this.clusters.get(name);
    }

    public void addParam(String name, String value) {
        this.parameters.setProperty(name, value);
    }

    public FloatMatrix getMatrix(String name) {
        return (FloatMatrix)this.matrixes.get(name);
    }

    public int[][] getIntMatrix(String name) {
        return (int[][])this.intMatrices.get(name);
    }

    public boolean containsMatrix(String name) {
        return this.matrixes.containsKey(name);
    }

    public void addIntArray(String name, int[] intArray) {
        this.intArrays.put(name, intArray);
    }

    public void addResultAlgorithmData(Integer key, AlgorithmData value) {
        this.resultMap.put(key, value);
    }

    public AlgorithmData getResultAlgorithmData(Object key) {
        return (AlgorithmData)this.resultMap.get(key);
    }

    public void addGeneMatrix(String key, FloatMatrix matrix) {
        this.gseaParam.put(key, matrix);
    }

    public void addVector(String key, Vector unassigned) {
        this.gseaParam.put(key, unassigned);
    }

    public FloatMatrix getGeneMatrix(String key) {
        return (FloatMatrix)this.gseaParam.get(key);
    }

    public Vector getVector(String key) {
        return (Vector)this.gseaParam.get(key);
    }

    public void addMappings(String Name2, LinkedHashMap value) {
        this.resultMap.put(Name2, value);
    }

    public LinkedHashMap getMappings(String Name2) {
        return (LinkedHashMap)this.resultMap.get(Name2);
    }

    public int[] getIntArray(String name) {
        return (int[])this.intArrays.get(name);
    }

    public void addStringArray(String name, String[] stringArray) {
        this.stringArrays.put(name, stringArray);
    }

    public String[] getStringArray(String name) {
        return (String[])this.stringArrays.get(name);
    }

    public void addObjectMatrix(String name, Object[][] objM) {
        this.objectMatrices.put(name, objM);
    }

    public Object[][] getObjectMatrix(String name) {
        return (Object[][])this.objectMatrices.get(name);
    }

    public int size() {
        return this.matrixes.size();
    }

    public String[] getMatrixNames() {
        return this.getKeys(this.matrixes);
    }

    public String[] getClusterNames() {
        return this.getKeys(this.clusters);
    }

    private String[] getKeys(HashMap map) {
        Iterator iter = map.keySet().iterator();
        String[] result = new String[map.size()];
        int counter = 0;
        while (iter.hasNext()) {
            result[counter++] = (String)iter.next();
        }
        return result;
    }

    public AlgorithmParameters getParams() {
        return this.parameters;
    }

    public Map getProperties() {
        return this.parameters.getMap();
    }

    public Map getMatrixes() {
        return this.matrixes;
    }

    public Map getIntArrays() {
        return this.intArrays;
    }

    public Map getStringArrays() {
        return this.stringArrays;
    }

    public Map getObjectMatrices() {
        return this.objectMatrices;
    }

    public Map getClusters() {
        return this.clusters;
    }
}

