/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibAffineBicubicOpImage;
import com.sun.media.jai.mlib.MlibAffineBilinearOpImage;
import com.sun.media.jai.mlib.MlibAffineNearestOpImage;
import com.sun.media.jai.mlib.MlibAffineTableOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.InterpolationTable;
import javax.media.jai.TileCache;

public class MlibShearRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        TileCache tileCache = RIFUtil.getTileCacheHint(renderingHints);
        if (!MediaLibAccessor.isMediaLibCompatible(parameterBlock, imageLayout) || !MediaLibAccessor.hasSameNumBands(parameterBlock, imageLayout)) {
            return null;
        }
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        float f = parameterBlock.getFloatParameter(0);
        int n = parameterBlock.getIntParameter(1);
        float f2 = parameterBlock.getFloatParameter(2);
        float f3 = parameterBlock.getFloatParameter(3);
        Interpolation interpolation = (Interpolation)parameterBlock.getObjectParameter(4);
        AffineTransform affineTransform = new AffineTransform();
        if (n == 0) {
            affineTransform.setTransform(1.0, 0.0, f, 1.0, f2, 0.0);
        } else {
            affineTransform.setTransform(1.0, f, 0.0, 1.0, 0.0, f3);
        }
        if (interpolation instanceof InterpolationNearest) {
            return new MlibAffineNearestOpImage(renderedImage, borderExtender, tileCache, imageLayout, affineTransform, interpolation);
        }
        if (interpolation instanceof InterpolationBilinear) {
            return new MlibAffineBilinearOpImage(renderedImage, borderExtender, tileCache, imageLayout, affineTransform, interpolation);
        }
        if (interpolation instanceof InterpolationBicubic || interpolation instanceof InterpolationBicubic2) {
            return new MlibAffineBicubicOpImage(renderedImage, borderExtender, tileCache, imageLayout, affineTransform, interpolation);
        }
        if (interpolation instanceof InterpolationTable) {
            return new MlibAffineTableOpImage(renderedImage, borderExtender, tileCache, imageLayout, affineTransform, interpolation);
        }
        return null;
    }
}

