/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.TileCache;

final class DivideIntoConstOpImage
extends PointOpImage {
    protected double[] constants;

    public DivideIntoConstOpImage(RenderedImage renderedImage, TileCache tileCache, ImageLayout imageLayout, double[] dArray) {
        super(renderedImage, tileCache, imageLayout, true);
        int n = this.getSampleModel().getNumBands();
        if (dArray.length < n) {
            this.constants = new double[n];
            int n2 = 0;
            while (n2 < n) {
                this.constants[n2] = dArray[0];
                ++n2;
            }
        } else {
            this.constants = (double[])dArray.clone();
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[0], rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor2, rasterAccessor);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessor2, rasterAccessor);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessor2, rasterAccessor);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor2, rasterAccessor);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessor2, rasterAccessor);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessor2, rasterAccessor);
                break;
            }
        }
        if (rasterAccessor.needsClamping()) {
            rasterAccessor.clampDataArrays();
        }
        rasterAccessor.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int n8 = 0;
        while (n8 < n3) {
            double d = this.constants[n8];
            byte[] byArray3 = byArray[n8];
            byte[] byArray4 = byArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                n9 += n4;
                n10 += n6;
                int n14 = 0;
                while (n14 < n) {
                    double d2 = byArray4[n13] & 0xFF;
                    byArray3[n12] = ImageUtil.clampRoundByte(d / d2);
                    n12 += n5;
                    n13 += n7;
                    ++n14;
                }
                ++n11;
            }
            ++n8;
        }
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int n8 = 0;
        while (n8 < n3) {
            double d = this.constants[n8];
            double[] dArray3 = dArray[n8];
            double[] dArray4 = dArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                n9 += n4;
                n10 += n6;
                int n14 = 0;
                while (n14 < n) {
                    dArray3[n12] = d / dArray4[n13];
                    n12 += n5;
                    n13 += n7;
                    ++n14;
                }
                ++n11;
            }
            ++n8;
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int n8 = 0;
        while (n8 < n3) {
            double d = this.constants[n8];
            float[] fArray3 = fArray[n8];
            float[] fArray4 = fArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                n9 += n4;
                n10 += n6;
                int n14 = 0;
                while (n14 < n) {
                    fArray3[n12] = ImageUtil.clampFloat(d / (double)fArray4[n13]);
                    n12 += n5;
                    n13 += n7;
                    ++n14;
                }
                ++n11;
            }
            ++n8;
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int[][] nArray2 = rasterAccessor2.getIntDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int[][] nArray4 = rasterAccessor.getIntDataArrays();
        int n8 = 0;
        while (n8 < n3) {
            double d = this.constants[n8];
            int[] nArray5 = nArray2[n8];
            int[] nArray6 = nArray4[n8];
            int n9 = nArray[n8];
            int n10 = nArray3[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                n9 += n4;
                n10 += n6;
                int n14 = 0;
                while (n14 < n) {
                    nArray5[n12] = ImageUtil.clampRoundInt(d / (double)nArray6[n13]);
                    n12 += n5;
                    n13 += n7;
                    ++n14;
                }
                ++n11;
            }
            ++n8;
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int n8 = 0;
        while (n8 < n3) {
            double d = this.constants[n8];
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                n9 += n4;
                n10 += n6;
                int n14 = 0;
                while (n14 < n) {
                    sArray3[n12] = ImageUtil.clampRoundShort(d / (double)sArray4[n13]);
                    n12 += n5;
                    n13 += n7;
                    ++n14;
                }
                ++n11;
            }
            ++n8;
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int n8 = 0;
        while (n8 < n3) {
            double d = this.constants[n8];
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                n9 += n4;
                n10 += n6;
                int n14 = 0;
                while (n14 < n) {
                    double d2 = sArray4[n13] & 0xFFFF;
                    sArray3[n12] = ImageUtil.clampRoundUShort(d / d2);
                    n12 += n5;
                    n13 += n7;
                    ++n14;
                }
                ++n11;
            }
            ++n8;
        }
    }
}

