/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.rmi.RasterProxy;
import com.sun.media.jai.rmi.SerializableRenderedImage;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ContextualRenderedImageFactory;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.PropertySource;
import javax.media.jai.PropertySourceImpl;
import javax.media.jai.RenderedOp;

public class RenderableOp
implements PropertySource,
RenderableImage,
Serializable {
    private transient OperationRegistry theRegistry;
    private String operationName;
    private transient ParameterBlock paramBlock;
    protected transient PropertySource thePropertySource;
    protected transient Rectangle2D boundingBox = null;
    protected transient ContextualRenderedImageFactory crif = null;
    private transient Hashtable localProperties = null;
    private Vector volatilePropertyInfo = null;

    public RenderableOp(String string, ParameterBlock parameterBlock) {
        this(null, string, parameterBlock);
    }

    public RenderableOp(OperationRegistry operationRegistry, String string, ParameterBlock parameterBlock) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.theRegistry = operationRegistry;
        this.operationName = string;
        this.paramBlock = parameterBlock == null ? new ParameterBlock() : parameterBlock;
    }

    public void addPropertyGenerator(PropertyGenerator propertyGenerator) {
        this.createPropertySource();
        PropertySourceImpl propertySourceImpl = (PropertySourceImpl)this.thePropertySource;
        propertySourceImpl.addPropertyGenerator(propertyGenerator);
        this.createVolatilePropertyVector();
        if (!this.volatilePropertyInfo.contains(propertyGenerator)) {
            this.volatilePropertyInfo.add(propertyGenerator);
        }
    }

    public RenderedImage createDefaultRendering() {
        return this.createRendering(new RenderContext(new AffineTransform()));
    }

    private synchronized void createLocalProperties() {
        if (this.localProperties == null) {
            this.localProperties = new Hashtable();
        }
    }

    private synchronized void createPropertySource() {
        if (this.thePropertySource == null) {
            this.thePropertySource = this.getRegistry().getPropertySource(this);
            if (this.volatilePropertyInfo != null) {
                PropertySourceImpl propertySourceImpl = (PropertySourceImpl)this.thePropertySource;
                int n = this.volatilePropertyInfo.size();
                int n2 = 0;
                while (n2 < n) {
                    Object e = this.volatilePropertyInfo.get(n2);
                    if (e instanceof String) {
                        propertySourceImpl.suppressProperty((String)e);
                    } else if (e instanceof PropertyGenerator) {
                        propertySourceImpl.addPropertyGenerator((PropertyGenerator)e);
                    }
                    ++n2;
                }
            }
        }
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        this.findCRIF();
        return this.getRenderedImage(renderContext);
    }

    public RenderedImage createScaledRendering(int n, int n2, RenderingHints renderingHints) {
        if (n == 0 && n2 == 0) {
            throw new IllegalArgumentException(JaiI18N.getString("RenderableOp3"));
        }
        if (n == 0) {
            n = Math.round((float)n2 * (this.getWidth() / this.getHeight()));
        } else if (n2 == 0) {
            n2 = Math.round((float)n * (this.getHeight() / this.getWidth()));
        }
        double d = (double)n / (double)this.getWidth();
        double d2 = (double)n2 / (double)this.getHeight();
        if (Math.abs(d / d2 - 1.0) < 0.01) {
            d = d2;
        }
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d2);
        RenderContext renderContext = new RenderContext(affineTransform, renderingHints);
        return this.createRendering(renderContext);
    }

    private synchronized void createVolatilePropertyVector() {
        if (this.volatilePropertyInfo == null) {
            this.volatilePropertyInfo = new Vector();
        }
    }

    private ContextualRenderedImageFactory findCRIF() {
        if (this.crif == null) {
            this.crif = this.getRegistry().createRenderable(this.operationName, this.paramBlock);
        }
        if (this.crif == null) {
            System.out.println(JaiI18N.getString("RenderableOp2"));
        }
        return this.crif;
    }

    public byte getByteParameter(int n) {
        return this.paramBlock.getByteParameter(n);
    }

    public char getCharParameter(int n) {
        return this.paramBlock.getCharParameter(n);
    }

    public double getDoubleParameter(int n) {
        return this.paramBlock.getDoubleParameter(n);
    }

    public float getFloatParameter(int n) {
        return this.paramBlock.getFloatParameter(n);
    }

    public float getHeight() {
        this.findCRIF();
        this.boundingBox = this.crif.getBounds2D(this.paramBlock);
        return (float)this.boundingBox.getHeight();
    }

    public int getIntParameter(int n) {
        return this.paramBlock.getIntParameter(n);
    }

    public long getLongParameter(int n) {
        return this.paramBlock.getLongParameter(n);
    }

    public float getMinX() {
        this.findCRIF();
        this.boundingBox = this.crif.getBounds2D(this.paramBlock);
        return (float)this.boundingBox.getX();
    }

    public float getMinY() {
        this.findCRIF();
        this.boundingBox = this.crif.getBounds2D(this.paramBlock);
        return (float)this.boundingBox.getY();
    }

    public Object getObjectParameter(int n) {
        return this.paramBlock.getObjectParameter(n);
    }

    public String getOperationName() {
        return this.operationName;
    }

    public ParameterBlock getParameterBlock() {
        return this.paramBlock;
    }

    public Object getProperty(String string) {
        this.createPropertySource();
        string = string.toLowerCase();
        if (this.localProperties != null && this.localProperties.containsKey(string)) {
            return this.localProperties.get(string);
        }
        return this.thePropertySource.getProperty(string);
    }

    public String[] getPropertyNames() {
        this.createPropertySource();
        String[] stringArray = this.thePropertySource.getPropertyNames();
        Vector<String> vector = new Vector<String>();
        if (stringArray != null) {
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (!vector.contains(stringArray[n2])) {
                    vector.addElement(stringArray[n2]);
                }
                ++n2;
            }
        }
        if (this.localProperties != null) {
            Enumeration enumeration = this.localProperties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (vector.contains(string = string.toLowerCase())) continue;
                vector.addElement(string);
            }
        }
        String[] stringArray2 = new String[vector.size()];
        Enumeration enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray2[n++] = (String)enumeration.nextElement();
        }
        return stringArray2;
    }

    public String[] getPropertyNames(String string) {
        String[] stringArray = this.getPropertyNames();
        return PlanarImage.getPropertyNames(stringArray, string);
    }

    public synchronized OperationRegistry getRegistry() {
        if (this.theRegistry == null) {
            this.theRegistry = JAI.getDefaultInstance().getOperationRegistry();
        }
        return this.theRegistry;
    }

    private Vector getRenderableSources() {
        Vector<Object> vector = null;
        int n = this.paramBlock.getNumSources();
        if (n > 0) {
            vector = new Vector<Object>();
            int n2 = 0;
            while (n2 < n) {
                Object object = this.paramBlock.getSource(n2);
                if (object instanceof RenderableImage) {
                    vector.add(object);
                }
                ++n2;
            }
        }
        return vector;
    }

    private RenderedImage getRenderedImage(RenderContext renderContext) {
        Object var2_2 = null;
        RenderContext renderContext2 = null;
        ParameterBlock parameterBlock = (ParameterBlock)this.paramBlock.clone();
        Vector vector = this.getRenderableSources();
        try {
            Object object;
            Object object2;
            if (vector != null) {
                object2 = new Vector();
                int n = 0;
                while (n < vector.size()) {
                    renderContext2 = this.crif.mapRenderContext(n, renderContext, this.paramBlock, this);
                    object = (RenderableImage)vector.elementAt(n);
                    RenderedImage renderedImage = object.createRendering(renderContext2);
                    if (renderedImage == null) {
                        return null;
                    }
                    ((Vector)object2).addElement(renderedImage);
                    ++n;
                }
                if (((Vector)object2).size() > 0) {
                    parameterBlock.setSources((Vector<Object>)object2);
                }
            }
            if ((object2 = this.crif.create(renderContext, parameterBlock)) != null && object2 instanceof RenderedOp) {
                object = this.getPropertyNames();
                int n = 0;
                while (n < ((String[])object).length) {
                    String string = object[n];
                    Object object3 = this.getProperty(string);
                    if (object3 != null && object3 != Image.UndefinedProperty) {
                        ((RenderedOp)object2).setProperty(string, object3);
                    }
                    ++n;
                }
            }
            return object2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public short getShortParameter(int n) {
        return this.paramBlock.getShortParameter(n);
    }

    public Object getSource(int n) {
        Vector<Object> vector = this.paramBlock.getSources();
        return vector.elementAt(n);
    }

    public Vector getSources() {
        return this.getRenderableSources();
    }

    public float getWidth() {
        this.findCRIF();
        this.boundingBox = this.crif.getBounds2D(this.paramBlock);
        return (float)this.boundingBox.getWidth();
    }

    public boolean isDynamic() {
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        this.paramBlock = (ParameterBlock)objectInputStream.readObject();
        if (objectInputStream.readBoolean()) {
            this.localProperties = (Hashtable)objectInputStream.readObject();
        }
        int n = 0;
        while (n < this.paramBlock.getNumSources()) {
            Object object2 = this.paramBlock.getSource(n);
            if (object2 instanceof SerializableRenderedImage) {
                object = PlanarImage.wrapRenderedImage((RenderedImage)object2);
                this.paramBlock.setSource(object, n);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.paramBlock.getNumParameters()) {
            object = this.paramBlock.getObjectParameter(n2);
            if (object instanceof RasterProxy) {
                this.paramBlock.set(((RasterProxy)object).getRaster(), n2);
            } else if (object instanceof SerializableRenderedImage) {
                SerializableRenderedImage serializableRenderedImage = (SerializableRenderedImage)object;
                this.paramBlock.set(PlanarImage.wrapRenderedImage(serializableRenderedImage), n2);
            }
            ++n2;
        }
    }

    public synchronized void setOperationName(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.operationName = string;
    }

    public void setParameter(byte by, int n) {
        Vector<Object> vector = this.paramBlock.getParameters();
        vector.setElementAt(new Byte(by), n);
    }

    public void setParameter(char c, int n) {
        Vector<Object> vector = this.paramBlock.getParameters();
        vector.setElementAt(new Character(c), n);
    }

    public void setParameter(double d, int n) {
        Vector<Object> vector = this.paramBlock.getParameters();
        vector.setElementAt(new Double(d), n);
    }

    public void setParameter(float f, int n) {
        Vector<Object> vector = this.paramBlock.getParameters();
        vector.setElementAt(new Float(f), n);
    }

    public void setParameter(int n, int n2) {
        Vector<Object> vector = this.paramBlock.getParameters();
        vector.setElementAt(new Integer(n), n2);
    }

    public void setParameter(long l, int n) {
        Vector<Object> vector = this.paramBlock.getParameters();
        vector.setElementAt(new Long(l), n);
    }

    public void setParameter(Object object, int n) {
        Vector<Object> vector = this.paramBlock.getParameters();
        vector.setElementAt(object, n);
    }

    public void setParameter(short s, int n) {
        Vector<Object> vector = this.paramBlock.getParameters();
        vector.setElementAt(new Short(s), n);
    }

    public synchronized void setParameterBlock(ParameterBlock parameterBlock) {
        this.paramBlock = parameterBlock == null ? new ParameterBlock() : parameterBlock;
    }

    public void setProperty(String string, Object object) {
        string = string.toLowerCase();
        this.createLocalProperties();
        this.localProperties.put(string, object);
    }

    public synchronized void setRegistry(OperationRegistry operationRegistry) {
        this.theRegistry = operationRegistry;
    }

    public void setSource(Object object, int n) {
        Vector<Object> vector = this.paramBlock.getSources();
        vector.setElementAt(object, n);
    }

    public void suppressProperty(String string) {
        string = string.toLowerCase();
        this.createPropertySource();
        PropertySourceImpl propertySourceImpl = (PropertySourceImpl)this.thePropertySource;
        propertySourceImpl.suppressProperty(string);
        if (this.localProperties != null && this.localProperties.containsKey(string)) {
            this.localProperties.remove(string);
        }
        this.createVolatilePropertyVector();
        if (!this.volatilePropertyInfo.contains(string)) {
            this.volatilePropertyInfo.add(string);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object object;
        Object object2;
        ParameterBlock parameterBlock = this.paramBlock;
        boolean bl = false;
        int n = 0;
        while (n < parameterBlock.getNumSources()) {
            Object object3 = parameterBlock.getSource(n);
            if (object3 != null && !(object3 instanceof Serializable)) {
                if (!bl) {
                    parameterBlock = (ParameterBlock)this.paramBlock.clone();
                    bl = true;
                }
                if (object3 instanceof RenderedImage) {
                    object2 = new SerializableRenderedImage((RenderedImage)object3);
                    parameterBlock.setSource(object2, n);
                } else {
                    throw new RuntimeException(String.valueOf(object3.getClass().getName()) + JaiI18N.getString("RenderableOp0"));
                }
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < parameterBlock.getNumParameters()) {
            object2 = parameterBlock.getObjectParameter(n2);
            if (object2 != null && !(object2 instanceof Serializable)) {
                if (!bl) {
                    parameterBlock = (ParameterBlock)this.paramBlock.clone();
                    bl = true;
                }
                if (object2 instanceof Raster) {
                    parameterBlock.set(new RasterProxy((Raster)object2), n2);
                } else if (object2 instanceof RenderedImage) {
                    object = (RenderedImage)object2;
                    parameterBlock.set(new SerializableRenderedImage((RenderedImage)object, true), n2);
                } else {
                    throw new RuntimeException(String.valueOf(object2.getClass().getName()) + JaiI18N.getString("RenderableOp1"));
                }
            }
            ++n2;
        }
        object2 = null;
        if (this.localProperties != null) {
            object = this.localProperties.keys();
            while (object.hasMoreElements()) {
                Object k = object.nextElement();
                Object v = this.localProperties.get(k);
                if (v instanceof Serializable) continue;
                if (object2 == null) {
                    object2 = (Hashtable)this.localProperties.clone();
                }
                ((Hashtable)object2).remove(k);
            }
            if (object2 == null) {
                object2 = this.localProperties;
            } else if (((Hashtable)object2).size() == 0) {
                object2 = null;
            }
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(parameterBlock);
        if (object2 != null) {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeObject(object2);
        } else {
            objectOutputStream.writeBoolean(false);
        }
    }
}

