/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h5;

import java.io.File;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.HDFNativeData;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.structs.H5G_info_t;
import ncsa.hdf.hdf5lib.structs.H5L_info_t;
import ncsa.hdf.hdf5lib.structs.H5O_info_t;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.object.h5.H5CompoundDS;
import ncsa.hdf.object.h5.H5Datatype;
import ncsa.hdf.object.h5.H5Group;
import ncsa.hdf.object.h5.H5Link;
import ncsa.hdf.object.h5.H5ScalarDS;

public class H5File
extends FileFormat {
    private static final long serialVersionUID = 6247335559471526045L;
    private int flag;
    private int indexType;
    private DefaultMutableTreeNode rootNode = null;
    private static final int attrNameLen = 256;
    private int[] libver = new int[2];
    private boolean attrFlag = false;

    public H5File() {
        this("", 0);
    }

    public H5File(String fileName) {
        this(fileName, 1);
    }

    public H5File(String fileName, int access) {
        super(fileName);
        this.fid = -1;
        boolean bl = this.isReadOnly = access == 0;
        this.flag = access == 0 ? HDF5Constants.H5F_ACC_RDONLY : (access == 1 ? HDF5Constants.H5F_ACC_RDWR : (access == 2 ? HDF5Constants.H5F_ACC_CREAT : access));
    }

    public static final void copyAttributes(HObject src, HObject dst) {
        if (src != null && dst != null) {
            int srcID = src.open();
            int dstID = dst.open();
            if (srcID >= 0 && dstID >= 0) {
                H5File.copyAttributes(srcID, dstID);
            }
            if (srcID >= 0) {
                src.close(srcID);
            }
            if (dstID >= 0) {
                dst.close(dstID);
            }
        }
    }

    public static final void copyAttributes(int src_id, int dst_id) {
        int aid_src = -1;
        int aid_dst = -1;
        int atid = -1;
        int asid = -1;
        String[] aName = new String[]{""};
        H5O_info_t obj_info = null;
        try {
            obj_info = H5.H5Oget_info((int)src_id);
        }
        catch (Exception ex) {
            obj_info.num_attrs = -1L;
        }
        if (obj_info.num_attrs < 0L) {
            return;
        }
        int i = 0;
        while ((long)i < obj_info.num_attrs) {
            aName[0] = new String("");
            try {
                aid_src = H5.H5Aopen_by_idx((int)src_id, (String)".", (int)HDF5Constants.H5_INDEX_CRT_ORDER, (int)HDF5Constants.H5_ITER_INC, (long)i, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
                H5.H5Aget_name((int)aid_src, (long)256L, (String[])aName);
                atid = H5.H5Aget_type((int)aid_src);
                asid = H5.H5Aget_space((int)aid_src);
                aid_dst = H5.H5Acreate((int)dst_id, (String)aName[0], (int)atid, (int)asid, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
                H5.H5Acopy((int)aid_src, (int)aid_dst);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                H5.H5Sclose((int)asid);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                H5.H5Tclose((int)atid);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                H5.H5Aclose((int)aid_src);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                H5.H5Aclose((int)aid_dst);
            }
            catch (Exception ex) {
                // empty catch block
            }
            ++i;
        }
    }

    public static final List<Attribute> getAttribute(int objID) throws HDF5Exception {
        return H5File.getAttribute(objID, HDF5Constants.H5_INDEX_NAME, HDF5Constants.H5_ITER_INC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<Attribute> getAttribute(int objID, int idx_type, int order) throws HDF5Exception {
        Vector<Object> attributeList = null;
        int aid = -1;
        int sid = -1;
        int tid = -1;
        H5O_info_t obj_info = null;
        try {
            obj_info = H5.H5Oget_info((int)objID);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (obj_info.num_attrs <= 0L) {
            attributeList = new Vector<Attribute>();
            return attributeList;
        }
        int n = (int)obj_info.num_attrs;
        attributeList = new Vector(n);
        for (int i = 0; i < n; ++i) {
            long lsize = 1L;
            try {
                aid = H5.H5Aopen_by_idx((int)objID, (String)".", (int)idx_type, (int)order, (long)i, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
                sid = H5.H5Aget_space((int)aid);
                long[] dims = null;
                int rank = H5.H5Sget_simple_extent_ndims((int)sid);
                if (rank > 0) {
                    dims = new long[rank];
                    H5.H5Sget_simple_extent_dims((int)sid, (long[])dims, null);
                    for (int j = 0; j < dims.length; ++j) {
                        lsize *= dims[j];
                    }
                }
                String[] nameA = new String[]{""};
                H5.H5Aget_name((int)aid, (long)256L, (String[])nameA);
                int tmptid = -1;
                try {
                    tmptid = H5.H5Aget_type((int)aid);
                    tid = H5.H5Tget_native_type((int)tmptid);
                }
                finally {
                    try {
                        H5.H5Tclose((int)tmptid);
                    }
                    catch (Exception ex) {}
                }
                H5Datatype attrType = new H5Datatype(tid);
                Attribute attr = new Attribute(nameA[0], (Datatype)attrType, dims);
                attributeList.add(attr);
                boolean is_variable_str = false;
                boolean isVLEN = false;
                boolean isCompound = false;
                try {
                    is_variable_str = H5.H5Tis_variable_str((int)tid);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    isVLEN = H5.H5Tget_class((int)tid) == HDF5Constants.H5T_VLEN;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    isCompound = H5.H5Tget_class((int)tid) == HDF5Constants.H5T_COMPOUND;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (lsize <= 0L) continue;
                Object[] value = null;
                if (isVLEN || is_variable_str || isCompound) {
                    String[] strs = new String[(int)lsize];
                    int j = 0;
                    while ((long)j < lsize) {
                        strs[j] = "";
                        ++j;
                    }
                    H5.H5AreadVL((int)aid, (int)tid, (String[])strs);
                    value = strs;
                } else {
                    value = H5Datatype.allocateArray(tid, (int)lsize);
                    if (value == null) continue;
                    if (H5.H5Tget_class((int)tid) == HDF5Constants.H5T_ARRAY) {
                        int tmptid1 = -1;
                        int tmptid2 = -1;
                        try {
                            tmptid1 = H5.H5Tget_super((int)tid);
                            tmptid2 = H5.H5Tget_native_type((int)tmptid1);
                            H5.H5Aread((int)aid, (int)tmptid2, (Object)value);
                        }
                        catch (Exception ex) {
                        }
                        finally {
                            try {
                                H5.H5Tclose((int)tmptid1);
                            }
                            catch (Exception ex) {}
                            try {
                                H5.H5Tclose((int)tmptid2);
                            }
                            catch (Exception ex) {}
                        }
                    } else {
                        H5.H5Aread((int)aid, (int)tid, (Object)value);
                    }
                    int typeClass = H5.H5Tget_class((int)tid);
                    if (typeClass == HDF5Constants.H5T_STRING) {
                        value = Dataset.byteToString((byte[])((byte[])value), (int)H5.H5Tget_size((int)tid));
                    } else if (typeClass == HDF5Constants.H5T_REFERENCE) {
                        value = HDFNativeData.byteToLong((byte[])((byte[])value));
                    }
                }
                attr.setValue((Object)value);
                continue;
            }
            catch (HDF5Exception ex) {
                continue;
            }
            finally {
                try {
                    H5.H5Tclose((int)tid);
                }
                catch (HDF5Exception ex) {}
                try {
                    H5.H5Sclose((int)sid);
                }
                catch (HDF5Exception ex) {}
                try {
                    H5.H5Aclose((int)aid);
                }
                catch (HDF5Exception ex) {}
            }
        }
        return attributeList;
    }

    private static final void createImageAttributes(Dataset dataset, int selectionFlag) throws Exception {
        String subclass = null;
        String interlaceMode = null;
        if (selectionFlag == 0) {
            subclass = "IMAGE_TRUECOLOR";
            interlaceMode = "INTERLACE_PIXEL";
        } else if (selectionFlag == 2) {
            subclass = "IMAGE_TRUECOLOR";
            interlaceMode = "INTERLACE_PLANE";
        } else if (selectionFlag == -1) {
            subclass = "IMAGE_INDEXED";
        } else {
            throw new HDF5Exception("The selectionFlag is invalid.");
        }
        long[] attrDims = new long[]{1L};
        String attrName = "CLASS";
        String[] classValue = new String[]{"IMAGE"};
        H5Datatype attrType = new H5Datatype(3, classValue[0].length() + 1, -1, -1);
        Attribute attr = new Attribute(attrName, (Datatype)attrType, attrDims);
        attr.setValue((Object)classValue);
        dataset.writeMetadata((Object)attr);
        attrName = "IMAGE_VERSION";
        String[] versionValue = new String[]{"1.2"};
        attrType = new H5Datatype(3, versionValue[0].length() + 1, -1, -1);
        attr = new Attribute(attrName, (Datatype)attrType, attrDims);
        attr.setValue((Object)versionValue);
        dataset.writeMetadata((Object)attr);
        attrDims[0] = 2L;
        attrName = "IMAGE_MINMAXRANGE";
        byte[] attrValueInt = new byte[]{0, -1};
        attrType = new H5Datatype(2, 1, -1, 0);
        attr = new Attribute(attrName, (Datatype)attrType, attrDims);
        attr.setValue((Object)attrValueInt);
        dataset.writeMetadata((Object)attr);
        attrDims[0] = 1L;
        attrName = "IMAGE_SUBCLASS";
        String[] subclassValue = new String[]{subclass};
        attrType = new H5Datatype(3, subclassValue[0].length() + 1, -1, -1);
        attr = new Attribute(attrName, (Datatype)attrType, attrDims);
        attr.setValue((Object)subclassValue);
        dataset.writeMetadata((Object)attr);
        if (selectionFlag == 0 || selectionFlag == 2) {
            attrName = "INTERLACE_MODE";
            String[] interlaceValue = new String[]{interlaceMode};
            attrType = new H5Datatype(3, interlaceValue[0].length() + 1, -1, -1);
            attr = new Attribute(attrName, (Datatype)attrType, attrDims);
            attr.setValue((Object)interlaceValue);
            dataset.writeMetadata((Object)attr);
        } else {
            attrName = "PALETTE";
            long[] palRef = new long[]{0L};
            attrType = new H5Datatype(7, 1, -1, 0);
            attr = new Attribute(attrName, (Datatype)attrType, attrDims);
            attr.setValue((Object)palRef);
            dataset.writeMetadata((Object)attr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void updateReferenceDataset(H5File srcFile, H5File dstFile) throws Exception {
        if (srcFile == null || dstFile == null) {
            return;
        }
        DefaultMutableTreeNode srcRoot = (DefaultMutableTreeNode)srcFile.getRootNode();
        DefaultMutableTreeNode newRoot = (DefaultMutableTreeNode)dstFile.getRootNode();
        Enumeration<TreeNode> srcEnum = srcRoot.breadthFirstEnumeration();
        Enumeration<TreeNode> newEnum = newRoot.breadthFirstEnumeration();
        int did = -1;
        int tid = -1;
        Hashtable<String, long[]> oidMap = new Hashtable<String, long[]>();
        Vector<ScalarDS> refDatasets = new Vector<ScalarDS>();
        while (newEnum.hasMoreElements() && srcEnum.hasMoreElements()) {
            HObject srcObj = (HObject)((DefaultMutableTreeNode)srcEnum.nextElement()).getUserObject();
            HObject newObj = (HObject)((DefaultMutableTreeNode)newEnum.nextElement()).getUserObject();
            oidMap.put(String.valueOf(srcObj.getOID()[0]), newObj.getOID());
            did = -1;
            tid = -1;
            if (!(newObj instanceof ScalarDS)) continue;
            ScalarDS sd = (ScalarDS)newObj;
            did = sd.open();
            if (did > 0) {
                try {
                    tid = H5.H5Dget_type((int)did);
                    if (H5.H5Tequal((int)tid, (int)HDF5Constants.H5T_STD_REF_OBJ)) {
                        refDatasets.add(sd);
                    }
                }
                catch (Exception ex) {
                }
                finally {
                    try {
                        H5.H5Tclose((int)tid);
                    }
                    catch (Exception ex) {}
                }
            }
            sd.close(did);
        }
        H5ScalarDS d = null;
        int sid = -1;
        int size = 0;
        int rank = 0;
        int n = refDatasets.size();
        for (int i = 0; i < n; ++i) {
            d = (H5ScalarDS)((Object)refDatasets.get(i));
            byte[] buf = null;
            long[] refs = null;
            try {
                did = d.open();
                tid = H5.H5Dget_type((int)did);
                sid = H5.H5Dget_space((int)did);
                rank = H5.H5Sget_simple_extent_ndims((int)sid);
                size = 1;
                if (rank > 0) {
                    long[] dims = new long[rank];
                    H5.H5Sget_simple_extent_dims((int)sid, (long[])dims, null);
                    for (int j = 0; j < rank; ++j) {
                        size *= (int)dims[j];
                    }
                    dims = null;
                }
                buf = new byte[size * 8];
                H5.H5Dread((int)did, (int)tid, (int)HDF5Constants.H5S_ALL, (int)HDF5Constants.H5S_ALL, (int)HDF5Constants.H5P_DEFAULT, (byte[])buf);
                refs = HDFNativeData.byteToLong((byte[])buf);
                size = refs.length;
                for (int j = 0; j < size; ++j) {
                    long[] theOID = (long[])oidMap.get(String.valueOf(refs[j]));
                    if (theOID == null) continue;
                    refs[j] = theOID[0];
                }
                H5.H5Dwrite((int)did, (int)tid, (int)HDF5Constants.H5S_ALL, (int)HDF5Constants.H5S_ALL, (int)HDF5Constants.H5P_DEFAULT, (Object)refs);
            }
            catch (Exception ex) {
                continue;
            }
            finally {
                try {
                    H5.H5Tclose((int)tid);
                }
                catch (Exception ex) {}
                try {
                    H5.H5Sclose((int)sid);
                }
                catch (Exception ex) {}
                try {
                    H5.H5Dclose((int)did);
                }
                catch (Exception ex) {}
            }
            refs = null;
            buf = null;
        }
    }

    public String getLibversion() {
        int[] vers = new int[3];
        String ver = "HDF5 ";
        try {
            H5.H5get_libversion((int[])vers);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        ver = ver + vers[0] + "." + vers[1] + "." + vers[2];
        return ver;
    }

    public boolean isThisType(FileFormat theFile) {
        return theFile instanceof H5File;
    }

    public boolean isThisType(String filename) {
        boolean isH5 = false;
        try {
            isH5 = H5.H5Fis_hdf5((String)filename);
        }
        catch (HDF5Exception ex) {
            isH5 = false;
        }
        return isH5;
    }

    public FileFormat createFile(String filename, int createFlag) throws Exception {
        File f;
        Boolean doCreateFile = true;
        if (createFlag == 11 && (f = new File(filename)).exists()) {
            doCreateFile = false;
        }
        if (doCreateFile.booleanValue()) {
            int fileid = H5.H5Fcreate((String)filename, (int)HDF5Constants.H5F_ACC_TRUNC, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
            try {
                H5.H5Fclose((int)fileid);
            }
            catch (HDF5Exception ex) {
                // empty catch block
            }
        }
        return new H5File(filename, 1);
    }

    public FileFormat createInstance(String filename, int access) throws Exception {
        return new H5File(filename, access);
    }

    public int open() throws Exception {
        return this.open(true);
    }

    public int open(int ... propList) throws Exception {
        this.indexType = propList[0];
        return this.open(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLibBounds(int low, int high) throws Exception {
        int fapl = HDF5Constants.H5P_DEFAULT;
        if (this.fid < 0) {
            return;
        }
        fapl = H5.H5Fget_access_plist((int)this.fid);
        try {
            if (low < 0) {
                low = HDF5Constants.H5F_LIBVER_EARLIEST;
            }
            if (high < 0) {
                high = HDF5Constants.H5F_LIBVER_LATEST;
            }
            H5.H5Pset_libver_bounds((int)fapl, (int)low, (int)high);
            H5.H5Pget_libver_bounds((int)fapl, (int[])this.libver);
        }
        finally {
            try {
                H5.H5Pclose((int)fapl);
            }
            catch (Exception e) {}
        }
    }

    public int[] getLibBounds() throws Exception {
        return this.libver;
    }

    public void close() throws HDF5Exception {
        H5.H5Dchdir_ext((String)System.getProperty("user.dir"));
        if (this.rootNode != null) {
            DefaultMutableTreeNode theNode = null;
            HObject theObj = null;
            Enumeration<TreeNode> local_enum = this.rootNode.breadthFirstEnumeration();
            while (local_enum.hasMoreElements()) {
                theNode = (DefaultMutableTreeNode)local_enum.nextElement();
                theObj = (HObject)theNode.getUserObject();
                if (theObj instanceof Dataset) {
                    ((Dataset)theObj).clear();
                    continue;
                }
                if (!(theObj instanceof Group)) continue;
                ((Group)theObj).clear();
            }
        }
        try {
            int n = 0;
            int type = -1;
            n = H5.H5Fget_obj_count((int)this.fid, (int)HDF5Constants.H5F_OBJ_ALL);
            if (n > 0) {
                int[] oids = new int[n];
                H5.H5Fget_obj_ids((int)this.fid, (int)HDF5Constants.H5F_OBJ_ALL, (int)n, (int[])oids);
                for (int i = 0; i < n; ++i) {
                    type = H5.H5Iget_type((int)oids[i]);
                    if (HDF5Constants.H5I_DATASET == type) {
                        try {
                            H5.H5Dclose((int)oids[i]);
                        }
                        catch (Exception ex2) {}
                        continue;
                    }
                    if (HDF5Constants.H5I_GROUP == type) {
                        try {
                            H5.H5Gclose((int)oids[i]);
                        }
                        catch (Exception ex2) {}
                        continue;
                    }
                    if (HDF5Constants.H5I_DATATYPE == type) {
                        try {
                            H5.H5Tclose((int)oids[i]);
                        }
                        catch (Exception ex2) {}
                        continue;
                    }
                    if (HDF5Constants.H5I_ATTR != type) continue;
                    try {
                        H5.H5Aclose((int)oids[i]);
                        continue;
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            H5.H5Fflush((int)this.fid, (int)HDF5Constants.H5F_SCOPE_GLOBAL);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            H5.H5Fclose((int)this.fid);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fid = -1;
    }

    public TreeNode getRootNode() {
        return this.rootNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HObject get(String path) throws Exception {
        Object obj = null;
        if (path == null || path.length() <= 0) {
            return null;
        }
        path = path.replace('\\', '/');
        path = "/" + path;
        path = path.replaceAll("//", "/");
        if (this.rootNode != null) {
            obj = H5File.findObject((FileFormat)this, (String)path);
        }
        if (obj != null) {
            return obj;
        }
        String name = null;
        String pPath = null;
        if (path.equals("/")) {
            name = "/";
        } else {
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 2);
            }
            int idx = path.lastIndexOf(47);
            name = path.substring(idx + 1);
            pPath = idx == 0 ? "/" : path.substring(0, idx);
        }
        int fid_before_open = this.fid;
        this.fid = this.open(false);
        if (this.fid < 0) {
            return null;
        }
        try {
            int oid = H5.H5Oopen((int)this.fid, (String)path, (int)HDF5Constants.H5P_DEFAULT);
            if (oid >= 0) {
                H5O_info_t info = H5.H5Oget_info((int)oid);
                int objType = info.type;
                if (objType == HDF5Constants.H5O_TYPE_DATASET) {
                    int did = -1;
                    try {
                        did = H5.H5Dopen((int)this.fid, (String)path, (int)HDF5Constants.H5P_DEFAULT);
                        obj = this.getDataset(did, name, pPath);
                    }
                    finally {
                        try {
                            H5.H5Dclose((int)did);
                        }
                        catch (Exception ex) {}
                    }
                }
                if (objType == HDF5Constants.H5O_TYPE_GROUP) {
                    int gid = -1;
                    try {
                        gid = H5.H5Gopen((int)this.fid, (String)path, (int)HDF5Constants.H5P_DEFAULT);
                        H5Group pGroup = null;
                        if (pPath != null) {
                            pGroup = new H5Group(this, null, pPath, null);
                            obj = this.getGroup(gid, name, pGroup);
                            pGroup.addToMemberList((HObject)obj);
                        }
                        obj = this.getGroup(gid, name, pGroup);
                    }
                    finally {
                        try {
                            H5.H5Gclose((int)gid);
                        }
                        catch (Exception ex) {}
                    }
                } else if (objType == HDF5Constants.H5O_TYPE_NAMED_DATATYPE) {
                    obj = new H5Datatype(this, name, pPath);
                }
            }
            try {
                H5.H5Oclose((int)oid);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception ex) {
            obj = null;
        }
        finally {
            if (fid_before_open <= 0 && obj == null) {
                try {
                    H5.H5Fclose((int)this.fid);
                }
                catch (Exception ex) {}
                this.fid = fid_before_open;
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datatype createDatatype(int tclass, int tsize, int torder, int tsign, String name) throws Exception {
        int tid = -1;
        H5Datatype dtype = null;
        try {
            H5Datatype t = (H5Datatype)this.createDatatype(tclass, tsize, torder, tsign);
            tid = t.toNative();
            H5.H5Tcommit((int)this.fid, (String)name, (int)tid, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
            byte[] ref_buf = H5.H5Rcreate((int)this.fid, (String)name, (int)HDF5Constants.H5R_OBJECT, (int)-1);
            long l = HDFNativeData.byteToLong((byte[])ref_buf, (int)0);
            long[] oid = new long[]{l};
            dtype = new H5Datatype(this, null, name);
        }
        finally {
            if (tid > 0) {
                H5.H5Tclose((int)tid);
            }
        }
        return dtype;
    }

    public Datatype createDatatype(int tclass, int tsize, int torder, int tsign) throws Exception {
        return new H5Datatype(tclass, tsize, torder, tsign);
    }

    public Dataset createScalarDS(String name, Group pgroup, Datatype type, long[] dims, long[] maxdims, long[] chunks, int gzip, Object fillValue, Object data) throws Exception {
        if (pgroup == null) {
            pgroup = (Group)this.get("/");
        }
        return H5ScalarDS.create(name, pgroup, type, dims, maxdims, chunks, gzip, fillValue, data);
    }

    public Dataset createCompoundDS(String name, Group pgroup, long[] dims, long[] maxdims, long[] chunks, int gzip, String[] memberNames, Datatype[] memberDatatypes, int[] memberSizes, Object data) throws Exception {
        int nMembers = memberNames.length;
        int[] memberRanks = new int[nMembers];
        long[][] memberDims = new long[nMembers][1];
        Dataset ds = null;
        for (int i = 0; i < nMembers; ++i) {
            memberRanks[i] = 1;
            memberDims[i][0] = memberSizes == null ? 1L : (long)memberSizes[i];
        }
        if (pgroup == null) {
            pgroup = (Group)this.get("/");
        }
        ds = H5CompoundDS.create(name, pgroup, dims, maxdims, chunks, gzip, memberNames, memberDatatypes, memberRanks, memberDims, data);
        return ds;
    }

    public Dataset createImage(String name, Group pgroup, Datatype type, long[] dims, long[] maxdims, long[] chunks, int gzip, int ncomp, int interlace, Object data) throws Exception {
        if (pgroup == null) {
            pgroup = (Group)this.get("/");
        }
        H5ScalarDS dataset = H5ScalarDS.create(name, pgroup, type, dims, maxdims, chunks, gzip, data);
        try {
            H5File.createImageAttributes((Dataset)dataset, interlace);
            dataset.setIsImage(true);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return dataset;
    }

    public Group createGroup(String name, Group pgroup) throws Exception {
        return this.createGroup(name, pgroup, HDF5Constants.H5P_DEFAULT);
    }

    public Group createGroup(String name, Group pgroup, int ... gplist) throws Exception {
        if (pgroup == null) {
            pgroup = (Group)this.get("/");
        }
        return H5Group.create(name, pgroup, gplist);
    }

    public int createGcpl(int creationorder, int maxcompact, int mindense) throws Exception {
        int gcpl = -1;
        try {
            gcpl = H5.H5Pcreate((int)HDF5Constants.H5P_GROUP_CREATE);
            if (gcpl >= 0) {
                if (creationorder == 1) {
                    H5.H5Pset_link_creation_order((int)gcpl, (int)HDF5Constants.H5P_CRT_ORDER_TRACKED);
                } else if (creationorder == 2) {
                    H5.H5Pset_link_creation_order((int)gcpl, (int)(HDF5Constants.H5P_CRT_ORDER_TRACKED + HDF5Constants.H5P_CRT_ORDER_INDEXED));
                }
                H5.H5Pset_link_phase_change((int)gcpl, (int)maxcompact, (int)mindense);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return gcpl;
    }

    public HObject createLink(Group parentGroup, String name, Object currentObj) throws Exception {
        if (currentObj instanceof HObject) {
            return this.createLink(parentGroup, name, (HObject)currentObj, 0);
        }
        if (currentObj instanceof String) {
            return this.createLink(parentGroup, name, (String)currentObj, 0);
        }
        return null;
    }

    public HObject createLink(Group parentGroup, String name, HObject currentObj, int lType) throws Exception {
        Object obj = null;
        int type = 0;
        String current_full_name = null;
        String new_full_name = null;
        String parent_path = null;
        if (currentObj == null) {
            throw new HDF5Exception("The object pointed by the link cannot be null.");
        }
        parent_path = parentGroup == null || parentGroup.isRoot() ? "/" : parentGroup.getPath() + "/" + parentGroup.getName() + "/";
        new_full_name = parent_path + name;
        if (lType == 0) {
            type = HDF5Constants.H5L_TYPE_HARD;
        } else if (lType == 1) {
            type = HDF5Constants.H5L_TYPE_SOFT;
        } else if (lType == 64) {
            type = HDF5Constants.H5L_TYPE_EXTERNAL;
        }
        if (H5.H5Lexists((int)this.fid, (String)new_full_name, (int)HDF5Constants.H5P_DEFAULT)) {
            H5.H5Ldelete((int)this.fid, (String)new_full_name, (int)HDF5Constants.H5P_DEFAULT);
        }
        if (type == HDF5Constants.H5L_TYPE_HARD) {
            if (currentObj instanceof Group && ((Group)currentObj).isRoot()) {
                throw new HDF5Exception("Cannot make a link to the root group.");
            }
            current_full_name = currentObj.getPath() + "/" + currentObj.getName();
            H5.H5Lcreate_hard((int)this.fid, (String)current_full_name, (int)this.fid, (String)new_full_name, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
        } else if (type == HDF5Constants.H5L_TYPE_SOFT) {
            H5.H5Lcreate_soft((String)currentObj.getFullName(), (int)this.fid, (String)new_full_name, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
        } else if (type == HDF5Constants.H5L_TYPE_EXTERNAL) {
            H5.H5Lcreate_external((String)currentObj.getFile(), (String)currentObj.getFullName(), (int)this.fid, (String)new_full_name, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
        }
        if (currentObj instanceof Group) {
            obj = new H5Group(this, name, parent_path, parentGroup);
        } else if (currentObj instanceof H5Datatype) {
            obj = new H5Datatype(this, name, parent_path);
        } else if (currentObj instanceof H5CompoundDS) {
            obj = new H5CompoundDS(this, name, parent_path);
        } else if (currentObj instanceof H5ScalarDS) {
            obj = new H5ScalarDS(this, name, parent_path);
        }
        return obj;
    }

    public HObject createLink(Group parentGroup, String name, String currentObj, int lType) throws Exception {
        H5Link obj = null;
        int type = 0;
        String new_full_name = null;
        String parent_path = null;
        if (currentObj == null) {
            throw new HDF5Exception("The object pointed by the link cannot be null.");
        }
        parent_path = parentGroup == null || parentGroup.isRoot() ? "/" : parentGroup.getPath() + "/" + parentGroup.getName() + "/";
        new_full_name = parent_path + name;
        if (lType == 0) {
            type = HDF5Constants.H5L_TYPE_HARD;
        } else if (lType == 1) {
            type = HDF5Constants.H5L_TYPE_SOFT;
        } else if (lType == 64) {
            type = HDF5Constants.H5L_TYPE_EXTERNAL;
        }
        if (H5.H5Lexists((int)this.fid, (String)new_full_name, (int)HDF5Constants.H5P_DEFAULT)) {
            H5.H5Ldelete((int)this.fid, (String)new_full_name, (int)HDF5Constants.H5P_DEFAULT);
        }
        if (type == HDF5Constants.H5L_TYPE_SOFT) {
            H5.H5Lcreate_soft((String)currentObj, (int)this.fid, (String)new_full_name, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
        } else if (type == HDF5Constants.H5L_TYPE_EXTERNAL) {
            String fileName = null;
            String objectName = null;
            fileName = currentObj.substring(0, currentObj.lastIndexOf("://"));
            objectName = currentObj.substring(currentObj.indexOf("://"));
            objectName = objectName.substring(3);
            H5.H5Lcreate_external((String)fileName, (String)objectName, (int)this.fid, (String)new_full_name, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        obj = new H5Link(this, name, parent_path);
        return obj;
    }

    public void reloadTree(Group g) {
        if (this.fid < 0 || this.rootNode == null || g == null) {
            return;
        }
        HObject theObj = null;
        DefaultMutableTreeNode theNode = null;
        if (g.equals(this.rootNode.getUserObject())) {
            theNode = this.rootNode;
        } else {
            Enumeration<TreeNode> local_enum = this.rootNode.breadthFirstEnumeration();
            while (local_enum.hasMoreElements() && !g.equals(theObj = (HObject)(theNode = (DefaultMutableTreeNode)local_enum.nextElement()).getUserObject())) {
            }
        }
        theNode.removeAllChildren();
        this.depth_first(theNode);
    }

    public TreeNode copy(HObject srcObj, Group dstGroup, String dstName) throws Exception {
        TreeNode newNode = null;
        if (srcObj == null || dstGroup == null) {
            return null;
        }
        if (dstName == null) {
            dstName = srcObj.getName();
        }
        List members = dstGroup.getMemberList();
        int n = members.size();
        for (int i = 0; i < n; ++i) {
            HObject obj = (HObject)members.get(i);
            String name = obj.getName();
            while (name.equals(dstName)) {
                dstName = dstName + "~copy";
            }
        }
        if (srcObj instanceof Dataset) {
            newNode = this.copyDataset((Dataset)srcObj, (H5Group)dstGroup, dstName);
        } else if (srcObj instanceof H5Group) {
            newNode = this.copyGroup((H5Group)srcObj, (H5Group)dstGroup, dstName);
        } else if (srcObj instanceof H5Datatype) {
            newNode = this.copyDatatype((H5Datatype)srcObj, (H5Group)dstGroup, dstName);
        }
        return newNode;
    }

    public void delete(HObject obj) throws Exception {
        if (obj == null || this.fid < 0) {
            return;
        }
        String name = obj.getPath() + obj.getName();
        H5.H5Ldelete((int)this.fid, (String)name, (int)HDF5Constants.H5P_DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAttribute(HObject obj, Attribute attr, boolean attrExisted) throws HDF5Exception {
        int objID;
        block25: {
            String obj_name = obj.getFullName();
            String name = attr.getName();
            int tid = -1;
            int sid = -1;
            int aid = -1;
            objID = obj.open();
            if (objID < 0) {
                return;
            }
            try {
                boolean isVlen;
                tid = attr.getType().toNative();
                sid = H5.H5Screate_simple((int)attr.getRank(), (long[])attr.getDataDims(), null);
                aid = attrExisted ? H5.H5Aopen_by_name((int)objID, (String)obj_name, (String)name, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT) : H5.H5Acreate((int)objID, (String)name, (int)tid, (int)sid, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
                Object attrValue = attr.getValue();
                if (attrValue == null) break block25;
                boolean bl = isVlen = H5.H5Tget_class((int)tid) == HDF5Constants.H5T_VLEN || H5.H5Tis_variable_str((int)tid);
                if (isVlen) {
                    throw new HDF5Exception("Writing variable-length attributes is not supported");
                }
                if (attr.getType().getDatatypeClass() == 7 && attrValue instanceof String) {
                    attrValue = H5.H5Rcreate((int)this.getFID(), (String)((String)attrValue), (int)HDF5Constants.H5R_OBJECT, (int)-1);
                } else if (Array.get(attrValue, 0) instanceof String) {
                    int size = H5.H5Tget_size((int)tid);
                    int len = ((String[])attrValue).length;
                    byte[] bval = Dataset.stringToByte((String[])((String[])attrValue), (int)size);
                    if (bval != null && bval.length == size * len) {
                        bval[bval.length - 1] = 0;
                        attrValue = bval;
                    }
                }
                try {
                    int tmptid = tid;
                    tid = H5.H5Tget_native_type((int)tmptid);
                    try {
                        H5.H5Tclose((int)tmptid);
                    }
                    catch (HDF5Exception ex) {
                        // empty catch block
                    }
                    H5.H5Awrite((int)aid, (int)tid, (Object)attrValue);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            finally {
                try {
                    H5.H5Tclose((int)tid);
                }
                catch (HDF5Exception ex) {}
                try {
                    H5.H5Sclose((int)sid);
                }
                catch (HDF5Exception ex) {}
                try {
                    H5.H5Aclose((int)aid);
                }
                catch (HDF5Exception ex) {}
            }
        }
        obj.close(objID);
    }

    public int open(int plist) throws Exception {
        return this.open(true, plist);
    }

    private int open(boolean loadFullHierarchy) throws Exception {
        int the_fid = -1;
        int plist = HDF5Constants.H5P_DEFAULT;
        the_fid = this.open(loadFullHierarchy, plist);
        return the_fid;
    }

    private int open(boolean loadFullHierarchy, int plist) throws Exception {
        block13: {
            if (this.fid > 0) {
                return this.fid;
            }
            H5.H5Dchdir_ext((String)System.getProperty("user.dir"));
            if (this.flag < 0) {
                throw new HDF5Exception("Invalid access identifer -- " + this.flag);
            }
            if (HDF5Constants.H5F_ACC_CREAT == this.flag) {
                this.fid = H5.H5Fcreate((String)this.fullFileName, (int)HDF5Constants.H5F_ACC_TRUNC, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
                H5.H5Fflush((int)this.fid, (int)HDF5Constants.H5F_SCOPE_LOCAL);
                H5.H5Fclose((int)this.fid);
                this.flag = HDF5Constants.H5F_ACC_RDWR;
            } else {
                if (!this.exists()) {
                    throw new HDF5Exception("File does not exist -- " + this.fullFileName);
                }
                if (!(this.flag != HDF5Constants.H5F_ACC_RDWR && this.flag != HDF5Constants.H5F_ACC_CREAT || this.canWrite())) {
                    throw new HDF5Exception("Cannot write file, try open as read-only -- " + this.fullFileName);
                }
                if (this.flag == HDF5Constants.H5F_ACC_RDONLY && !this.canRead()) {
                    throw new HDF5Exception("Cannot read file -- " + this.fullFileName);
                }
            }
            try {
                this.fid = H5.H5Fopen((String)this.fullFileName, (int)this.flag, (int)plist);
            }
            catch (Exception ex) {
                try {
                    this.fid = H5.H5Fopen((String)this.fullFileName, (int)HDF5Constants.H5F_ACC_RDONLY, (int)HDF5Constants.H5P_DEFAULT);
                    this.isReadOnly = true;
                }
                catch (Exception ex2) {
                    char c;
                    int idx;
                    File tmpf = new File(this.fullFileName);
                    String tmpname = tmpf.getName();
                    for (idx = tmpname.lastIndexOf("."); idx > 0 && (c = tmpname.charAt(idx)) >= '0'; --idx) {
                    }
                    if (idx <= 0) break block13;
                    tmpname = tmpname.substring(0, idx - 1) + "%d" + tmpname.substring(tmpname.lastIndexOf("."));
                    int pid = H5.H5Pcreate((int)HDF5Constants.H5P_FILE_ACCESS);
                    H5.H5Pset_fapl_family((int)pid, (long)0L, (int)HDF5Constants.H5P_DEFAULT);
                    this.fid = H5.H5Fopen((String)(tmpf.getParent() + File.separator + tmpname), (int)this.flag, (int)pid);
                    H5.H5Pclose((int)pid);
                }
            }
        }
        if (this.fid >= 0 && loadFullHierarchy) {
            this.rootNode = this.loadTree();
        }
        return this.fid;
    }

    private DefaultMutableTreeNode loadTree() {
        if (this.fid < 0) {
            return null;
        }
        DefaultMutableTreeNode root = null;
        long[] rootOID = new long[]{0L};
        H5Group rootGroup = new H5Group(this, "/", null, null);
        root = new DefaultMutableTreeNode((Object)rootGroup){
            private static final long serialVersionUID = 991382067363411723L;

            @Override
            public boolean isLeaf() {
                return false;
            }
        };
        this.depth_first(root);
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void depth_first(MutableTreeNode parentNode) {
        DefaultMutableTreeNode node = null;
        String fullPath = null;
        String ppath = null;
        DefaultMutableTreeNode pnode = (DefaultMutableTreeNode)parentNode;
        int gid = -1;
        H5Group pgroup = (H5Group)((Object)pnode.getUserObject());
        ppath = pgroup.getPath();
        fullPath = ppath == null ? "/" : ppath + pgroup.getName() + "/";
        int nelems = 0;
        try {
            gid = pgroup.open();
            H5G_info_t info = H5.H5Gget_info((int)gid);
            nelems = (int)info.nlinks;
        }
        catch (HDF5Exception ex) {
            nelems = -1;
        }
        if (nelems <= 0) {
            pgroup.close(gid);
            return;
        }
        int[] objTypes = new int[nelems];
        long[] fNos = new long[nelems];
        long[] objRefs = new long[nelems];
        String[] objNames = new String[nelems];
        try {
            H5.H5Gget_obj_info_all((int)this.fid, (String)fullPath, (String[])objNames, (int[])objTypes, null, (long[])fNos, (long[])objRefs, (int)-1);
        }
        catch (HDF5Exception ex) {
            ex.printStackTrace();
            return;
        }
        int startIndex = Math.max(0, this.getStartMembers());
        int endIndex = this.getMaxMembers();
        if (endIndex >= nelems) {
            endIndex = nelems;
            startIndex = 0;
        }
        endIndex += startIndex;
        endIndex = Math.min(endIndex, nelems);
        for (int i = startIndex; i < endIndex; ++i) {
            String obj_name = objNames[i];
            int obj_type = objTypes[i];
            long[] oid = new long[]{objRefs[i], fNos[i]};
            if (obj_name == null) continue;
            if (obj_type == HDF5Constants.H5O_TYPE_UNKNOWN) {
                H5Link link = new H5Link(this, obj_name, fullPath, oid);
                node = new DefaultMutableTreeNode((Object)link);
                pnode.add(node);
                pgroup.addToMemberList(link);
                continue;
            }
            if (obj_type == HDF5Constants.H5O_TYPE_GROUP) {
                H5Group g = new H5Group(this, obj_name, fullPath, pgroup, oid);
                node = new DefaultMutableTreeNode((Object)g){
                    private static final long serialVersionUID = 5139629211215794015L;

                    @Override
                    public boolean isLeaf() {
                        return false;
                    }
                };
                pnode.add(node);
                pgroup.addToMemberList((HObject)g);
                boolean hasLoop = false;
                HObject tmpObj = null;
                for (DefaultMutableTreeNode tmpNode = pnode; tmpNode != null; tmpNode = (DefaultMutableTreeNode)tmpNode.getParent()) {
                    tmpObj = (HObject)tmpNode.getUserObject();
                    if (!tmpObj.equalsOID(oid)) continue;
                    hasLoop = true;
                    break;
                }
                if (hasLoop) continue;
                this.depth_first(node);
                continue;
            }
            if (obj_type == HDF5Constants.H5O_TYPE_DATASET) {
                int did = -1;
                int tid = -1;
                int tclass = -1;
                try {
                    did = H5.H5Dopen((int)this.fid, (String)(fullPath + obj_name), (int)HDF5Constants.H5P_DEFAULT);
                    tid = H5.H5Dget_type((int)did);
                    tclass = H5.H5Tget_class((int)tid);
                    if (tclass == HDF5Constants.H5T_ARRAY || tclass == HDF5Constants.H5T_VLEN) {
                        int btid = H5.H5Tget_super((int)tid);
                        int tmpclass = H5.H5Tget_class((int)btid);
                        if (tmpclass != HDF5Constants.H5T_COMPOUND) {
                            tclass = H5.H5Tget_class((int)btid);
                        }
                        try {
                            H5.H5Tclose((int)btid);
                        }
                        catch (HDF5Exception ex) {
                            // empty catch block
                        }
                    }
                }
                catch (HDF5Exception ex) {
                }
                finally {
                    try {
                        H5.H5Tclose((int)tid);
                    }
                    catch (HDF5Exception ex) {}
                    try {
                        H5.H5Dclose((int)did);
                    }
                    catch (HDF5Exception ex) {}
                }
                Object d = null;
                d = tclass == HDF5Constants.H5T_COMPOUND ? new H5CompoundDS(this, obj_name, fullPath, oid) : new H5ScalarDS(this, obj_name, fullPath, oid);
                node = new DefaultMutableTreeNode(d);
                pnode.add(node);
                pgroup.addToMemberList((HObject)d);
                continue;
            }
            if (obj_type != HDF5Constants.H5O_TYPE_NAMED_DATATYPE) continue;
            H5Datatype t = new H5Datatype(this, obj_name, fullPath, oid);
            node = new DefaultMutableTreeNode((Object)t);
            pnode.add(node);
            pgroup.addToMemberList((HObject)t);
        }
        pgroup.close(gid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeNode copyDataset(Dataset srcDataset, H5Group pgroup, String dstName) throws Exception {
        DefaultMutableTreeNode newNode;
        Object dataset = null;
        int srcdid = -1;
        int dstdid = -1;
        int ocp_plist_id = -1;
        String dname = null;
        String path = null;
        path = pgroup.isRoot() ? "/" : pgroup.getPath() + pgroup.getName() + "/";
        if (dstName == null || dstName.equals("/") || dstName.length() < 1) {
            dstName = srcDataset.getName();
        }
        dname = path + dstName;
        try {
            srcdid = srcDataset.open();
            dstdid = pgroup.open();
            try {
                ocp_plist_id = H5.H5Pcreate((int)HDF5Constants.H5P_OBJECT_COPY);
                H5.H5Pset_copy_object((int)ocp_plist_id, (int)HDF5Constants.H5O_COPY_EXPAND_REFERENCE_FLAG);
                H5.H5Ocopy((int)srcdid, (String)".", (int)dstdid, (String)dstName, (int)ocp_plist_id, (int)HDF5Constants.H5P_DEFAULT);
            }
            catch (Exception ex) {
            }
            finally {
                try {
                    H5.H5Pclose((int)ocp_plist_id);
                }
                catch (Exception ex) {}
            }
            dataset = srcDataset instanceof H5ScalarDS ? new H5ScalarDS(pgroup.getFileFormat(), dstName, path) : new H5CompoundDS(pgroup.getFileFormat(), dstName, path);
            pgroup.addToMemberList((HObject)dataset);
            newNode = new DefaultMutableTreeNode(dataset);
        }
        finally {
            try {
                srcDataset.close(srcdid);
            }
            catch (Exception ex) {}
            try {
                pgroup.close(dstdid);
            }
            catch (Exception ex) {}
        }
        return newNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dataset getDataset(int did, String name, String path) throws HDF5Exception {
        Object dataset = null;
        int tid = -1;
        int tclass = -1;
        try {
            tid = H5.H5Dget_type((int)did);
            tclass = H5.H5Tget_class((int)tid);
            if (tclass == HDF5Constants.H5T_ARRAY) {
                int btid = H5.H5Tget_super((int)tid);
                tclass = H5.H5Tget_class((int)btid);
                try {
                    H5.H5Tclose((int)btid);
                }
                catch (HDF5Exception ex) {
                    // empty catch block
                }
            }
        }
        finally {
            try {
                H5.H5Tclose((int)tid);
            }
            catch (HDF5Exception ex) {}
        }
        dataset = tclass == HDF5Constants.H5T_COMPOUND ? new H5CompoundDS(this, name, path) : new H5ScalarDS(this, name, path);
        return dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeNode copyDatatype(Datatype srcType, H5Group pgroup, String dstName) throws Exception {
        H5Datatype datatype = null;
        int tid_src = -1;
        int gid_dst = -1;
        String path = null;
        DefaultMutableTreeNode newNode = null;
        path = pgroup.isRoot() ? "/" : pgroup.getPath() + pgroup.getName() + "/";
        if (dstName == null || dstName.equals("/") || dstName.length() < 1) {
            dstName = srcType.getName();
        }
        try {
            tid_src = srcType.open();
            gid_dst = pgroup.open();
            try {
                H5.H5Ocopy((int)tid_src, (String)".", (int)gid_dst, (String)dstName, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
            }
            catch (Exception ex) {
                // empty catch block
            }
            datatype = new H5Datatype(pgroup.getFileFormat(), dstName, path);
            pgroup.addToMemberList((HObject)datatype);
            newNode = new DefaultMutableTreeNode((Object)datatype);
        }
        finally {
            try {
                srcType.close(tid_src);
            }
            catch (Exception ex) {}
            try {
                pgroup.close(gid_dst);
            }
            catch (Exception ex) {}
        }
        return newNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeNode copyGroup(H5Group srcGroup, H5Group pgroup, String dstName) throws Exception {
        H5Group group = null;
        DefaultMutableTreeNode newNode = null;
        int srcgid = -1;
        int dstgid = -1;
        String gname = null;
        String path = null;
        path = pgroup.isRoot() ? "/" : pgroup.getPath() + pgroup.getName() + "/";
        if (dstName == null || dstName.equals("/") || dstName.length() < 1) {
            dstName = srcGroup.getName();
        }
        gname = path + dstName;
        try {
            srcgid = srcGroup.open();
            dstgid = pgroup.open();
            try {
                H5.H5Ocopy((int)srcgid, (String)".", (int)dstgid, (String)dstName, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            group = new H5Group(pgroup.getFileFormat(), dstName, path, pgroup);
            newNode = new DefaultMutableTreeNode((Object)group){
                private static final long serialVersionUID = -4981107816640372359L;

                @Override
                public boolean isLeaf() {
                    return false;
                }
            };
            this.depth_first(newNode);
            pgroup.addToMemberList((HObject)group);
        }
        finally {
            try {
                srcGroup.close(srcgid);
            }
            catch (Exception ex) {}
            try {
                pgroup.close(dstgid);
            }
            catch (Exception ex) {}
        }
        return newNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private H5Group getGroup(int gid, String name, Group pGroup) throws HDF5Exception {
        String parentPath = null;
        String thisFullName = null;
        String memberFullName = null;
        if (pGroup == null) {
            name = "/";
            thisFullName = "/";
        } else {
            parentPath = pGroup.getFullName();
            thisFullName = parentPath == null || parentPath.equals("/") ? "/" + name : parentPath + "/" + name;
        }
        if (parentPath != null) {
            parentPath = parentPath.replaceAll("//", "/");
        }
        if (thisFullName != null) {
            thisFullName = thisFullName.replaceAll("//", "/");
        }
        H5Group group = new H5Group(this, name, parentPath, pGroup);
        H5G_info_t group_info = null;
        H5O_info_t obj_info = null;
        int oid = -1;
        String link_name = null;
        try {
            group_info = H5.H5Gget_info((int)gid);
        }
        catch (HDF5Exception ex) {
            // empty catch block
        }
        try {
            oid = H5.H5Oopen((int)gid, (String)thisFullName, (int)HDF5Constants.H5P_DEFAULT);
        }
        catch (HDF5Exception ex) {
            // empty catch block
        }
        int i = 0;
        while ((long)i < group_info.nlinks) {
            block24: {
                try {
                    link_name = H5.H5Lget_name_by_idx((int)gid, (String)thisFullName, (int)HDF5Constants.H5_INDEX_NAME, (int)HDF5Constants.H5_ITER_INC, (long)i, (int)HDF5Constants.H5P_DEFAULT);
                    obj_info = H5.H5Oget_info_by_idx((int)oid, (String)thisFullName, (int)HDF5Constants.H5_INDEX_NAME, (int)HDF5Constants.H5_ITER_INC, (long)i, (int)HDF5Constants.H5P_DEFAULT);
                }
                catch (HDF5Exception ex) {
                    ex.printStackTrace();
                    break block24;
                }
                if (obj_info.type == HDF5Constants.H5O_TYPE_GROUP) {
                    H5Group g = new H5Group(this, link_name, thisFullName, group);
                    group.addToMemberList((HObject)g);
                } else if (obj_info.type == HDF5Constants.H5O_TYPE_DATASET) {
                    int did = -1;
                    Dataset d = null;
                    memberFullName = thisFullName == null || thisFullName.equals("/") ? "/" + link_name : thisFullName + "/" + link_name;
                    try {
                        did = H5.H5Dopen((int)this.fid, (String)memberFullName, (int)HDF5Constants.H5P_DEFAULT);
                        d = this.getDataset(did, link_name, thisFullName);
                    }
                    finally {
                        try {
                            H5.H5Dclose((int)did);
                        }
                        catch (HDF5Exception ex) {}
                    }
                    group.addToMemberList((HObject)d);
                }
            }
            ++i;
        }
        try {
            if (oid >= 0) {
                H5.H5Oclose((int)oid);
            }
        }
        catch (HDF5Exception ex) {
            // empty catch block
        }
        return group;
    }

    public static String getLinkTargetName(HObject obj) throws Exception {
        String[] link_value = new String[]{null, null};
        String targetObjName = null;
        if (obj == null) {
            return null;
        }
        H5L_info_t link_info = null;
        try {
            link_info = H5.H5Lget_info((int)obj.getFID(), (String)obj.getFullName(), (int)HDF5Constants.H5P_DEFAULT);
        }
        catch (Throwable err) {
            // empty catch block
        }
        if (link_info != null && (link_info.type == HDF5Constants.H5L_TYPE_SOFT || link_info.type == HDF5Constants.H5L_TYPE_EXTERNAL)) {
            try {
                H5.H5Lget_val((int)obj.getFID(), (String)obj.getFullName(), (String[])link_value, (int)HDF5Constants.H5P_DEFAULT);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (link_info.type == HDF5Constants.H5L_TYPE_SOFT) {
                targetObjName = link_value[0];
            } else if (link_info.type == HDF5Constants.H5L_TYPE_EXTERNAL) {
                targetObjName = link_value[1] + "://" + link_value[0];
            }
        }
        return targetObjName;
    }

    public void renameAttribute(HObject obj, String oldAttrName, String newAttrName) throws Exception {
        if (!this.attrFlag) {
            this.attrFlag = true;
            H5.H5Arename_by_name((int)obj.getFID(), (String)obj.getName(), (String)oldAttrName, (String)newAttrName, (int)HDF5Constants.H5P_DEFAULT);
        }
    }

    public static void renameObject(HObject obj, String newName) throws Exception {
        String currentFullPath = obj.getPath() + obj.getName();
        String newFullPath = obj.getPath() + newName;
        currentFullPath = currentFullPath.replaceAll("//", "/");
        newFullPath = newFullPath.replaceAll("//", "/");
        if (currentFullPath.equals("/")) {
            throw new HDF5Exception("Can't rename the root group.");
        }
        if (currentFullPath.equals(newFullPath)) {
            throw new HDF5Exception("The new name is the same as the current name.");
        }
        H5.H5Lmove((int)obj.getFID(), (String)currentFullPath, (int)obj.getFID(), (String)newFullPath, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
    }
}

