/*
 * Decompiled with CFR 0.152.
 */
package Jama;

import Jama.Matrix;
import java.io.Serializable;

public class QRDecomposition
implements Serializable {
    private float[][] QR;
    private int m;
    private int n;
    private float[] Rdiag;

    public QRDecomposition(Matrix A) {
        this.QR = A.getArrayCopy();
        this.m = A.getRowDimension();
        this.n = A.getColumnDimension();
        this.Rdiag = new float[this.n];
        for (int k = 0; k < this.n; ++k) {
            int i;
            float nrm = 0.0f;
            for (i = k; i < this.m; ++i) {
                nrm = (float)Math.hypot(nrm, this.QR[i][k]);
            }
            if ((double)nrm != 0.0) {
                if (this.QR[k][k] < 0.0f) {
                    nrm = -nrm;
                }
                for (i = k; i < this.m; ++i) {
                    float[] fArray = this.QR[i];
                    int n = k;
                    fArray[n] = fArray[n] / nrm;
                }
                float[] fArray = this.QR[k];
                int n = k;
                fArray[n] = (float)((double)fArray[n] + 1.0);
                for (int j = k + 1; j < this.n; ++j) {
                    int i2;
                    float s = 0.0f;
                    for (i2 = k; i2 < this.m; ++i2) {
                        s += this.QR[i2][k] * this.QR[i2][j];
                    }
                    s = -s / this.QR[k][k];
                    for (i2 = k; i2 < this.m; ++i2) {
                        float[] fArray2 = this.QR[i2];
                        int n2 = j;
                        fArray2[n2] = fArray2[n2] + s * this.QR[i2][k];
                    }
                }
            }
            this.Rdiag[k] = -nrm;
        }
    }

    public boolean isFullRank() {
        for (int j = 0; j < this.n; ++j) {
            if (this.Rdiag[j] != 0.0f) continue;
            return false;
        }
        return true;
    }

    public Matrix getH() {
        Matrix X = new Matrix(this.m, this.n);
        float[][] H = X.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                H[i][j] = i >= j ? this.QR[i][j] : 0.0f;
            }
        }
        return X;
    }

    public Matrix getR() {
        Matrix X = new Matrix(this.n, this.n);
        float[][] R = X.getArray();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                R[i][j] = i < j ? this.QR[i][j] : (i == j ? this.Rdiag[i] : 0.0f);
            }
        }
        return X;
    }

    public Matrix getQ() {
        Matrix X = new Matrix(this.m, this.n);
        float[][] Q = X.getArray();
        for (int k = this.n - 1; k >= 0; --k) {
            for (int i = 0; i < this.m; ++i) {
                Q[i][k] = 0.0f;
            }
            Q[k][k] = 1.0f;
            for (int j = k; j < this.n; ++j) {
                int i;
                if (this.QR[k][k] == 0.0f) continue;
                float s = 0.0f;
                for (i = k; i < this.m; ++i) {
                    s += this.QR[i][k] * Q[i][j];
                }
                s = -s / this.QR[k][k];
                for (i = k; i < this.m; ++i) {
                    float[] fArray = Q[i];
                    int n = j;
                    fArray[n] = fArray[n] + s * this.QR[i][k];
                }
            }
        }
        return X;
    }

    public Matrix solve(Matrix B) {
        int j;
        int k;
        if (B.getRowDimension() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isFullRank()) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        int nx = B.getColumnDimension();
        float[][] X = B.getArrayCopy();
        for (k = 0; k < this.n; ++k) {
            for (j = 0; j < nx; ++j) {
                int i;
                float s = 0.0f;
                for (i = k; i < this.m; ++i) {
                    s += this.QR[i][k] * X[i][j];
                }
                s = -s / this.QR[k][k];
                for (i = k; i < this.m; ++i) {
                    float[] fArray = X[i];
                    int n = j;
                    fArray[n] = fArray[n] + s * this.QR[i][k];
                }
            }
        }
        for (k = this.n - 1; k >= 0; --k) {
            j = 0;
            while (j < nx) {
                float[] fArray = X[k];
                int n = j++;
                fArray[n] = fArray[n] / this.Rdiag[k];
            }
            for (int i = 0; i < k; ++i) {
                for (int j2 = 0; j2 < nx; ++j2) {
                    float[] fArray = X[i];
                    int n = j2;
                    fArray[n] = fArray[n] - X[k][j2] * this.QR[i][k];
                }
            }
        }
        return new Matrix(X, this.n, nx).getMatrix(0, this.n - 1, 0, nx - 1);
    }
}

