/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.application;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.Identifier;

public class CccleDrugFormat {
    public static void main(String[] args) throws IOException {
        int i;
        String[][] data = ((Array2DContentHandler)new ExcelReader("C:\\Users\\jgould\\Documents\\datasets\\ccle.xlsx", new Array2DContentHandler()).getContentHandler()).getData();
        TreeSet<String> cells = new TreeSet<String>();
        TreeSet<String> drugs = new TreeSet<String>();
        HashMap<Identifier<Object>, Float> cellDrugMetricToValue = new HashMap<Identifier<Object>, Float>();
        int drugColumn = 1;
        int cellColumn = 0;
        String[] header = data[0];
        ArrayList<String> metrics = new ArrayList<String>();
        for (i = 2; i < header.length; ++i) {
            metrics.add(header[i]);
        }
        for (i = 1; i < data.length; ++i) {
            String[] row = data[i];
            String cell = row[cellColumn];
            String baseDrug = row[drugColumn];
            for (int k = 2; k < row.length; ++k) {
                String drug = baseDrug + " " + header[k];
                drugs.add(drug);
                cellDrugMetricToValue.put(new Identifier<Object>(cell, drug), Float.valueOf(ParserHelper.parseFloatNaN(row[k])));
            }
            cells.add(cell);
        }
        PrintWriter pw = new PrintWriter("C:\\Users\\jgould\\Documents\\datasets\\ccle-drugs-formatted.tsv");
        pw.print("Id");
        String[] drugArray = drugs.toArray(new String[0]);
        String[] cellArray = cells.toArray(new String[0]);
        for (String drug : drugArray) {
            pw.print("\t");
            pw.print(drug);
        }
        pw.println();
        for (int i2 = 1; i2 < cellArray.length; ++i2) {
            String cell = cellArray[i2];
            pw.print(cell);
            for (int j = 0; j < drugArray.length; ++j) {
                String drug;
                pw.print("\t");
                drug = drugArray[j];
                Float val = (Float)cellDrugMetricToValue.get(new Identifier<Object>(cell, drug));
                if (val == null) continue;
                pw.print(val);
            }
            pw.println();
        }
        pw.close();
    }
}

