/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.application;

import com.google.common.base.Function;
import com.jidesoft.docking.DefaultDockableHolder;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.PopupMenuCustomizer;
import com.jidesoft.docking.event.DockableFrameEvent;
import com.jidesoft.docking.event.DockableFrameListener;
import com.jidesoft.swing.JideTabbedPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.io.FileUtils;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.DefaultViewableGENEETreeNode;
import org.broadinstitute.genee.application.DialogWindow;
import org.broadinstitute.genee.application.DockableFrameWindow;
import org.broadinstitute.genee.application.GENEETreeNode;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.application.GENEEWindowNotifier;
import org.broadinstitute.genee.application.HistoryPanel;
import org.broadinstitute.genee.application.OpenFileListener;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.application.RevealInFinder;
import org.broadinstitute.genee.application.ViewableGENEETreeNode;
import org.broadinstitute.genee.application.WindowManager;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.dnd.FileDrop;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.DisplayInfo;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.menu.GENEEMenuBar;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.jdesktop.swingx.util.OS;

public class DefaultWindowManager
implements WindowManager {
    public static final String DOCKABLE_FRAME_CLIENT_PROPERTY = "GENE-E.DockableFrame";
    public static final String MENU_BAR_CLIENT_PROPERTY = "GENE-E.menuBar";
    private GENEETreeNode activeNode;
    private DockingManager dockingManager;
    private JFrame frame;
    private MenuBarCreator menuBarCreator = new DefaultMenuBarCreator();

    public DefaultWindowManager() {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException("Can't use this window manager when headless.");
        }
    }

    @Override
    public GENEEWindow createInputWindow(Component parent, String name) {
        return this._createInputDialog(parent, name, null);
    }

    @Override
    public GENEEWindow createInputWindow(String name, GENEEWindowNotifier notifier) {
        return this._createInputDialog(null, name, notifier);
    }

    @Override
    public GENEEWindow createToolWindow(String title, int initSide, int initMode) {
        DockableFrameWindow window = new DockableFrameWindow(3, this.dockingManager, null, initSide, initMode, null);
        window.setTitle(title);
        window.setName(title);
        return window;
    }

    @Override
    public GENEEWindow createViewWindow(String name, GENEEWindowNotifier notifier) {
        return this.createViewWindow(name, 1, notifier, 8, -1, null);
    }

    public void debug() {
        List names = this.dockingManager.getAllFrameNames();
        for (String name : names) {
            DockableFrame f = this.dockingManager.getFrame(name);
            System.out.println(f.getTitle() + ", side=" + f.getContext().getCurrentDockSide());
        }
    }

    @Override
    public void delete(GENEETreeNode nodeToDelete, boolean fromDisk) {
        Enumeration<TreeNode> e = ((DefaultMutableTreeNode)((Object)nodeToDelete)).breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            Collection<String> keys;
            MutableTreeNode n = (MutableTreeNode)e.nextElement();
            if (n instanceof GENEETreeNode) {
                File file;
                if (fromDisk && (file = ((GENEETreeNode)n).getFile()) != null && file.exists()) {
                    if (file.isDirectory()) {
                        try {
                            FileUtils.deleteDirectory((File)file);
                        }
                        catch (IOException x) {
                            System.out.println("Unable to delete " + file);
                        }
                    } else if (!file.delete()) {
                        System.out.println("Unable to delete " + file);
                    }
                }
                if (n instanceof ViewableGENEETreeNode) {
                    ViewableGENEETreeNode viewableGENEETreeNode = (ViewableGENEETreeNode)n;
                    JMenuBar menuBar = (JMenuBar)viewableGENEETreeNode.getDisplayInfo().getComponent().getClientProperty(MENU_BAR_CLIENT_PROPERTY);
                    if (menuBar != null) {
                        int items = menuBar.getMenuCount();
                        for (int i = 0; i < items; ++i) {
                            JMenu menu = menuBar.getMenu(i);
                            menu.removeAll();
                        }
                        menuBar.removeAll();
                    }
                    viewableGENEETreeNode.getDisplayInfo().getComponent().putClientProperty(MENU_BAR_CLIENT_PROPERTY, null);
                }
                keys = this.getOpenedWindowKeys(n, this.dockingManager.getAllFrameNames());
                for (String key : keys) {
                    GENEEWindow window = this.getWindow(key);
                    this.dockingManager.removeFrame(key);
                    window.setVisible(false);
                    window.dispose();
                }
            }
            keys = this.getOpenedWindowKeys(nodeToDelete, this.dockingManager.getAllFrameNames());
            for (String key : keys) {
                GENEEWindow window = this.getWindow(key);
                this.dockingManager.removeFrame(key);
                window.setVisible(false);
                window.dispose();
            }
        }
        Application.getNavigator().delete(nodeToDelete);
        if (this.activeNode == nodeToDelete) {
            this.activeNode = null;
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
        System.gc();
        List keys = this.dockingManager.getAllFrameNames();
        boolean found = false;
        for (String key : keys) {
            DockableFrameWindow last = (DockableFrameWindow)this.dockingManager.getFrame(key);
            int type = (Integer)last.getClientProperty("type");
            if (type == 3) continue;
            ((GENEEWindow)this.dockingManager.getFrame(key)).activate();
            found = true;
            break;
        }
        if (!found) {
            JMenuBar mb = this.createNoDataMenuBar();
            this.setJMenuBar(mb);
        }
    }

    @Override
    public JMenuBar getMenuBar(GENEETreeNode node) {
        return this.menuBarCreator.getMenuBar(node);
    }

    @Override
    public GENEETreeNode getNode() {
        return this.activeNode;
    }

    @Override
    public Collection<String> getOpenedWindowKeys(TreeNode node) {
        Collection keys = this.dockingManager.getAllFrames();
        return this.getOpenedWindowKeys(node, keys);
    }

    @Override
    public Window getWindow() {
        return this.frame;
    }

    @Override
    public GENEEWindow getWindow(String key) {
        return (GENEEWindow)this.dockingManager.getFrame(key);
    }

    @Override
    public void init() {
        DefaultDockableHolder holder = new DefaultDockableHolder(Application.getName());
        this.frame = holder;
        new FileDrop(this.frame, new FileDrop.Listener(){

            @Override
            public void filesDropped(File[] files) {
                OpenFileListener[] listenerList;
                String[] paths = new String[files.length];
                for (int i = 0; i < paths.length; ++i) {
                    paths[i] = IOUtil.getPath(files[i]);
                }
                for (OpenFileListener l : listenerList = Application.getOpenFileActionListeners()) {
                    l.open(paths, null);
                }
            }
        });
        this.dockingManager = holder.getDockingManager();
        if (OS.isMacOSX()) {
            this.dockingManager.setFloatingContainerType(2);
        }
        if (!OS.isWindows()) {
            this.dockingManager.setOutlineMode(0);
        }
        this.dockingManager.setProfileKey(Application.getName());
        this.dockingManager.beginLoadLayoutData();
        this.dockingManager.setShowWorkspace(false);
        this.dockingManager.getWorkspace().setAcceptDockableFrame(false);
        this.dockingManager.setSidebarRollover(false);
        this.dockingManager.setInitSplitPriority(0);
        this.dockingManager.getWorkspace().setAdjustOpacityOnFly(true);
        this.dockingManager.setTabbedPaneCustomizer(new DockingManager.TabbedPaneCustomizer(){

            public void customize(JideTabbedPane tp) {
                tp.setTabPlacement(1);
                tp.setShowCloseButtonOnTab(true);
                tp.setShowCloseButton(true);
                tp.setShowCloseButtonOnSelectedTab(true);
            }
        });
        this.dockingManager.setPopupMenuCustomizer(new PopupMenuCustomizer(){

            public void customizePopupMenu(JPopupMenu popup, DockingManager manager, DockableFrame dockableFrame, boolean onTab) {
                DefaultWindowManager.this._customizePopupMenu(popup, manager, dockableFrame, onTab);
            }
        });
        this.dockingManager.addDockableFrameListener(new DockableFrameListener(){

            public void dockableFrameActivated(DockableFrameEvent e) {
                DockableFrame df = e.getDockableFrame();
                if (df instanceof DockableFrameWindow) {
                    ((DockableFrameWindow)df).setActiveNode();
                }
            }

            public void dockableFrameAdded(DockableFrameEvent e) {
            }

            public void dockableFrameAutohidden(DockableFrameEvent e) {
                DockableFrame df = e.getDockableFrame();
                if (df instanceof DockableFrameWindow) {
                    ((DockableFrameWindow)df).dockableFrameAutohidden();
                }
            }

            public void dockableFrameAutohideShowing(DockableFrameEvent e) {
            }

            public void dockableFrameDeactivated(DockableFrameEvent e) {
            }

            public void dockableFrameDocked(DockableFrameEvent e) {
            }

            public void dockableFrameFloating(DockableFrameEvent e) {
            }

            public void dockableFrameHidden(DockableFrameEvent e) {
                DockableFrame df = e.getDockableFrame();
                if (df instanceof DockableFrameWindow) {
                    ((DockableFrameWindow)df).dockableFrameHidden();
                }
            }

            public void dockableFrameMaximized(DockableFrameEvent e) {
            }

            public void dockableFrameMoved(DockableFrameEvent e) {
            }

            public void dockableFrameRemoved(DockableFrameEvent e) {
                DockableFrame df = e.getDockableFrame();
                if (df instanceof DockableFrameWindow) {
                    ((DockableFrameWindow)df).dockableFrameRemoved();
                }
            }

            public void dockableFrameRestored(DockableFrameEvent e) {
            }

            public void dockableFrameShown(DockableFrameEvent e) {
            }

            public void dockableFrameTabHidden(DockableFrameEvent e) {
            }

            public void dockableFrameTabShown(DockableFrameEvent e) {
            }

            public void dockableFrameTransferred(DockableFrameEvent e) {
            }
        });
        this.dockingManager.loadLayoutData();
        this.frame.setExtendedState(6);
        this.setJMenuBar(this.createNoDataMenuBar());
    }

    @Override
    public void open(GENEETreeNode node) {
        GENEEWindow window;
        this.activeNode = node;
        Collection<String> openedWindowKeys = this.getOpenedWindowKeys(node);
        boolean found = false;
        for (String key : openedWindowKeys) {
            int type;
            window = this.getWindow(key);
            if (!(window instanceof WMWindow) || (type = ((WMWindow)window).getWindowType()) != 0) continue;
            found = true;
            window.activate();
            break;
        }
        if (!found && node instanceof ViewableGENEETreeNode) {
            DisplayInfo displayInfo = ((ViewableGENEETreeNode)node).getDisplayInfo();
            ViewableGENEETreeNode vnode = (ViewableGENEETreeNode)node;
            window = this.createViewWindow("", 0, null, 4, -1, node);
            window.getContentPane().add(displayInfo.getComponent());
            displayInfo.getComponent().putClientProperty(DOCKABLE_FRAME_CLIENT_PROPERTY, window);
            String parentFrameKey = vnode.getParentFrameKey();
            if (!vnode.isOpened() && parentFrameKey != null) {
                try {
                    this.dockingManager.moveFrame(window.getKey(), parentFrameKey);
                }
                catch (IllegalArgumentException x) {
                    // empty catch block
                }
            }
            this.dockingManager.activateFrame(window.getKey());
            vnode.setOpened(true);
        }
    }

    @Override
    public void setJMenuBar(JMenuBar menuBar) {
        if (menuBar != null) {
            if (menuBar instanceof GENEEMenuBar) {
                ((GENEEMenuBar)menuBar).rebuild();
            }
            this.frame.setJMenuBar(menuBar);
            ((Component)this.frame).invalidate();
            ((Component)this.frame).validate();
            menuBar.revalidate();
            menuBar.repaint();
            this.frame.getContentPane().requestFocusInWindow();
        }
    }

    public void setMenuBarCreator(MenuBarCreator menuBarCreator) {
        this.menuBarCreator = menuBarCreator;
    }

    @Override
    public void setName(GENEETreeNode node, String name) {
        Application.getNavigator().setNodeName(node, name);
        name = node.toString();
        Collection<String> keys = this.getOpenedWindowKeys(node);
        for (String key : keys) {
            DockableFrameWindow dockableFrame = (DockableFrameWindow)this.dockingManager.getFrame(key);
            if (dockableFrame.getWindowType() != 0) continue;
            dockableFrame.setTitle(name);
        }
    }

    @Override
    public void setNode(GENEETreeNode node) {
        this.activeNode = node;
    }

    public void showHistoryDialog() {
        this.showHistoryDialog(this.getNode());
    }

    public void showHistoryDialog(GENEETreeNode node) {
        if (node instanceof ViewableGENEETreeNode) {
            HistoryPanel historyPanel = new HistoryPanel((ViewableGENEETreeNode)node, false, new Function<ProjectGENEEResultTreeNode, Boolean>(){

                public Boolean apply(ProjectGENEEResultTreeNode node) {
                    node.getDisplayInfo().getComponent().requestFocusInWindow();
                    return true;
                }
            });
            GENEEWindow dialog = Application.createDialog(node.toString() + " History");
            dialog.getContentPane().add(historyPanel);
            dialog.pack();
            dialog.setVisible(true);
        }
    }

    private GENEEWindow _createInputDialog(Component parent, String name, GENEEWindowNotifier notifier) {
        Container ancestor = parent == null ? this.frame : UIUtil.getTopLevelAncestor(parent);
        DialogWindow window = null;
        window = ancestor instanceof Dialog ? new DialogWindow((Window)((Dialog)ancestor), 2, notifier) : (ancestor instanceof Frame ? new DialogWindow((Window)ancestor, 2, notifier) : new DialogWindow((Window)this.frame, 2, notifier));
        String title = name;
        window.setTitle(title);
        window.setName(name);
        UIUtil.setDialogBorder((JComponent)window.getContentPane());
        window.pack();
        return window;
    }

    private void _customizePopupMenu(JPopupMenu menu, DockingManager manager, final DockableFrame dockableFrame, boolean isOnTab) {
        ProjectGENEEResultTreeNode pi;
        List<Action> popupComponents;
        boolean showFloatItem;
        int nitems = menu.getComponentCount();
        for (int i = 0; i < nitems; ++i) {
            menu.remove(0);
        }
        Integer type = (Integer)dockableFrame.getClientProperty((Object)"type");
        boolean bl = showFloatItem = dockableFrame.isDocked() || dockableFrame.isAutohide() || dockableFrame.isAutohideShowing();
        if (!dockableFrame.isAutohide()) {
            menu.add(new AbstractAction("Close" + (dockableFrame.isDocked() ? " Tab" : "")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dockableFrame.getCloseAction().actionPerformed(e);
                }
            });
            menu.addSeparator();
        }
        if (type != null && (type == 1 || type == 0) && dockableFrame.isFloated()) {
            menu.add(new AbstractAction("Dock"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((DockableFrameWindow)dockableFrame).dockFrame();
                }
            });
            menu.addSeparator();
        }
        if (showFloatItem) {
            menu.add(new AbstractAction("Float"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dockableFrame.setFloatable(true);
                    dockableFrame.getDockingManager().floatFrame(dockableFrame.getKey(), dockableFrame.getUndockedBounds(), true);
                }
            });
        }
        if (type != null && type == 3) {
            return;
        }
        if (showFloatItem) {
            menu.addSeparator();
        }
        menu.add(new AbstractAction("Edit Title"){

            @Override
            public void actionPerformed(ActionEvent e) {
                String title = dockableFrame.getTitle();
                int index = title.indexOf("\u00d7");
                if (index != -1 && (index = title.lastIndexOf(40, index)) != -1) {
                    title = title.substring(0, index - 1);
                }
                if ((title = UIUtil.showInputDialog((Component)dockableFrame, "Enter new title", title)) != null && title.length() > 0) {
                    GENEETreeNode dockableFrameNode = ((DockableFrameWindow)dockableFrame).getNode();
                    DefaultWindowManager.this.setName(dockableFrameNode, title);
                }
            }
        });
        if (RevealInFinder.isEnabled(this.activeNode)) {
            menu.addSeparator();
            menu.add(new RevealInFinder(this.activeNode));
        }
        if (!(this.activeNode instanceof ViewableGENEETreeNode)) {
            return;
        }
        ViewableGENEETreeNode selectedNode = (ViewableGENEETreeNode)this.activeNode;
        if (type != null && type == 0) {
            menu.addSeparator();
            final WeakReference<ViewableGENEETreeNode> wr1 = new WeakReference<ViewableGENEETreeNode>(selectedNode);
            menu.add(new AbstractAction("Show In Navigator"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Application.getNavigator().setSelectedNode((TreeNode)wr1.get(), false);
                    DefaultWindowManager.this.dockingManager.activateFrame("0");
                }
            });
            menu.addSeparator();
            final WeakReference<ViewableGENEETreeNode> wr = new WeakReference<ViewableGENEETreeNode>(selectedNode);
            menu.add(new AbstractAction("Delete"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultWindowManager.promptToDelete((TreeNode)wr.get());
                }
            });
        }
        if (selectedNode instanceof ProjectGENEEResultTreeNode && (popupComponents = (pi = (ProjectGENEEResultTreeNode)selectedNode).getPopupActions()) != null) {
            for (Action popupComponent : popupComponents) {
                if (popupComponent == null) {
                    menu.addSeparator();
                    continue;
                }
                menu.add(popupComponent);
            }
        }
    }

    private JMenuBar createNoDataMenuBar() {
        return this.getMenuBar(new DefaultViewableGENEETreeNode(new DisplayInfo(new HeatMapPanel(new DefaultProject(new RowMajorArray2DDataset("Dummy", 0, 0)))), null));
    }

    private DockableFrameWindow createViewWindow(String baseName, int type, GENEEWindowNotifier notifier, int dockSide, int initMode, GENEETreeNode node) {
        if (node == null) {
            node = this.getNode();
        }
        String baseTitle = "";
        if (node != null) {
            baseTitle = node.toString();
        }
        if (baseName != null && baseName.length() > 0) {
            baseTitle = baseTitle + ("".equals(baseTitle) ? "" : " - ") + baseName;
        }
        String title = baseTitle;
        Collection<String> keys = this.getOpenedWindowKeys(node);
        if (keys != null && keys.size() > 0) {
            int windowNumber = 0;
            boolean found = false;
            for (String key : keys) {
                GENEEWindow window = this.getWindow(key);
                if (baseName == null || !(window instanceof WMWindow) || !baseName.equals(((WMWindow)window).getBaseName())) continue;
                found = true;
                String openedWindowTitle = window.getTitle();
                int idx = openedWindowTitle == null ? -1 : openedWindowTitle.lastIndexOf(46);
                if (idx == -1) continue;
                try {
                    String numberString = openedWindowTitle.substring(idx + 1);
                    windowNumber = Math.max(Integer.parseInt(numberString), windowNumber);
                }
                catch (NumberFormatException nfe) {}
            }
            if (found) {
                title = baseTitle + "." + (windowNumber + 1);
            }
        }
        DockableFrameWindow window = new DockableFrameWindow(type, this.dockingManager, notifier, dockSide, initMode, node);
        window.setTitle(title);
        window.setName(title);
        window.setBaseName(baseName);
        return window;
    }

    private Collection<String> getOpenedWindowKeys(TreeNode node, Collection<String> allKeys) {
        if (node != null) {
            HashSet<String> openedKeys = new HashSet<String>();
            for (String key : allKeys) {
                WMWindow wmWindow;
                GENEEWindow window = this.getWindow(key);
                if (!(window instanceof WMWindow) || (wmWindow = (WMWindow)window).getNode() != node) continue;
                openedKeys.add(key);
            }
            return openedKeys;
        }
        return allKeys;
    }

    public static void promptToDelete(TreeNode ... nodes) {
        String message = nodes.length == 1 ? "Are you sure you want to delete " + nodes[0].toString() + "?" : "Are you sure you want to delete the " + nodes.length + " selected resources?";
        if (!UIUtil.showOkCancelDialog(UIUtil.getCurrentFrame(), message, "")) {
            return;
        }
        for (TreeNode node : nodes) {
            Application.getWindowManager().delete((GENEETreeNode)node, false);
        }
    }

    private static class DefaultMenuBarCreator
    implements MenuBarCreator {
        @Override
        public JMenuBar getMenuBar(GENEETreeNode node) {
            JMenuBar menuBar = null;
            if (node instanceof ViewableGENEETreeNode) {
                DisplayInfo displayInfo = ((ViewableGENEETreeNode)node).getDisplayInfo();
                JComponent c = displayInfo.getComponent();
                JMenuBar jMenuBar = menuBar = c != null ? (JMenuBar)c.getClientProperty(DefaultWindowManager.MENU_BAR_CLIENT_PROPERTY) : null;
                if (menuBar == null && c instanceof HeatMapPanel) {
                    menuBar = new GENEEMenuBar((HeatMapPanel)c);
                    c.putClientProperty(DefaultWindowManager.MENU_BAR_CLIENT_PROPERTY, menuBar);
                }
            }
            return menuBar;
        }
    }

    public static interface WMWindow
    extends GENEEWindow {
        public static final int TYPE_INPUT_DIALOG = 2;
        public static final int TYPE_PRIMARY_VIEW_WINDOW = 0;
        public static final int TYPE_SECONDARY_VIEW_WINDOW = 1;
        public static final int TYPE_TOOL_WINDOW = 3;

        public int getWindowType();

        public Object getBaseName();

        public GENEETreeNode getNode();

        public boolean isShowing();

        public void setBaseName(String var1);

        public void setName(String var1);

        public void setTitle(String var1);
    }

    public static interface MenuBarCreator {
        public JMenuBar getMenuBar(GENEETreeNode var1);
    }
}

