/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.application;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.DefaultWindowManager;
import org.broadinstitute.genee.application.GENEETreeNode;
import org.broadinstitute.genee.application.GENEEWindowNotifier;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.HistoryAuditTrail;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.application.ViewableGENEETreeNode;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.GENEEResultNodeGroup;
import org.broadinstitute.genee.heatmap.HeatMapPanel;

public class DockableFrameWindow
extends DockableFrame
implements DefaultWindowManager.WMWindow {
    private String baseName;
    private GENEEWindowNotifier notifier;
    private WeakReference<GENEETreeNode> nodeWeakRef;
    private boolean activated;
    private static int counter = 0;
    public static final String TYPE_CLIENT_PROPERTY = "type";
    private boolean hasNode = true;

    public DockableFrameWindow(int type, DockingManager dockingManager, GENEEWindowNotifier notifier, int initSide, int initMode, GENEETreeNode node) {
        super(String.valueOf(counter++));
        if (dockingManager == null) {
            throw new NullPointerException("dockingManager is null");
        }
        this.notifier = notifier;
        this.putClientProperty(TYPE_CLIENT_PROPERTY, type);
        if (type == 3) {
            this.setDockable(false);
            this.getContext().setInitSide(initSide);
            this.getContext().setInitMode(initMode);
            this.getContext().setInitIndex(0);
            Dimension maxSize = UIUtil.getMaximumWindowSize();
            Rectangle undockedBounds = new Rectangle();
            undockedBounds.width = 200;
            undockedBounds.height = 200;
            undockedBounds.x = initSide == 4 ? maxSize.width - UIUtil.getScreenInsets().right - undockedBounds.width - 2 : UIUtil.getScreenInsets().right;
            undockedBounds.y = UIUtil.getScreenInsets().top + (initMode == 1 ? 120 : 0);
            this.setUndockedBounds(undockedBounds);
            this.setDockedWidth(200);
            int floatingEscapeAction = 2;
            this.setDefaultCloseAction(0);
            this.setDefaultEscapeAction(floatingEscapeAction);
            this.setCloseAction(new AbstractAction("Close"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DockableFrameWindow.this.getDockingManager().autohideFrame(DockableFrameWindow.this.getKey(), DockableFrameWindow.this.getInitSide(), DockableFrameWindow.this.getInitIndex());
                }
            });
        } else {
            int floatingEscapeAction = 3;
            if (type == 1) {
                this.getContext().setInitSide(initSide);
                this.getContext().setInitMode(1);
                this.setDefaultEscapeAction(3);
                this.setDefaultCloseAction(2);
            } else if (type == 0) {
                this.getContext().setInitSide(initSide);
                this.getContext().setInitMode(4);
                this.setDefaultEscapeAction(1);
                this.setDefaultCloseAction(2);
            }
            this.getContext().setInitIndex(0);
            this.setWindowUndockedBounds(-1, -1);
        }
        this.hasNode = node != null;
        this.nodeWeakRef = this.hasNode ? new WeakReference<GENEETreeNode>(node) : null;
        this.setFrameIcon(null);
        Action closeAction = this.getCloseAction();
        this.getInputMap(2).put(KeyStroke.getKeyStroke(87, UIUtil.getMenuShortcutKeyMask()), "closeWindow");
        this.getActionMap().put("closeWindow", closeAction);
        dockingManager.addFrame((DockableFrame)this);
        if (type != 3) {
            this.activate();
        }
    }

    public void setWindowUndockedBounds(int width, int height) {
        Dimension maxWindowSize = UIUtil.getMaximumWindowSize();
        Rectangle undockedBounds = new Rectangle(0, 0, width != -1 ? width : (int)((double)maxWindowSize.width / 1.8), height != -1 ? height : (int)((double)maxWindowSize.height / 1.8));
        undockedBounds.x = maxWindowSize.width - undockedBounds.width - UIUtil.getScreenInsets().right - 12;
        undockedBounds.y = UIUtil.getScreenInsets().top + 30;
        this.setUndockedBounds(undockedBounds);
    }

    public void dockableFrameAutohidden() {
        this.setDefaultEscapeAction(1);
    }

    @Override
    public boolean activate() {
        this.getDockingManager().showFrame(this.getKey(), true);
        return true;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    public GENEETreeNode getNode() {
        return this.nodeWeakRef != null ? (GENEETreeNode)this.nodeWeakRef.get() : null;
    }

    public String getToolTipText() {
        GENEETreeNode node;
        Integer type = (Integer)this.getClientProperty(TYPE_CLIENT_PROPERTY);
        if (type == null) {
            return null;
        }
        if ((type == 0 || type == 1) && (node = this.getNode()) instanceof ViewableGENEETreeNode) {
            HistoryAuditTrail auditTrail = ((ViewableGENEETreeNode)node).getAuditTrail();
            StringBuilder sb = new StringBuilder();
            List<History> trail = auditTrail.getTrail();
            for (int i = 0; i < trail.size(); ++i) {
                History hist = trail.get(i);
                if (hist == null) continue;
                if (sb.length() > 0) {
                    sb.append(" > ");
                }
                sb.append(hist.getOperationName());
            }
            return sb.toString();
        }
        return super.getToolTipText();
    }

    @Override
    public int getWindowType() {
        return (Integer)this.getClientProperty(TYPE_CLIENT_PROPERTY);
    }

    @Override
    public void pack() {
    }

    @Override
    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        this.setTabTitle(title);
        this.setSideTitle(title);
    }

    void dockFrame() {
        this.getDockingManager().dockFrame(this.getKey(), this.getInitSide(), this.getInitIndex());
        this.getDockingManager().activateFrame(this.getKey());
    }

    public void dockableFrameHidden() {
        this.notifyHidden();
    }

    private void notifyActivated() {
        if (!this.activated && this.notifier != null) {
            this.activated = true;
            this.notifier.notifyShowing();
        }
    }

    private void notifyHidden() {
        if (this.activated && this.notifier != null) {
            this.activated = false;
            this.notifier.notifyHidden();
        }
    }

    public void dockableFrameRemoved() {
        GENEEResultNodeGroup group;
        GENEETreeNode node = this.getNode();
        if (node instanceof ViewableGENEETreeNode && ((ViewableGENEETreeNode)node).getDisplayInfo().getComponent() instanceof HeatMapPanel && (group = ((ProjectGENEEResultTreeNode)node).getGroup()) != null) {
            if (group.getParentNode() == node) {
                group.setParentNode(null);
            } else {
                group.removeChild((ProjectGENEEResultTreeNode)node);
            }
        }
        node = null;
        this.getContentPane().removeAll();
        this.notifier = null;
        this.dispose();
    }

    public void setActiveNode() {
        GENEETreeNode node;
        if (this.hasNode && (node = this.getNode()) != null) {
            this.notifyActivated();
            Application.getWindowManager().setNode(node);
            JMenuBar menuBar = Application.getWindowManager().getMenuBar(node);
            if (menuBar != null) {
                Application.getWindowManager().setJMenuBar(menuBar);
            } else {
                System.out.println("No menu bar for " + node);
            }
        }
    }
}

