/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.application;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class JarClassLoader
extends URLClassLoader {
    private Method method;

    public JarClassLoader(URL[] urls) {
        super(urls);
        try {
            Method[] methods = this.getClass().getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!"findBootstrapClassOrNull".equals(methods[i].getName())) continue;
                this.method = methods[i];
                this.method.setAccessible(true);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return this.loadJarClass(name, resolve);
        }
        catch (Exception cnfe) {
            return super.loadClass(name);
        }
    }

    private synchronized Class<?> loadJarClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = (Class)this.method.invoke((Object)this, name);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (c == null) {
                c = this.findClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }
}

